/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.databinding.types.soapencoding;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axis2.databinding.ADBBean;
import org.apache.axis2.databinding.ADBDataSource;
import org.apache.axis2.databinding.ADBException;
import org.apache.axis2.databinding.types.Id;
import org.apache.axis2.databinding.types.URI;
import org.apache.axis2.databinding.types.soapencoding.ExtensionMapper;
import org.apache.axis2.databinding.utils.BeanUtil;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.axis2.databinding.utils.NamedStaxOMBuilder;
import org.apache.axis2.databinding.utils.reader.ADBXMLStreamReaderImpl;
import org.apache.axis2.util.StreamWrapper;

public class Struct
implements ADBBean {
    protected OMElement[] localExtraElement;
    protected boolean localExtraElementTracker = false;
    protected Id localId;
    protected URI localHref;

    private static String generatePrefix(String namespace) {
        if (namespace.equals("http://schemas.xmlsoap.org/soap/encoding/")) {
            return "SOAP-ENC";
        }
        return BeanUtil.getUniquePrefix();
    }

    public OMElement[] getExtraElement() {
        return this.localExtraElement;
    }

    protected void validateExtraElement(OMElement[] param) {
    }

    public void setExtraElement(OMElement[] param) {
        this.validateExtraElement(param);
        this.localExtraElementTracker = param != null;
        this.localExtraElement = param;
    }

    public void addExtraElement(OMElement param) {
        if (this.localExtraElement == null) {
            this.localExtraElement = new OMElement[0];
        }
        this.localExtraElementTracker = true;
        List list = ConverterUtil.toList(this.localExtraElement);
        list.add(param);
        this.localExtraElement = list.toArray(new OMElement[list.size()]);
    }

    public Id getId() {
        return this.localId;
    }

    public void setId(Id param) {
        this.localId = param;
    }

    public URI getHref() {
        return this.localHref;
    }

    public void setHref(URI param) {
        this.localHref = param;
    }

    public static boolean isReaderMTOMAware(XMLStreamReader reader) {
        boolean isReaderMTOMAware = false;
        try {
            isReaderMTOMAware = Boolean.TRUE.equals(reader.getProperty("IsDatahandlersAwareParsing"));
        }
        catch (IllegalArgumentException e) {
            isReaderMTOMAware = false;
        }
        return isReaderMTOMAware;
    }

    @Override
    public OMElement getOMElement(QName parentQName, OMFactory factory) throws ADBException {
        ADBDataSource dataSource = new ADBDataSource(this, parentQName);
        return factory.createOMElement((OMDataSource)dataSource, parentQName);
    }

    @Override
    public void serialize(QName parentQName, XMLStreamWriter xmlWriter) throws XMLStreamException, ADBException {
        this.serialize(parentQName, xmlWriter, false);
    }

    @Override
    public void serialize(QName parentQName, XMLStreamWriter xmlWriter, boolean serializeType) throws XMLStreamException, ADBException {
        String prefix = null;
        String namespace = null;
        prefix = parentQName.getPrefix();
        namespace = parentQName.getNamespaceURI();
        if (namespace != null && namespace.trim().length() > 0) {
            String writerPrefix = xmlWriter.getPrefix(namespace);
            if (writerPrefix != null) {
                xmlWriter.writeStartElement(namespace, parentQName.getLocalPart());
            } else {
                if (prefix == null) {
                    prefix = Struct.generatePrefix(namespace);
                }
                xmlWriter.writeStartElement(prefix, parentQName.getLocalPart(), namespace);
                xmlWriter.writeNamespace(prefix, namespace);
                xmlWriter.setPrefix(prefix, namespace);
            }
        } else {
            xmlWriter.writeStartElement(parentQName.getLocalPart());
        }
        if (serializeType) {
            String namespacePrefix = this.registerPrefix(xmlWriter, "http://schemas.xmlsoap.org/soap/encoding/");
            if (namespacePrefix != null && namespacePrefix.trim().length() > 0) {
                this.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", namespacePrefix + ":Struct", xmlWriter);
            } else {
                this.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", "Struct", xmlWriter);
            }
        }
        if (this.localId != null) {
            this.writeAttribute("", "id", ConverterUtil.convertToString(this.localId), xmlWriter);
        }
        if (this.localHref != null) {
            this.writeAttribute("", "href", ConverterUtil.convertToString(this.localHref), xmlWriter);
        }
        if (this.localExtraElementTracker) {
            if (this.localExtraElement != null) {
                for (int i = 0; i < this.localExtraElement.length; ++i) {
                    if (this.localExtraElement[i] == null) continue;
                    this.localExtraElement[i].serialize(xmlWriter);
                }
            } else {
                throw new ADBException("extraElement cannot be null!!");
            }
        }
        xmlWriter.writeEndElement();
    }

    private void writeAttribute(String prefix, String namespace, String attName, String attValue, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (xmlWriter.getPrefix(namespace) == null) {
            xmlWriter.writeNamespace(prefix, namespace);
            xmlWriter.setPrefix(prefix, namespace);
        }
        xmlWriter.writeAttribute(namespace, attName, attValue);
    }

    private void writeAttribute(String namespace, String attName, String attValue, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (namespace.equals("")) {
            xmlWriter.writeAttribute(attName, attValue);
        } else {
            this.registerPrefix(xmlWriter, namespace);
            xmlWriter.writeAttribute(namespace, attName, attValue);
        }
    }

    private void writeQNameAttribute(String namespace, String attName, QName qname, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String attributeNamespace = qname.getNamespaceURI();
        String attributePrefix = xmlWriter.getPrefix(attributeNamespace);
        if (attributePrefix == null) {
            attributePrefix = this.registerPrefix(xmlWriter, attributeNamespace);
        }
        String attributeValue = attributePrefix.trim().length() > 0 ? attributePrefix + ":" + qname.getLocalPart() : qname.getLocalPart();
        if (namespace.equals("")) {
            xmlWriter.writeAttribute(attName, attributeValue);
        } else {
            this.registerPrefix(xmlWriter, namespace);
            xmlWriter.writeAttribute(namespace, attName, attributeValue);
        }
    }

    private void writeQName(QName qname, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String namespaceURI = qname.getNamespaceURI();
        if (namespaceURI != null) {
            String prefix = xmlWriter.getPrefix(namespaceURI);
            if (prefix == null) {
                prefix = Struct.generatePrefix(namespaceURI);
                xmlWriter.writeNamespace(prefix, namespaceURI);
                xmlWriter.setPrefix(prefix, namespaceURI);
            }
            if (prefix.trim().length() > 0) {
                xmlWriter.writeCharacters(prefix + ":" + ConverterUtil.convertToString(qname));
            } else {
                xmlWriter.writeCharacters(ConverterUtil.convertToString(qname));
            }
        } else {
            xmlWriter.writeCharacters(ConverterUtil.convertToString(qname));
        }
    }

    private void writeQNames(QName[] qnames, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (qnames != null) {
            StringBuffer stringToWrite = new StringBuffer();
            String namespaceURI = null;
            String prefix = null;
            for (int i = 0; i < qnames.length; ++i) {
                if (i > 0) {
                    stringToWrite.append(" ");
                }
                if ((namespaceURI = qnames[i].getNamespaceURI()) != null) {
                    prefix = xmlWriter.getPrefix(namespaceURI);
                    if (prefix == null || prefix.length() == 0) {
                        prefix = Struct.generatePrefix(namespaceURI);
                        xmlWriter.writeNamespace(prefix, namespaceURI);
                        xmlWriter.setPrefix(prefix, namespaceURI);
                    }
                    if (prefix.trim().length() > 0) {
                        stringToWrite.append(prefix).append(":").append(ConverterUtil.convertToString(qnames[i]));
                        continue;
                    }
                    stringToWrite.append(ConverterUtil.convertToString(qnames[i]));
                    continue;
                }
                stringToWrite.append(ConverterUtil.convertToString(qnames[i]));
            }
            xmlWriter.writeCharacters(stringToWrite.toString());
        }
    }

    private String registerPrefix(XMLStreamWriter xmlWriter, String namespace) throws XMLStreamException {
        String prefix = xmlWriter.getPrefix(namespace);
        if (prefix == null) {
            prefix = Struct.generatePrefix(namespace);
            while (xmlWriter.getNamespaceContext().getNamespaceURI(prefix) != null) {
                prefix = BeanUtil.getUniquePrefix();
            }
            xmlWriter.writeNamespace(prefix, namespace);
            xmlWriter.setPrefix(prefix, namespace);
        }
        return prefix;
    }

    @Override
    public XMLStreamReader getPullParser(QName qName) throws ADBException {
        ArrayList<Object> elementList = new ArrayList<Object>();
        ArrayList<Object> attribList = new ArrayList<Object>();
        if (this.localExtraElementTracker) {
            if (this.localExtraElement != null) {
                for (int i = 0; i < this.localExtraElement.length; ++i) {
                    if (this.localExtraElement[i] == null) continue;
                    elementList.add(new QName("", "extraElement"));
                    elementList.add(ConverterUtil.convertToString(this.localExtraElement[i]));
                }
            } else {
                throw new ADBException("extraElement cannot be null!!");
            }
        }
        attribList.add(new QName("", "id"));
        attribList.add(ConverterUtil.convertToString(this.localId));
        attribList.add(new QName("", "href"));
        attribList.add(ConverterUtil.convertToString(this.localHref));
        return new ADBXMLStreamReaderImpl(qName, elementList.toArray(), attribList.toArray());
    }

    public static class Factory {
        public static Struct parse(XMLStreamReader reader) throws Exception {
            Struct object = new Struct();
            Object nillableValue = null;
            String prefix = "";
            String namespaceuri = "";
            try {
                String fullTypeName;
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type") != null && (fullTypeName = reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) != null) {
                    String nsPrefix = null;
                    if (fullTypeName.indexOf(":") > -1) {
                        nsPrefix = fullTypeName.substring(0, fullTypeName.indexOf(":"));
                    }
                    nsPrefix = nsPrefix == null ? "" : nsPrefix;
                    String type = fullTypeName.substring(fullTypeName.indexOf(":") + 1);
                    if (!"Struct".equals(type)) {
                        String nsUri = reader.getNamespaceContext().getNamespaceURI(nsPrefix);
                        return (Struct)ExtensionMapper.getTypeObject(nsUri, type, reader);
                    }
                }
                Vector<String> handledAttributes = new Vector<String>();
                String tempAttribId = reader.getAttributeValue(null, "id");
                if (tempAttribId != null) {
                    String content = tempAttribId;
                    object.setId(ConverterUtil.convertToID(tempAttribId));
                }
                handledAttributes.add("id");
                String tempAttribHref = reader.getAttributeValue(null, "href");
                if (tempAttribHref != null) {
                    String content = tempAttribHref;
                    object.setHref(ConverterUtil.convertToAnyURI(tempAttribHref));
                }
                handledAttributes.add("href");
                reader.next();
                ArrayList<OMElement> list1 = new ArrayList<OMElement>();
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement()) {
                    boolean loopDone1 = false;
                    while (!loopDone1) {
                        int event = reader.getEventType();
                        if (1 == event) {
                            NamedStaxOMBuilder builder1 = new NamedStaxOMBuilder(new StreamWrapper(reader), reader.getName());
                            list1.add(builder1.getOMElement());
                            reader.next();
                            if (!reader.isEndElement()) continue;
                            loopDone1 = true;
                            continue;
                        }
                        if (2 == event) {
                            loopDone1 = true;
                            continue;
                        }
                        reader.next();
                    }
                    object.setExtraElement((OMElement[])ConverterUtil.convertToArray(OMElement.class, list1));
                }
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement()) {
                    throw new ADBException("Unexpected subelement " + reader.getLocalName());
                }
            }
            catch (XMLStreamException e) {
                throw new Exception(e);
            }
            return object;
        }
    }
}

