/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.management;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;

public class ThreadDumpGenerator {
    protected static final ILogger logger = Logger.getLogger(ThreadDumpGenerator.class);
    protected final ThreadMXBean threadMxBean;

    public static ThreadDumpGenerator newInstance() {
        return ThreadDumpGenerator.newInstance(ManagementFactory.getThreadMXBean());
    }

    public static ThreadDumpGenerator newInstance(ThreadMXBean bean) {
        return new ThreadDumpGenerator(bean);
    }

    ThreadDumpGenerator(ThreadMXBean bean) {
        this.threadMxBean = bean;
    }

    public final String dumpAllThreads() {
        logger.finest("Generating full thread dump...");
        StringBuilder s = new StringBuilder();
        s.append("Full thread dump ");
        return this.dump(this.getAllThreads(), s);
    }

    public final String dumpDeadlocks() {
        logger.finest("Generating dead-locked threads dump...");
        StringBuilder s = new StringBuilder();
        s.append("Deadlocked thread dump ");
        return this.dump(this.findDeadlockedThreads(), s);
    }

    private String dump(ThreadInfo[] infos, StringBuilder s) {
        this.header(s);
        this.appendThreadInfos(infos, s);
        if (logger.isFinestEnabled()) {
            logger.finest("\n" + s.toString());
        }
        return s.toString();
    }

    public ThreadInfo[] findDeadlockedThreads() {
        if (this.threadMxBean.isSynchronizerUsageSupported()) {
            long[] tids = this.threadMxBean.findDeadlockedThreads();
            if (tids == null || tids.length == 0) {
                return null;
            }
            return this.threadMxBean.getThreadInfo(tids, true, true);
        }
        return this.getThreads(this.threadMxBean.findMonitorDeadlockedThreads());
    }

    public ThreadInfo[] getAllThreads() {
        if (this.threadMxBean.isObjectMonitorUsageSupported() && this.threadMxBean.isSynchronizerUsageSupported()) {
            return this.threadMxBean.dumpAllThreads(true, true);
        }
        return this.getThreads(this.threadMxBean.getAllThreadIds());
    }

    private void header(StringBuilder s) {
        s.append(System.getProperty("java.vm.name"));
        s.append(" (");
        s.append(System.getProperty("java.vm.version"));
        s.append(" ");
        s.append(System.getProperty("java.vm.info"));
        s.append("):");
        s.append("\n\n");
    }

    private void appendThreadInfos(ThreadInfo[] infos, StringBuilder s) {
        if (infos == null || infos.length == 0) {
            return;
        }
        for (int i = 0; i < infos.length; ++i) {
            ThreadInfo info = infos[i];
            this.appendThreadInfo(info, s);
        }
    }

    protected void appendThreadInfo(ThreadInfo info, StringBuilder sb) {
        sb.append("\"").append(info.getThreadName()).append("\"").append(" Id=").append(info.getThreadId()).append(" ").append((Object)info.getThreadState());
        if (info.getLockName() != null) {
            sb.append(" on ").append(info.getLockName());
        }
        if (info.getLockOwnerName() != null) {
            sb.append(" owned by \"").append(info.getLockOwnerName()).append("\" Id=").append(info.getLockOwnerId());
        }
        if (info.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (info.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        StackTraceElement[] stackTrace = info.getStackTrace();
        LockInfo lockInfo = info.getLockInfo();
        MonitorInfo[] monitorInfo = info.getLockedMonitors();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement ste = stackTrace[i];
            sb.append("\tat ").append(ste.toString());
            sb.append('\n');
            if (i == 0 && lockInfo != null) {
                Thread.State ts = info.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on ").append(lockInfo);
                        sb.append('\n');
                        break;
                    }
                    case WAITING: {
                        sb.append("\t-  waiting on ").append(lockInfo);
                        sb.append('\n');
                        break;
                    }
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on ").append(lockInfo);
                        sb.append('\n');
                        break;
                    }
                }
            }
            for (MonitorInfo mi : monitorInfo) {
                int depth = mi.getLockedStackDepth();
                if (depth != i) continue;
                sb.append("\t-  locked ").append(mi);
                sb.append('\n');
            }
        }
        LockInfo[] locks = info.getLockedSynchronizers();
        if (locks.length > 0) {
            sb.append("\n\tNumber of locked synchronizers = ").append(locks.length);
            sb.append('\n');
            for (LockInfo li : locks) {
                sb.append("\t- ").append(li);
                sb.append('\n');
            }
        }
        sb.append('\n');
    }

    protected ThreadInfo[] getThreads(long[] tids) {
        if (tids == null || tids.length == 0) {
            return null;
        }
        return this.threadMxBean.getThreadInfo(tids, Integer.MAX_VALUE);
    }
}

