/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.topology;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.topology.Topology;

public class TopologyManager {
    private static final Log log = LogFactory.getLog(TopologyManager.class);
    private static volatile Topology topology;
    private static volatile ReentrantReadWriteLock lock;
    private static volatile ReentrantReadWriteLock.ReadLock readLock;
    private static volatile ReentrantReadWriteLock.WriteLock writeLock;

    public static void acquireReadLock() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Read lock acquired");
        }
        readLock.lock();
    }

    public static void releaseReadLock() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Read lock released");
        }
        readLock.unlock();
    }

    public static void acquireWriteLock() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Write lock acquired");
        }
        writeLock.lock();
    }

    public static void releaseWriteLock() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Write lock released");
        }
        writeLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Topology getTopology() {
        if (topology != null) return topology;
        Class<TopologyManager> clazz = TopologyManager.class;
        synchronized (TopologyManager.class) {
            if (topology != null) return topology;
            topology = new Topology();
            if (!log.isDebugEnabled()) return topology;
            log.debug((Object)"Topology object created");
            // ** MonitorExit[var0] (shouldn't be in output)
            return topology;
        }
    }

    static {
        lock = new ReentrantReadWriteLock(true);
        readLock = lock.readLock();
        writeLock = lock.writeLock();
    }
}

