/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.health.stat;

import javax.jms.TextMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.processor.MessageProcessorChain;
import org.apache.stratos.messaging.message.processor.health.stat.HealthStatMessageProcessorChain;
import org.apache.stratos.messaging.message.receiver.health.stat.HealthStatEventMessageQueue;

class HealthStatEventMessageDelegator
implements Runnable {
    private static final Log log = LogFactory.getLog(HealthStatEventMessageDelegator.class);
    private HealthStatEventMessageQueue messageQueue;
    private MessageProcessorChain processorChain;
    private boolean terminated;

    public HealthStatEventMessageDelegator(HealthStatEventMessageQueue messageQueue) {
        this.messageQueue = messageQueue;
        this.processorChain = new HealthStatMessageProcessorChain();
    }

    public void addEventListener(EventListener eventListener) {
        this.processorChain.addEventListener(eventListener);
    }

    @Override
    public void run() {
        block10: {
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Health stat event message delegator started");
                }
                while (!this.terminated) {
                    try {
                        EventMessage eventMessage;
                        TextMessage message = (TextMessage)this.messageQueue.take();
                        String messageText = message.getText();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Health event message received: [message] " + messageText));
                        }
                        if ((eventMessage = this.jsonToEventMessage(messageText)) == null) {
                            log.error((Object)"Error occurred while extracting message");
                            continue;
                        }
                        String type = eventMessage.getEventName();
                        String json = eventMessage.getMessage();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Instance notifier event message received from queue: %s", type));
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Delegating instance notifier event message: %s", type));
                        }
                        this.processorChain.process(type, json, null);
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed to retrieve instance notifier event message", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block10;
                log.error((Object)"Instance notifier event message delegator failed", (Throwable)e);
            }
        }
    }

    public void terminate() {
        this.terminated = true;
    }

    private EventMessage jsonToEventMessage(String json) {
        EventMessage event = new EventMessage();
        String[] MessageParts = json.split(":", 3);
        String eventType = MessageParts[0].trim();
        eventType = eventType.substring(eventType.indexOf("\"") + 1, eventType.lastIndexOf("\""));
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Extracted [event type] %s", eventType));
        }
        event.setEventName(eventType);
        String messageTag = MessageParts[1];
        messageTag = messageTag.substring(messageTag.indexOf("\"") + 1, messageTag.lastIndexOf("\""));
        if ("message".equals(messageTag)) {
            String message = MessageParts[2].trim();
            message = message.substring(0, message.lastIndexOf("}")).trim();
            if ((message = message.substring(0, message.lastIndexOf("}")).trim()).indexOf(123) == 0 && message.indexOf(125) == message.length() - 1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("[Extracted message] %s ", message));
                }
                event.setMessage(message);
                return event;
            }
        }
        return null;
    }

    private class EventMessage {
        private String eventName;
        private String message;

        private EventMessage() {
        }

        private String getEventName() {
            return this.eventName;
        }

        private void setEventName(String eventName) {
            this.eventName = eventName;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

