/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.event.topology;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.stratos.messaging.domain.topology.Port;
import org.apache.stratos.messaging.event.topology.TopologyEvent;

public class MemberActivatedEvent
extends TopologyEvent
implements Serializable {
    private static final long serialVersionUID = 5493702477320416932L;
    private final String serviceName;
    private final String clusterId;
    private final String networkPartitionId;
    private final String partitionId;
    private final String memberId;
    private Map<String, Port> portMap;
    private String memberIp;

    public MemberActivatedEvent(String serviceName, String clusterId, String networkPartitionId, String partitionId, String memberId) {
        this.serviceName = serviceName;
        this.clusterId = clusterId;
        this.networkPartitionId = networkPartitionId;
        this.partitionId = partitionId;
        this.memberId = memberId;
        this.portMap = new HashMap<String, Port>();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getNetworkPartitionId() {
        return this.networkPartitionId;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public Collection<Port> getPorts() {
        return this.portMap.values();
    }

    public void addPort(Port port) {
        this.portMap.put(port.getProtocol(), port);
    }

    public void removePort(Port port) {
        this.portMap.remove(port.getProtocol());
    }

    public void removePort(String portName) {
        this.portMap.remove(portName);
    }

    public boolean portExists(Port port) {
        return this.portMap.containsKey(port.getProtocol());
    }

    public Port getPort(String portName) {
        return this.portMap.get(portName);
    }

    public String getMemberIp() {
        return this.memberIp;
    }

    public void setMemberIp(String memberIp) {
        this.memberIp = memberIp;
    }
}

