/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.broker.heartbeat;

import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.connect.TopicConnector;
import org.apache.stratos.messaging.broker.publish.EventPublisherPool;
import org.apache.stratos.messaging.event.ping.PingEvent;

public class TopicHealthChecker
implements Runnable {
    private static final Log log = LogFactory.getLog(TopicHealthChecker.class);
    private String topicName;
    private boolean terminated;

    public TopicHealthChecker(String name) {
        this.topicName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.topicName + " topic health checker is running... "));
        }
        TopicConnector testConnector = new TopicConnector();
        while (!this.terminated) {
            Thread.sleep(1000L);
            testConnector.init(this.topicName);
            EventPublisherPool.getPublisher("ping").publish(new PingEvent(), false);
            try {
                testConnector.close();
            }
            catch (JMSException ignore) {}
            continue;
            catch (Exception e) {
                log.error((Object)(this.topicName + " topic health checker is failed and will try to subscribe again in 30 sec"));
                Thread.sleep(30000L);
                try {
                    testConnector.close();
                }
                catch (JMSException ignore) {}
                break;
                {
                    catch (InterruptedException interruptedException) {
                        try {
                            testConnector.close();
                        }
                        catch (JMSException jMSException) {}
                        continue;
                        catch (Throwable throwable) {
                            try {
                                testConnector.close();
                            }
                            catch (JMSException ignore) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                }
            }
        }
    }

    public void terminate() {
        this.terminated = true;
    }
}

