/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc.handler;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.jdbc.JdbcDirectory;
import org.apache.lucene.store.jdbc.JdbcFileEntrySettings;
import org.apache.lucene.store.jdbc.JdbcStoreException;
import org.apache.lucene.store.jdbc.handler.FileEntryHandler;
import org.apache.lucene.store.jdbc.index.JdbcIndexConfigurable;
import org.apache.lucene.store.jdbc.support.JdbcTable;
import org.apache.lucene.store.jdbc.support.JdbcTemplate;

public abstract class AbstractFileEntryHandler
implements FileEntryHandler {
    protected JdbcDirectory jdbcDirectory;
    protected JdbcTable table;
    protected JdbcTemplate jdbcTemplate;

    public void configure(JdbcDirectory jdbcDirectory) {
        this.jdbcDirectory = jdbcDirectory;
        this.jdbcTemplate = jdbcDirectory.getJdbcTemplate();
        this.table = jdbcDirectory.getTable();
    }

    public boolean fileExists(final String name) throws IOException {
        return (Boolean)this.jdbcTemplate.executeSelect(this.table.sqlSelectNameExists(), new JdbcTemplate.ExecuteSelectCallback(){

            public void fillPrepareStatement(PreparedStatement ps) throws Exception {
                ps.setFetchSize(1);
                ps.setString(1, name);
            }

            public Object execute(ResultSet rs) throws Exception {
                if (!rs.next()) {
                    return Boolean.FALSE;
                }
                return rs.getBoolean(1) ? Boolean.FALSE : Boolean.TRUE;
            }
        });
    }

    public long fileModified(final String name) throws IOException {
        return (Long)this.jdbcTemplate.executeSelect(this.table.sqlSelecltLastModifiedByName(), new JdbcTemplate.ExecuteSelectCallback(){

            public void fillPrepareStatement(PreparedStatement ps) throws Exception {
                ps.setFetchSize(1);
                ps.setString(1, name);
            }

            public Object execute(ResultSet rs) throws Exception {
                if (rs.next()) {
                    Timestamp ts = rs.getTimestamp(1);
                    return new Long(ts.getTime());
                }
                return new Long(0L);
            }
        });
    }

    public void touchFile(final String name) throws IOException {
        this.jdbcTemplate.executeUpdate(this.table.sqlUpdateLastModifiedByName(), new JdbcTemplate.PrepateStatementAwareCallback(){

            public void fillPrepareStatement(PreparedStatement ps) throws Exception {
                ps.setFetchSize(1);
                ps.setString(1, name);
            }
        });
    }

    public void renameFile(final String from, final String to) throws IOException {
        this.deleteFile(to);
        this.jdbcTemplate.executeUpdate(this.table.sqlUpdateNameByName(), new JdbcTemplate.PrepateStatementAwareCallback(){

            public void fillPrepareStatement(PreparedStatement ps) throws Exception {
                ps.setFetchSize(1);
                ps.setString(1, to);
                ps.setString(2, from);
            }
        });
    }

    public long fileLength(final String name) throws IOException {
        return (Long)this.jdbcTemplate.executeSelect(this.table.sqlSelectSizeByName(), new JdbcTemplate.ExecuteSelectCallback(){

            public void fillPrepareStatement(PreparedStatement ps) throws Exception {
                ps.setFetchSize(1);
                ps.setString(1, name);
            }

            public Object execute(ResultSet rs) throws Exception {
                if (rs.next()) {
                    return new Long(rs.getLong(1));
                }
                return new Long(0L);
            }
        });
    }

    public IndexInput openInput(String name) throws IOException {
        IndexInput indexInput;
        JdbcFileEntrySettings settings = this.jdbcDirectory.getSettings().getFileEntrySettings(name);
        try {
            Class inputClass = settings.getSettingAsClass("indexInput.type", null);
            indexInput = (IndexInput)inputClass.newInstance();
        }
        catch (Exception e) {
            throw new JdbcStoreException("Failed to create indexInput instance [" + settings.getSetting("indexInput.type") + "]", e);
        }
        ((JdbcIndexConfigurable)((Object)indexInput)).configure(name, this.jdbcDirectory, settings);
        return indexInput;
    }

    public IndexOutput createOutput(String name) throws IOException {
        IndexOutput indexOutput;
        JdbcFileEntrySettings settings = this.jdbcDirectory.getSettings().getFileEntrySettings(name);
        try {
            Class inputClass = settings.getSettingAsClass("indexOutput.type", null);
            indexOutput = (IndexOutput)inputClass.newInstance();
        }
        catch (Exception e) {
            throw new JdbcStoreException("Failed to create indexOutput instance [" + settings.getSetting("indexOutput.type") + "]", e);
        }
        ((JdbcIndexConfigurable)((Object)indexOutput)).configure(name, this.jdbcDirectory, settings);
        return indexOutput;
    }

    public void close() throws IOException {
    }
}

