/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common.util;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.config.CloudServiceConfig;
import org.apache.stratos.common.config.CloudServicesDescConfig;
import org.apache.stratos.common.config.PermissionConfig;
import org.apache.stratos.common.internal.CloudCommonServiceComponent;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.core.UserStoreException;

public class CloudServicesUtil {
    private static final Log log = LogFactory.getLog(CloudServicesUtil.class);

    public static void activateAllServices(CloudServicesDescConfig cloudServicesDesc, int tenantId) throws Exception {
        Collection<CloudServiceConfig> cloudServiceConfigList = cloudServicesDesc.getCloudServiceConfigs().values();
        if (cloudServiceConfigList != null) {
            for (CloudServiceConfig cloudServiceConfig : cloudServiceConfigList) {
                if (!cloudServiceConfig.isDefaultActive()) continue;
                String cloudServiceName = cloudServiceConfig.getName();
                try {
                    if (CloudServicesUtil.isCloudServiceActive(cloudServiceName, tenantId)) continue;
                    CloudServicesUtil.setCloudServiceActive(true, cloudServiceName, tenantId, cloudServicesDesc.getCloudServiceConfigs().get(cloudServiceName));
                }
                catch (Exception e) {
                    String msg = "Error in activating the cloud service at the tenantcreation. tenant id: " + tenantId + ", service name: " + cloudServiceName;
                    log.error((Object)msg, (Throwable)e);
                    throw new UserStoreException(msg, (Throwable)e);
                }
            }
        }
    }

    public static void activateOriginalAndCompulsoryServices(CloudServicesDescConfig cloudServicesDesc, String originalService, int tenantId) throws Exception {
        Map<String, CloudServiceConfig> cloudServiceConfigs = cloudServicesDesc.getCloudServiceConfigs();
        if (CloudServicesUtil.isServiceNameValid(cloudServicesDesc, originalService)) {
            if (!CloudServicesUtil.isCloudServiceActive(originalService, tenantId)) {
                CloudServicesUtil.setCloudServiceActive(true, originalService, tenantId, cloudServiceConfigs.get(originalService));
                log.info((Object)("Successfully activated the " + originalService + " for the tenant " + tenantId));
            }
            if (!CloudServicesUtil.isCloudServiceActive("WSO2 Stratos Identity", tenantId)) {
                CloudServicesUtil.setCloudServiceActive(true, "WSO2 Stratos Identity", tenantId, cloudServiceConfigs.get("WSO2 Stratos Identity"));
            }
            if (!CloudServicesUtil.isCloudServiceActive("WSO2 Stratos Governance", tenantId)) {
                CloudServicesUtil.setCloudServiceActive(true, "WSO2 Stratos Governance", tenantId, cloudServiceConfigs.get("WSO2 Stratos Governance"));
            }
        } else {
            log.warn((Object)("Unable to activate the " + originalService + " for the tenant " + tenantId));
        }
    }

    public static void setCloudServiceActive(boolean active, String cloudServiceName, int tenantId, CloudServiceConfig cloudServiceConfig) throws Exception {
        if (cloudServiceConfig.getLabel() == null) {
            return;
        }
        UserRegistry govRegistry = CloudCommonServiceComponent.getGovernanceSystemRegistry(-1234);
        UserRegistry configRegistry = CloudCommonServiceComponent.getConfigSystemRegistry(tenantId);
        String cloudServiceInfoPath = "/repository/components/org.wso2.stratos/cloud-manager/cloud-services/" + tenantId + "/" + cloudServiceName;
        Object cloudServiceInfoResource = govRegistry.resourceExists(cloudServiceInfoPath) ? govRegistry.get(cloudServiceInfoPath) : govRegistry.newCollection();
        cloudServiceInfoResource.setProperty("active", active ? "true" : "false");
        govRegistry.put(cloudServiceInfoPath, (Resource)cloudServiceInfoResource);
        List<PermissionConfig> permissionConfigs = cloudServiceConfig.getPermissionConfigs();
        for (PermissionConfig permissionConfig : permissionConfigs) {
            String path = permissionConfig.getPath();
            String name = permissionConfig.getName();
            if (active) {
                if (configRegistry.resourceExists(path)) continue;
                org.wso2.carbon.registry.core.Collection collection = configRegistry.newCollection();
                collection.setProperty("name", name);
                configRegistry.put(path, (Resource)collection);
                continue;
            }
            if (!configRegistry.resourceExists(path)) continue;
            configRegistry.delete(path);
        }
    }

    public static boolean isCloudServiceActive(String cloudServiceName, int tenantId) throws Exception {
        UserRegistry govRegistry = CloudCommonServiceComponent.getGovernanceSystemRegistry(-1234);
        return CloudServicesUtil.isCloudServiceActive(cloudServiceName, tenantId, govRegistry);
    }

    public static boolean isCloudServiceActive(String cloudServiceName, int tenantId, UserRegistry govRegistry) throws Exception {
        if ("Apache Stratos Controller".equals(cloudServiceName)) {
            return true;
        }
        String cloudServiceInfoPath = "/repository/components/org.wso2.stratos/cloud-manager/cloud-services/" + tenantId + "/" + cloudServiceName;
        if (govRegistry.resourceExists(cloudServiceInfoPath)) {
            Resource cloudServiceInfoResource = govRegistry.get(cloudServiceInfoPath);
            String isActiveStr = cloudServiceInfoResource.getProperty("active");
            return "true".equals(isActiveStr);
        }
        return false;
    }

    public static boolean isServiceNameValid(CloudServicesDescConfig cloudServicesDesc, String cloudServiceName) {
        if (cloudServiceName == null) {
            return false;
        }
        Collection<CloudServiceConfig> cloudServiceConfigList = cloudServicesDesc.getCloudServiceConfigs().values();
        if (cloudServiceName.equals("Apache Stratos Controller")) {
            return false;
        }
        for (CloudServiceConfig cloudServiceConfig : cloudServiceConfigList) {
            if (!cloudServiceConfig.getName().equals(cloudServiceName)) continue;
            return true;
        }
        return false;
    }
}

