/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.common;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.storm.daemon.common.FileWatcher;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadableSslContextFactory
extends SslContextFactory.Server {
    private static final Logger LOG = LoggerFactory.getLogger(ReloadableSslContextFactory.class);
    private boolean enableSslReload;
    private FileWatcher keyStoreWatcher;
    private FileWatcher trustStoreWatcher;

    public ReloadableSslContextFactory() {
        this(false);
    }

    public ReloadableSslContextFactory(boolean enableSslReload) {
        this.enableSslReload = enableSslReload;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.enableSslReload) {
            LOG.info("Enabling reloading of SSL credentials without server restart");
            String keyStorePathStr = this.getKeyStorePath();
            if (keyStorePathStr != null) {
                Path keyStorePath = Paths.get(URI.create(keyStorePathStr).getPath(), new String[0]);
                FileWatcher.Callback keyStoreWatcherCallback = () -> this.reload(scf -> LOG.info("Reloading SslContextFactory due to keystore change"));
                this.keyStoreWatcher = new FileWatcher(keyStorePath, keyStoreWatcherCallback);
                this.keyStoreWatcher.start();
            } else {
                LOG.warn("KeyStore is null; it won't be watched/reloaded");
            }
            String trustStorePathStr = this.getTrustStorePath();
            if (trustStorePathStr != null) {
                Path trustStorePath = Paths.get(URI.create(trustStorePathStr).getPath(), new String[0]);
                FileWatcher.Callback trustStoreWatcherCallback = () -> this.reload(scf -> LOG.info("Reloading SslContextFactory due to truststore change"));
                this.trustStoreWatcher = new FileWatcher(trustStorePath, trustStoreWatcherCallback);
                this.trustStoreWatcher.start();
            } else {
                LOG.warn("TrustStore is null; it won't be watched/reloaded");
            }
        }
    }

    protected void doStop() throws Exception {
        if (this.keyStoreWatcher != null) {
            this.keyStoreWatcher.stop();
        }
        if (this.trustStoreWatcher != null) {
            this.trustStoreWatcher.stop();
        }
        super.doStop();
    }
}

