/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource.strategies.scheduling.sorter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.storm.scheduler.Cluster;
import org.apache.storm.scheduler.ExecutorDetails;
import org.apache.storm.scheduler.SchedulerAssignment;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.WorkerSlot;
import org.apache.storm.scheduler.resource.RasNode;
import org.apache.storm.scheduler.resource.RasNodes;
import org.apache.storm.scheduler.resource.normalization.NormalizedResourceOffer;
import org.apache.storm.scheduler.resource.normalization.NormalizedResourceRequest;
import org.apache.storm.scheduler.resource.strategies.scheduling.BaseResourceAwareStrategy;
import org.apache.storm.scheduler.resource.strategies.scheduling.ObjectResourcesItem;
import org.apache.storm.scheduler.resource.strategies.scheduling.ObjectResourcesSummary;
import org.apache.storm.scheduler.resource.strategies.scheduling.sorter.INodeSorter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeSorter
implements INodeSorter {
    private static final Logger LOG = LoggerFactory.getLogger(NodeSorter.class);
    protected final BaseResourceAwareStrategy.NodeSortType nodeSortType;
    protected Cluster cluster;
    protected TopologyDetails topologyDetails;
    private final Map<String, List<String>> networkTopography;
    private final Map<String, String> superIdToRack = new HashMap<String, String>();
    private final Map<String, List<RasNode>> hostnameToNodes = new HashMap<String, List<RasNode>>();
    private final Map<String, List<RasNode>> rackIdToNodes = new HashMap<String, List<RasNode>>();
    protected List<String> greyListedSupervisorIds;
    protected List<String> favoredNodeIds;
    protected List<String> unFavoredNodeIds;
    ExecutorDetails exec;

    public NodeSorter(Cluster cluster, TopologyDetails topologyDetails, BaseResourceAwareStrategy.NodeSortType nodeSortType) {
        this.cluster = cluster;
        this.topologyDetails = topologyDetails;
        this.nodeSortType = nodeSortType;
        this.networkTopography = cluster.getNetworkTopography();
        Map<String, String> hostToRack = cluster.getHostToRack();
        RasNodes nodes = new RasNodes(cluster);
        for (RasNode node : nodes.getNodes()) {
            String superId = node.getId();
            String hostName = node.getHostname();
            if (!node.isAlive() || hostName == null) continue;
            String rackId = hostToRack.getOrDefault(hostName, "/default-rack");
            this.superIdToRack.put(superId, rackId);
            this.hostnameToNodes.computeIfAbsent(hostName, hn -> new ArrayList()).add(node);
            this.rackIdToNodes.computeIfAbsent(rackId, rid -> new ArrayList()).add(node);
        }
        this.greyListedSupervisorIds = cluster.getGreyListedSupervisors();
        Map<String, Object> topoConf = topologyDetails.getConf();
        this.favoredNodeIds = this.makeHostToNodeIds((List)topoConf.get("topology.scheduler.favored.nodes"));
        this.unFavoredNodeIds = this.makeHostToNodeIds((List)topoConf.get("topology.scheduler.unfavored.nodes"));
        this.favoredNodeIds.removeAll(this.greyListedSupervisorIds);
        this.unFavoredNodeIds.removeAll(this.greyListedSupervisorIds);
        this.unFavoredNodeIds.removeAll(this.favoredNodeIds);
    }

    @Override
    public void prepare(ExecutorDetails exec) {
        this.exec = exec;
    }

    protected List<ObjectResourcesItem> sortObjectResources(ObjectResourcesSummary resourcesSummary, ExecutorDetails exec, ExistingScheduleFunc existingScheduleFunc) {
        switch (this.nodeSortType) {
            case DEFAULT_RAS: {
                return this.sortObjectResourcesDefault(resourcesSummary, existingScheduleFunc);
            }
            case GENERIC_RAS: {
                return this.sortObjectResourcesGeneric(resourcesSummary, exec, existingScheduleFunc);
            }
            case COMMON: {
                return this.sortObjectResourcesCommon(resourcesSummary, exec, existingScheduleFunc);
            }
        }
        return null;
    }

    private List<ObjectResourcesItem> sortObjectResourcesCommon(ObjectResourcesSummary allResources, ExecutorDetails exec, ExistingScheduleFunc existingScheduleFunc) {
        ObjectResourcesSummary affinityBasedAllResources = new ObjectResourcesSummary(allResources);
        NormalizedResourceOffer availableResourcesOverall = allResources.getAvailableResourcesOverall();
        NormalizedResourceRequest requestedResources = exec != null ? this.topologyDetails.getTotalResources(exec) : null;
        affinityBasedAllResources.getObjectResources().forEach(x -> {
            x.minResourcePercent = availableResourcesOverall.calculateMinPercentageUsedBy(x.availableResources);
            if (requestedResources != null) {
                x.availableResources.updateForRareResourceAffinity(requestedResources);
            }
            x.avgResourcePercent = availableResourcesOverall.calculateAveragePercentageUsedBy(x.availableResources);
            LOG.trace("for {}: minResourcePercent={}, avgResourcePercent={}, numExistingSchedule={}", new Object[]{x.id, x.minResourcePercent, x.avgResourcePercent, existingScheduleFunc.getNumExistingSchedule(x.id)});
        });
        ArrayList<ObjectResourcesItem> sortedObjectResources = new ArrayList<ObjectResourcesItem>();
        Comparator comparator = (o1, o2) -> {
            int execsScheduled2;
            int execsScheduled1 = existingScheduleFunc.getNumExistingSchedule(o1.id);
            if (execsScheduled1 > (execsScheduled2 = existingScheduleFunc.getNumExistingSchedule(o2.id))) {
                return -1;
            }
            if (execsScheduled1 < execsScheduled2) {
                return 1;
            }
            double o1Avg = o1.avgResourcePercent;
            double o2Avg = o2.avgResourcePercent;
            if (o1Avg > o2Avg) {
                return -1;
            }
            if (o1Avg < o2Avg) {
                return 1;
            }
            if (o1.minResourcePercent > o2.minResourcePercent) {
                return -1;
            }
            if (o1.minResourcePercent < o2.minResourcePercent) {
                return 1;
            }
            return o1.id.compareTo(o2.id);
        };
        sortedObjectResources.addAll(affinityBasedAllResources.getObjectResources());
        sortedObjectResources.sort(comparator);
        LOG.debug("Sorted Object Resources: {}", sortedObjectResources);
        return sortedObjectResources;
    }

    @Deprecated
    private List<ObjectResourcesItem> sortObjectResourcesGeneric(ObjectResourcesSummary allResources, ExecutorDetails exec, ExistingScheduleFunc existingScheduleFunc) {
        ObjectResourcesSummary affinityBasedAllResources = new ObjectResourcesSummary(allResources);
        NormalizedResourceRequest requestedResources = this.topologyDetails.getTotalResources(exec);
        affinityBasedAllResources.getObjectResources().forEach(x -> x.availableResources.updateForRareResourceAffinity(requestedResources));
        NormalizedResourceOffer availableResourcesOverall = allResources.getAvailableResourcesOverall();
        ArrayList<ObjectResourcesItem> sortedObjectResources = new ArrayList<ObjectResourcesItem>();
        Comparator comparator = (o1, o2) -> {
            double o2Avg;
            int execsScheduled2;
            int execsScheduled1 = existingScheduleFunc.getNumExistingSchedule(o1.id);
            if (execsScheduled1 > (execsScheduled2 = existingScheduleFunc.getNumExistingSchedule(o2.id))) {
                return -1;
            }
            if (execsScheduled1 < execsScheduled2) {
                return 1;
            }
            double o1Avg = availableResourcesOverall.calculateAveragePercentageUsedBy(o1.availableResources);
            if (o1Avg > (o2Avg = availableResourcesOverall.calculateAveragePercentageUsedBy(o2.availableResources))) {
                return -1;
            }
            if (o1Avg < o2Avg) {
                return 1;
            }
            return o1.id.compareTo(o2.id);
        };
        sortedObjectResources.addAll(affinityBasedAllResources.getObjectResources());
        sortedObjectResources.sort(comparator);
        LOG.debug("Sorted Object Resources: {}", sortedObjectResources);
        return sortedObjectResources;
    }

    @Deprecated
    private List<ObjectResourcesItem> sortObjectResourcesDefault(ObjectResourcesSummary allResources, ExistingScheduleFunc existingScheduleFunc) {
        NormalizedResourceOffer availableResourcesOverall = allResources.getAvailableResourcesOverall();
        for (ObjectResourcesItem objectResources : allResources.getObjectResources()) {
            objectResources.minResourcePercent = availableResourcesOverall.calculateMinPercentageUsedBy(objectResources.availableResources);
            objectResources.avgResourcePercent = availableResourcesOverall.calculateAveragePercentageUsedBy(objectResources.availableResources);
            LOG.trace("for {}: minResourcePercent={}, avgResourcePercent={}, numExistingSchedule={}", new Object[]{objectResources.id, objectResources.minResourcePercent, objectResources.avgResourcePercent, existingScheduleFunc.getNumExistingSchedule(objectResources.id)});
        }
        ArrayList<ObjectResourcesItem> sortedObjectResources = new ArrayList<ObjectResourcesItem>();
        Comparator comparator = (o1, o2) -> {
            int execsScheduled2;
            int execsScheduled1 = existingScheduleFunc.getNumExistingSchedule(o1.id);
            if (execsScheduled1 > (execsScheduled2 = existingScheduleFunc.getNumExistingSchedule(o2.id))) {
                return -1;
            }
            if (execsScheduled1 < execsScheduled2) {
                return 1;
            }
            if (o1.minResourcePercent > o2.minResourcePercent) {
                return -1;
            }
            if (o1.minResourcePercent < o2.minResourcePercent) {
                return 1;
            }
            double diff = o1.avgResourcePercent - o2.avgResourcePercent;
            if (diff > 0.0) {
                return -1;
            }
            if (diff < 0.0) {
                return 1;
            }
            return o1.id.compareTo(o2.id);
        };
        sortedObjectResources.addAll(allResources.getObjectResources());
        sortedObjectResources.sort(comparator);
        LOG.debug("Sorted Object Resources: {}", sortedObjectResources);
        return sortedObjectResources;
    }

    private List<ObjectResourcesItem> sortNodes(List<RasNode> availRasNodes, ExecutorDetails exec, String rackId, Map<String, AtomicInteger> scheduledCount) {
        ObjectResourcesSummary rackResourcesSummary = new ObjectResourcesSummary("RACK");
        availRasNodes.forEach(x -> rackResourcesSummary.addObjectResourcesItem(new ObjectResourcesItem(x.getId(), x.getTotalAvailableResources(), x.getTotalResources(), 0.0, 0.0)));
        LOG.debug("Rack {}: Overall Avail [ {} ] Total [ {} ]", new Object[]{rackId, rackResourcesSummary.getAvailableResourcesOverall(), rackResourcesSummary.getTotalResourcesOverall()});
        return this.sortObjectResources(rackResourcesSummary, exec, superId -> {
            AtomicInteger count = (AtomicInteger)scheduledCount.get(superId);
            if (count == null) {
                return 0;
            }
            return count.get();
        });
    }

    protected List<String> makeHostToNodeIds(List<String> hosts) {
        if (hosts == null) {
            return Collections.emptyList();
        }
        ArrayList<String> ret = new ArrayList<String>(hosts.size());
        for (String host : hosts) {
            List<RasNode> nodes = this.hostnameToNodes.get(host);
            if (nodes == null) continue;
            for (RasNode node : nodes) {
                ret.add(node.getId());
            }
        }
        return ret;
    }

    @Override
    public Iterable<String> sortAllNodes() {
        return new LazyNodeSorting(this.exec);
    }

    private ObjectResourcesSummary createClusterSummarizedResources() {
        ObjectResourcesSummary clusterResourcesSummary = new ObjectResourcesSummary("Cluster");
        for (Map.Entry<String, List<String>> entry : this.networkTopography.entrySet()) {
            String rackId = entry.getKey();
            List<String> nodeHosts = entry.getValue();
            ObjectResourcesItem rack = new ObjectResourcesItem(rackId);
            for (String nodeHost : nodeHosts) {
                for (RasNode node : this.hostnameToNodes(nodeHost)) {
                    rack.availableResources.add(node.getTotalAvailableResources());
                    rack.totalResources.add(node.getTotalAvailableResources());
                }
            }
            clusterResourcesSummary.addObjectResourcesItem(rack);
        }
        LOG.debug("Cluster Overall Avail [ {} ] Total [ {} ]", (Object)clusterResourcesSummary.getAvailableResourcesOverall(), (Object)clusterResourcesSummary.getTotalResourcesOverall());
        return clusterResourcesSummary;
    }

    private Map<String, AtomicInteger> getScheduledExecCntByRackId() {
        String topoId = this.topologyDetails.getId();
        SchedulerAssignment assignment = this.cluster.getAssignmentById(topoId);
        HashMap<String, AtomicInteger> scheduledCount = new HashMap<String, AtomicInteger>();
        if (assignment != null) {
            for (Map.Entry<WorkerSlot, Collection<ExecutorDetails>> entry : assignment.getSlotToExecutors().entrySet()) {
                String superId = entry.getKey().getNodeId();
                String rackId = this.superIdToRack.get(superId);
                scheduledCount.computeIfAbsent(rackId, rid -> new AtomicInteger(0)).getAndAdd(entry.getValue().size());
            }
        }
        return scheduledCount;
    }

    public List<ObjectResourcesItem> getSortedRacks() {
        ObjectResourcesSummary clusterResourcesSummary = this.createClusterSummarizedResources();
        Map<String, AtomicInteger> scheduledCount = this.getScheduledExecCntByRackId();
        return this.sortObjectResources(clusterResourcesSummary, this.exec, rackId -> {
            AtomicInteger count = (AtomicInteger)scheduledCount.get(rackId);
            if (count == null) {
                return 0;
            }
            return count.get();
        });
    }

    public List<RasNode> hostnameToNodes(String hostname) {
        return this.hostnameToNodes.getOrDefault(hostname, Collections.emptyList());
    }

    public static interface ExistingScheduleFunc {
        public int getNumExistingSchedule(String var1);
    }

    private class LazyNodeSorting
    implements Iterable<String> {
        private final Map<String, AtomicInteger> perNodeScheduledCount = new HashMap<String, AtomicInteger>();
        private final List<ObjectResourcesItem> sortedRacks;
        private final Map<String, List<ObjectResourcesItem>> cachedNodes = new HashMap<String, List<ObjectResourcesItem>>();
        private final ExecutorDetails exec;
        private final Set<String> skippedNodeIds = new HashSet<String>();

        LazyNodeSorting(ExecutorDetails exec) {
            this.exec = exec;
            this.skippedNodeIds.addAll(NodeSorter.this.favoredNodeIds);
            this.skippedNodeIds.addAll(NodeSorter.this.unFavoredNodeIds);
            this.skippedNodeIds.addAll(NodeSorter.this.greyListedSupervisorIds);
            String topoId = NodeSorter.this.topologyDetails.getId();
            SchedulerAssignment assignment = NodeSorter.this.cluster.getAssignmentById(topoId);
            if (assignment != null) {
                for (Map.Entry<WorkerSlot, Collection<ExecutorDetails>> entry : assignment.getSlotToExecutors().entrySet()) {
                    String superId = entry.getKey().getNodeId();
                    this.perNodeScheduledCount.computeIfAbsent(superId, sid -> new AtomicInteger(0)).getAndAdd(entry.getValue().size());
                }
            }
            this.sortedRacks = NodeSorter.this.getSortedRacks();
        }

        private List<ObjectResourcesItem> getSortedNodesFor(String rackId) {
            return this.cachedNodes.computeIfAbsent(rackId, rid -> NodeSorter.this.sortNodes(NodeSorter.this.rackIdToNodes.getOrDefault(rid, Collections.emptyList()), this.exec, (String)rid, this.perNodeScheduledCount));
        }

        @Override
        public Iterator<String> iterator() {
            return new LazyNodeSortingIterator(this, this.sortedRacks);
        }
    }

    private class LazyNodeSortingIterator
    implements Iterator<String> {
        private final LazyNodeSorting parent;
        private final Iterator<ObjectResourcesItem> rackIterator;
        private Iterator<ObjectResourcesItem> nodeIterator;
        private String nextValueFromNode = null;
        private final Iterator<String> pre;
        private final Iterator<String> post;
        private final Set<String> skip;

        LazyNodeSortingIterator(LazyNodeSorting parent, List<ObjectResourcesItem> sortedRacks) {
            this.parent = parent;
            this.rackIterator = sortedRacks.iterator();
            this.pre = NodeSorter.this.favoredNodeIds.iterator();
            this.post = Stream.concat(NodeSorter.this.unFavoredNodeIds.stream(), NodeSorter.this.greyListedSupervisorIds.stream()).collect(Collectors.toList()).iterator();
            this.skip = parent.skippedNodeIds;
        }

        private Iterator<ObjectResourcesItem> getNodeIterator() {
            if (this.nodeIterator != null && this.nodeIterator.hasNext()) {
                return this.nodeIterator;
            }
            if (this.rackIterator.hasNext()) {
                ObjectResourcesItem rack = this.rackIterator.next();
                String rackId = rack.id;
                this.nodeIterator = this.parent.getSortedNodesFor(rackId).iterator();
                return this.nodeIterator;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            Iterator<ObjectResourcesItem> nodeIterator;
            if (this.pre.hasNext()) {
                return true;
            }
            if (this.nextValueFromNode != null) {
                return true;
            }
            while ((nodeIterator = this.getNodeIterator()) != null && nodeIterator.hasNext()) {
                String tmp = nodeIterator.next().id;
                if (this.skip.contains(tmp)) continue;
                this.nextValueFromNode = tmp;
                return true;
            }
            return this.post.hasNext();
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.pre.hasNext()) {
                return this.pre.next();
            }
            if (this.nextValueFromNode != null) {
                String tmp = this.nextValueFromNode;
                this.nextValueFromNode = null;
                return tmp;
            }
            return this.post.next();
        }
    }
}

