/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.security.auth.Subject;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.storm.blobstore.BlobStore;
import org.apache.storm.blobstore.ClientBlobStore;
import org.apache.storm.blobstore.LocalFsBlobStore;
import org.apache.storm.blobstore.LocalModeClientBlobStore;
import org.apache.storm.daemon.StormCommon;
import org.apache.storm.generated.AccessControl;
import org.apache.storm.generated.AccessControlType;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.InvalidTopologyException;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.generated.ReadableBlobMeta;
import org.apache.storm.generated.SettableBlobMeta;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.nimbus.ILeaderElector;
import org.apache.storm.nimbus.NimbusInfo;
import org.apache.storm.scheduler.resource.ResourceUtils;
import org.apache.storm.scheduler.resource.normalization.NormalizedResourceRequest;
import org.apache.storm.security.auth.SingleUserPrincipal;
import org.apache.storm.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ReflectionUtils;
import org.apache.storm.utils.ShellUtils;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerUtils {
    public static final Logger LOG = LoggerFactory.getLogger(ServerUtils.class);
    public static final boolean IS_ON_WINDOWS = "Windows_NT".equals(System.getenv("OS"));
    public static final int SIGKILL = 9;
    public static final int SIGTERM = 15;
    private static ServerUtils _instance = new ServerUtils();
    private static final Pattern MEMINFO_PATTERN = Pattern.compile("^([^:\\s]+):\\s*([0-9]+)\\s*kB$");
    private static final Map<String, Integer> cachedUserToUidMap = new ConcurrentHashMap<String, Integer>();

    public static ServerUtils setInstance(ServerUtils u) {
        ServerUtils oldInstance = _instance;
        _instance = u;
        return oldInstance;
    }

    public static <T> List<T> interleaveAll(List<List<T>> nodeList) {
        if (nodeList != null && nodeList.size() > 0) {
            ArrayList<T> first = new ArrayList<T>();
            ArrayList<List<T>> rest = new ArrayList<List<T>>();
            for (List<T> node : nodeList) {
                if (node == null || node.size() <= 0) continue;
                first.add(node.get(0));
                rest.add(node.subList(1, node.size()));
            }
            List<T> interleaveRest = ServerUtils.interleaveAll(rest);
            if (interleaveRest != null) {
                first.addAll(interleaveRest);
            }
            return first;
        }
        return null;
    }

    public static BlobStore getNimbusBlobStore(Map<String, Object> conf, NimbusInfo nimbusInfo, ILeaderElector leaderElector) {
        return ServerUtils.getNimbusBlobStore(conf, null, nimbusInfo, leaderElector);
    }

    public static BlobStore getNimbusBlobStore(Map<String, Object> conf, String baseDir, NimbusInfo nimbusInfo, ILeaderElector leaderElector) {
        String type = (String)conf.get("nimbus.blobstore.class");
        if (type == null) {
            type = LocalFsBlobStore.class.getName();
        }
        BlobStore store = (BlobStore)ReflectionUtils.newInstance((String)type);
        HashMap<String, Object> nconf = new HashMap<String, Object>(conf);
        nconf.put("blobstore.cleanup.enable", Boolean.TRUE);
        if (store != null) {
            store.prepare(nconf, baseDir, nimbusInfo, leaderElector);
        }
        return store;
    }

    public static boolean isAbsolutePath(String path) {
        return Paths.get(path, new String[0]).isAbsolute();
    }

    public static String shellCmd(List<String> command) {
        ArrayList<CallSite> changedCommands = new ArrayList<CallSite>(command.size());
        for (String str : command) {
            if (str == null) continue;
            changedCommands.add((CallSite)((Object)("'" + str.replaceAll("'", "'\"'\"'") + "'")));
        }
        return StringUtils.join(changedCommands, (String)" ");
    }

    public static long getDiskUsage(File dir) {
        long size = 0L;
        if (!dir.exists()) {
            return 0L;
        }
        if (!dir.isDirectory()) {
            return dir.length();
        }
        File[] allFiles = dir.listFiles();
        if (allFiles != null) {
            for (int i = 0; i < allFiles.length; ++i) {
                boolean isSymLink = FileUtils.isSymlink((File)allFiles[i]);
                if (isSymLink) continue;
                size += ServerUtils.getDiskUsage(allFiles[i]);
            }
        }
        return size;
    }

    public static ClientBlobStore getClientBlobStoreForSupervisor(Map<String, Object> conf) {
        Object store = ConfigUtils.isLocalMode(conf) ? new LocalModeClientBlobStore(ServerUtils.getNimbusBlobStore(conf, null, null)) : (ClientBlobStore)ReflectionUtils.newInstance((String)((String)conf.get("supervisor.blobstore.class")));
        store.prepare(conf);
        return store;
    }

    public static String currentClasspath() {
        return _instance.currentClasspathImpl();
    }

    public static URL getResourceFromClassloader(String name) {
        return _instance.getResourceFromClassloaderImpl(name);
    }

    public static boolean zipDoesContainDir(String zipfile, String target) throws IOException {
        ArrayList<? extends ZipEntry> entries = Collections.list(new ZipFile(zipfile).entries());
        String targetDir = target + "/";
        for (ZipEntry zipEntry : entries) {
            String name = zipEntry.getName();
            if (!name.startsWith(targetDir)) continue;
            return true;
        }
        return false;
    }

    public static String getFileOwner(String path) throws IOException {
        return Files.getOwner(FileSystems.getDefault().getPath(path, new String[0]), new LinkOption[0]).getName();
    }

    public static String containerFilePath(String dir) {
        return dir + File.separator + "launch_container.sh";
    }

    public static String scriptFilePath(String dir) {
        return dir + File.separator + "storm-worker-script.sh";
    }

    public static String writeScript(String dir, List<String> command, Map<String, String> environment) throws IOException {
        return ServerUtils.writeScript(dir, command, environment, null);
    }

    public static String writeScript(String dir, List<String> command, Map<String, String> environment, String umask) throws IOException {
        String path = ServerUtils.scriptFilePath(dir);
        try (BufferedWriter out = new BufferedWriter(new FileWriter(path));){
            out.write("#!/bin/bash");
            out.newLine();
            if (environment != null) {
                for (String k : environment.keySet()) {
                    String v = environment.get(k);
                    if (v == null) {
                        v = "";
                    }
                    out.write(ServerUtils.shellCmd(Arrays.asList("export", k + "=" + v)));
                    out.write(";");
                    out.newLine();
                }
            }
            out.newLine();
            if (umask != null) {
                out.write("umask " + umask);
                out.newLine();
            }
            out.write("exec " + ServerUtils.shellCmd(command) + ";");
        }
        return path;
    }

    public static int execCommand(String ... command) throws ExecuteException, IOException {
        CommandLine cmd = new CommandLine(command[0]);
        for (int i = 1; i < command.length; ++i) {
            cmd.addArgument(command[i]);
        }
        DefaultExecutor exec = new DefaultExecutor();
        return exec.execute(cmd);
    }

    public static void sendSignalToProcess(long lpid, int signum) throws IOException {
        String pid = Long.toString(lpid);
        try {
            if (Utils.isOnWindows()) {
                if (signum == 9) {
                    ServerUtils.execCommand("taskkill", "/f", "/pid", pid);
                } else {
                    ServerUtils.execCommand("taskkill", "/pid", pid);
                }
            } else {
                ServerUtils.execCommand("kill", "-" + signum, pid);
            }
        }
        catch (ExecuteException e) {
            LOG.info("Error when trying to kill {}. Process is probably already dead.", (Object)pid);
        }
        catch (IOException e) {
            LOG.info("IOException Error when trying to kill {}.", (Object)pid);
            throw e;
        }
    }

    public static void killProcessWithSigTerm(String pid) throws IOException {
        ServerUtils.sendSignalToProcess(Long.parseLong(pid), 15);
    }

    public static void forceKillProcess(String pid) throws IOException {
        ServerUtils.sendSignalToProcess(Long.parseLong(pid), 9);
    }

    public static long nimbusVersionOfBlob(String key, ClientBlobStore cb) throws AuthorizationException, KeyNotFoundException {
        long nimbusBlobVersion = 0L;
        ReadableBlobMeta metadata = cb.getBlobMeta(key);
        nimbusBlobVersion = metadata.get_version();
        return nimbusBlobVersion;
    }

    public static boolean canUserReadBlob(ReadableBlobMeta meta, String user, Map<String, Object> conf) {
        if (!ObjectReader.getBoolean((Object)conf.get("storm.blobstore.acl.validation.enabled"), (boolean)false)) {
            return true;
        }
        SettableBlobMeta settable = meta.get_settable();
        for (AccessControl acl : settable.get_acl()) {
            if (acl.get_type().equals((Object)AccessControlType.OTHER) && (acl.get_access() & 1) > 0) {
                return true;
            }
            if (!acl.get_name().equals(user) || (acl.get_access() & 1) <= 0) continue;
            return true;
        }
        return false;
    }

    public static void unJar(File jarFile, File toDir) throws IOException {
        try (JarFile jar = new JarFile(jarFile);){
            ServerUtils.extractZipFile(jar, toDir, null);
        }
    }

    private static void ensureDirectory(File dir) throws IOException {
        if (!dir.mkdirs() && !dir.isDirectory()) {
            throw new IOException("Mkdirs failed to create " + dir.toString());
        }
    }

    public static void unTar(File inFile, File untarDir, boolean symlinksDisabled) throws IOException {
        ServerUtils.ensureDirectory(untarDir);
        boolean gzipped = inFile.toString().endsWith("gz");
        if (Utils.isOnWindows() || symlinksDisabled) {
            ServerUtils.unTarUsingJava(inFile, untarDir, gzipped, symlinksDisabled);
        } else {
            ServerUtils.unTarUsingTar(inFile, untarDir, gzipped);
        }
    }

    private static void unTarUsingTar(File inFile, File untarDir, boolean gzipped) throws IOException {
        StringBuffer untarCommand = new StringBuffer();
        if (gzipped) {
            untarCommand.append(" gzip -dc '");
            untarCommand.append(inFile.toString());
            untarCommand.append("' | (");
        }
        untarCommand.append("cd '");
        untarCommand.append(untarDir.toString());
        untarCommand.append("' ; ");
        untarCommand.append("tar -xf ");
        if (gzipped) {
            untarCommand.append(" -)");
        } else {
            untarCommand.append(inFile.toString());
        }
        String[] shellCmd = new String[]{"bash", "-c", untarCommand.toString()};
        ShellUtils.ShellCommandExecutor shexec = new ShellUtils.ShellCommandExecutor(shellCmd);
        shexec.execute();
        int exitcode = shexec.getExitCode();
        if (exitcode != 0) {
            throw new IOException("Error untarring file " + inFile + ". Tar process exited with exit code " + exitcode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unTarUsingJava(File inFile, File untarDir, boolean gzipped, boolean symlinksDisabled) throws IOException {
        String base = untarDir.getCanonicalPath();
        LOG.trace("java untar {} to {}", (Object)inFile, (Object)base);
        try (InputStream inputStream = null;){
            inputStream = gzipped ? new BufferedInputStream(new GZIPInputStream(new FileInputStream(inFile))) : new BufferedInputStream(new FileInputStream(inFile));
            try (TarArchiveInputStream tis = new TarArchiveInputStream(inputStream);){
                TarArchiveEntry entry = tis.getNextTarEntry();
                while (entry != null) {
                    ServerUtils.unpackEntries(tis, entry, untarDir, base, symlinksDisabled);
                    entry = tis.getNextTarEntry();
                }
            }
        }
    }

    private static void unpackEntries(TarArchiveInputStream tis, TarArchiveEntry entry, File outputDir, String base, boolean symlinksDisabled) throws IOException {
        File target = new File(outputDir, entry.getName());
        String found = target.getCanonicalPath();
        if (!found.startsWith(base)) {
            LOG.error("Invalid location {} is outside of {}", (Object)found, (Object)base);
            return;
        }
        if (entry.isDirectory()) {
            LOG.trace("Extracting dir {}", (Object)target);
            ServerUtils.ensureDirectory(target);
            for (TarArchiveEntry e : entry.getDirectoryEntries()) {
                ServerUtils.unpackEntries(tis, e, target, base, symlinksDisabled);
            }
        } else if (entry.isSymbolicLink()) {
            if (symlinksDisabled) {
                LOG.info("Symlinks disabled skipping {}", (Object)target);
            } else {
                Path src = target.toPath();
                Path dest = Paths.get(entry.getLinkName(), new String[0]);
                LOG.trace("Extracting sym link {} to {}", (Object)target, (Object)dest);
                Files.createSymbolicLink(src, dest, new FileAttribute[0]);
            }
        } else if (entry.isFile()) {
            LOG.trace("Extracting file {}", (Object)target);
            ServerUtils.ensureDirectory(target.getParentFile());
            try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(target));){
                IOUtils.copy((InputStream)tis, (OutputStream)outputStream);
            }
        } else {
            LOG.error("{} is not a currently supported tar entry type.", (Object)entry);
        }
        Path p = target.toPath();
        if (Files.exists(p, new LinkOption[0])) {
            try {
                int mode = entry.getMode();
                Files.setPosixFilePermissions(p, ServerUtils.parsePerms(mode));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    private static Set<PosixFilePermission> parsePerms(int mode) {
        HashSet<PosixFilePermission> ret = new HashSet<PosixFilePermission>();
        if ((mode & 1) > 0) {
            ret.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        if ((mode & 2) > 0) {
            ret.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 4) > 0) {
            ret.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 8) > 0) {
            ret.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 0x10) > 0) {
            ret.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 0x20) > 0) {
            ret.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x40) > 0) {
            ret.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x80) > 0) {
            ret.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x100) > 0) {
            ret.add(PosixFilePermission.OWNER_READ);
        }
        return ret;
    }

    public static void unpack(File localrsrc, File dst, boolean symLinksDisabled) throws IOException {
        String lowerDst = localrsrc.getName().toLowerCase();
        if (lowerDst.endsWith(".jar") || lowerDst.endsWith("_jar")) {
            ServerUtils.unJar(localrsrc, dst);
        } else if (lowerDst.endsWith(".zip") || lowerDst.endsWith("_zip")) {
            ServerUtils.unZip(localrsrc, dst);
        } else if (lowerDst.endsWith(".tar.gz") || lowerDst.endsWith("_tar_gz") || lowerDst.endsWith(".tgz") || lowerDst.endsWith("_tgz") || lowerDst.endsWith(".tar") || lowerDst.endsWith("_tar")) {
            ServerUtils.unTar(localrsrc, dst, symLinksDisabled);
        } else {
            LOG.warn("Cannot unpack " + localrsrc);
            if (!localrsrc.renameTo(dst)) {
                throw new IOException("Unable to rename file: [" + localrsrc + "] to [" + dst + "]");
            }
        }
        if (localrsrc.isFile()) {
            localrsrc.delete();
        }
    }

    public static void extractZipFile(ZipFile zipFile, File toDir, String prefix) throws IOException {
        ServerUtils.ensureDirectory(toDir);
        String base = toDir.getCanonicalPath();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            String entryName;
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory() || prefix != null && !entry.getName().startsWith(prefix)) continue;
            if (prefix != null) {
                entryName = entry.getName().substring(prefix.length());
                LOG.debug("Extracting {} shortened to {} into {}", new Object[]{entry.getName(), entryName, toDir});
            } else {
                entryName = entry.getName();
            }
            File file = new File(toDir, entryName);
            String found = file.getCanonicalPath();
            if (!found.startsWith(base)) {
                LOG.error("Invalid location {} is outside of {}", (Object)found, (Object)base);
                continue;
            }
            InputStream in = zipFile.getInputStream(entry);
            try {
                ServerUtils.ensureDirectory(file.getParentFile());
                try (FileOutputStream out = new FileOutputStream(file);){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
            }
            finally {
                if (in == null) continue;
                in.close();
            }
        }
    }

    public static void unZip(File inFile, File toDir) throws IOException {
        try (ZipFile zipFile = new ZipFile(inFile);){
            ServerUtils.extractZipFile(zipFile, toDir, null);
        }
    }

    public static long zipFileSize(File myFile) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(myFile, "r");){
            raf.seek(raf.length() - 4L);
            long b4 = raf.read();
            long b3 = raf.read();
            long b2 = raf.read();
            long b1 = raf.read();
            long l = b1 << 24 | (b2 << 16) + (b3 << 8) + b4;
            return l;
        }
    }

    public static boolean isRas(Map<String, Object> conf) {
        return conf.containsKey("storm.scheduler") && conf.get("storm.scheduler").equals("org.apache.storm.scheduler.resource.ResourceAwareScheduler");
    }

    public static int getEstimatedWorkerCountForRasTopo(Map<String, Object> topoConf, StormTopology topology) throws InvalidTopologyException {
        Double defaultWorkerMaxHeap = ObjectReader.getDouble((Object)topoConf.get("worker.heap.memory.mb"), (Double)768.0);
        Double topologyWorkerMaxHeap = ObjectReader.getDouble((Object)topoConf.get("topology.worker.max.heap.size.mb"), (Double)defaultWorkerMaxHeap);
        return (int)Math.ceil(ServerUtils.getEstimatedTotalHeapMemoryRequiredByTopo(topoConf, topology) / topologyWorkerMaxHeap);
    }

    public static double getEstimatedTotalHeapMemoryRequiredByTopo(Map<String, Object> topoConf, StormTopology topology) throws InvalidTopologyException {
        double memoryRequirement;
        int parallelism;
        Map<String, Integer> componentParallelism = ServerUtils.getComponentParallelism(topoConf, topology);
        double totalMemoryRequired = 0.0;
        for (Map.Entry<String, NormalizedResourceRequest> entry : ResourceUtils.getBoltsResources(topology, topoConf).entrySet()) {
            parallelism = componentParallelism.getOrDefault(entry.getKey(), 1);
            memoryRequirement = entry.getValue().getOnHeapMemoryMb();
            totalMemoryRequired += memoryRequirement * (double)parallelism;
        }
        for (Map.Entry<String, NormalizedResourceRequest> entry : ResourceUtils.getSpoutsResources(topology, topoConf).entrySet()) {
            parallelism = componentParallelism.getOrDefault(entry.getKey(), 1);
            memoryRequirement = entry.getValue().getOnHeapMemoryMb();
            totalMemoryRequired += memoryRequirement * (double)parallelism;
        }
        double ackerMem = ServerUtils.getTotalAckerExecutorMemoryUsageForTopo(topology, topoConf);
        return totalMemoryRequired += ackerMem;
    }

    private static double getTotalAckerExecutorMemoryUsageForTopo(StormTopology topology, Map<String, Object> topologyConf) throws InvalidTopologyException {
        Map<String, NormalizedResourceRequest> boltResources = ResourceUtils.getBoltsResources(topology = StormCommon.systemTopology(topologyConf, (StormTopology)topology), topologyConf);
        NormalizedResourceRequest entry = boltResources.get("__acker");
        if (entry == null) {
            return 0.0;
        }
        Map<String, Integer> componentParallelism = ServerUtils.getComponentParallelism(topologyConf, topology);
        int parallelism = componentParallelism.getOrDefault("__acker", 1);
        return entry.getTotalMemoryMb() * (double)parallelism;
    }

    public static Map<String, Integer> getComponentParallelism(Map<String, Object> topoConf, StormTopology topology) throws InvalidTopologyException {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        Map components = StormCommon.allComponents((StormTopology)topology);
        for (Map.Entry entry : components.entrySet()) {
            ret.put((String)entry.getKey(), ServerUtils.getComponentParallelism(topoConf, entry.getValue()));
        }
        return ret;
    }

    public static int getComponentParallelism(Map<String, Object> topoConf, Object component) throws InvalidTopologyException {
        Map combinedConf = Utils.merge(topoConf, (Map)StormCommon.componentConf((Object)component));
        int numTasks = ObjectReader.getInt(combinedConf.get("topology.tasks"), (Integer)StormCommon.numStartExecutors((Object)component));
        Integer maxParallel = ObjectReader.getInt(combinedConf.get("topology.max.task.parallelism"), null);
        int ret = numTasks;
        if (maxParallel != null) {
            ret = Math.min(maxParallel, numTasks);
        }
        return ret;
    }

    public static Subject principalNameToSubject(String name) {
        SingleUserPrincipal principal = new SingleUserPrincipal(name);
        Subject sub = new Subject();
        sub.getPrincipals().add((Principal)principal);
        return sub;
    }

    public String currentClasspathImpl() {
        return System.getProperty("java.class.path");
    }

    public URL getResourceFromClassloaderImpl(String name) {
        return Thread.currentThread().getContextClassLoader().getResource(name);
    }

    public static long getMemInfoFreeMb() throws IOException {
        long memFree = 0L;
        long buffers = 0L;
        long cached = 0L;
        try (BufferedReader in = new BufferedReader(new FileReader("/proc/meminfo"));){
            String line = null;
            while ((line = in.readLine()) != null) {
                Matcher match = MEMINFO_PATTERN.matcher(line);
                if (!match.matches()) continue;
                String tag = match.group(1);
                if (tag.equalsIgnoreCase("MemFree")) {
                    memFree = Long.parseLong(match.group(2));
                    continue;
                }
                if (tag.equalsIgnoreCase("Buffers")) {
                    buffers = Long.parseLong(match.group(2));
                    continue;
                }
                if (!tag.equalsIgnoreCase("Cached")) continue;
                cached = Long.parseLong(match.group(2));
            }
        }
        return (memFree + buffers + cached) / 1024L;
    }

    public static boolean isProcessAlive(long pid, String user) throws IOException {
        if (IS_ON_WINDOWS) {
            return ServerUtils.isWindowsProcessAlive(pid, user);
        }
        return ServerUtils.isPosixProcessAlive(pid, user);
    }

    private static boolean isWindowsProcessAlive(long pid, String user) throws IOException {
        boolean ret = false;
        LOG.debug("CMD: tasklist /fo list /fi \"pid eq {}\" /v", (Object)pid);
        ProcessBuilder pb = new ProcessBuilder("tasklist", "/fo", "list", "/fi", "pid eq " + pid, "/v");
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(pb.start().getInputStream(), StandardCharsets.UTF_8));){
            String line;
            int lineNo = 0;
            while ((line = in.readLine()) != null) {
                LOG.debug("CMD=LINE#{}: {}", (Object)(++lineNo), (Object)line);
                if (!line.contains("User Name:")) continue;
                List<String> userNameLineSplitOnWhitespace = Arrays.asList(line.split(":"));
                if (userNameLineSplitOnWhitespace.size() == 2) {
                    List<String> userAndMaybeDomain = Arrays.asList(userNameLineSplitOnWhitespace.get(1).trim().split("\\\\"));
                    String processUser = userAndMaybeDomain.size() == 2 ? userAndMaybeDomain.get(1) : userAndMaybeDomain.get(0);
                    if (user.equals(processUser = processUser.trim())) {
                        ret = true;
                    } else {
                        LOG.info("Found {} running as {}, but expected it to be {}", new Object[]{pid, processUser, user});
                    }
                } else {
                    LOG.error("Received unexpected output from tasklist command. Expected one colon in user name line. Line was {}", (Object)line);
                }
                break;
            }
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isPosixProcessAlive(long pid, String user) throws IOException {
        LOG.debug("CMD: ps -o user -p {}", (Object)pid);
        ProcessBuilder pb = new ProcessBuilder("ps", "-o", "user", "-p", String.valueOf(pid));
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(pb.start().getInputStream(), StandardCharsets.UTF_8));){
            int lineNo = 1;
            String line = in.readLine();
            LOG.debug("CMD-LINE#{}: {}", (Object)lineNo, (Object)line);
            if (!"USER".equals(line.trim())) {
                LOG.error("Expecting first line to contain USER, found \"{}\"", (Object)line);
                boolean bl = false;
                return bl;
            }
            while ((line = in.readLine()) != null) {
                LOG.debug("CMD-LINE#{}: {}", (Object)(++lineNo), (Object)line);
                line = line.trim();
                if (user.equals(line)) {
                    boolean bl = true;
                    return bl;
                }
                LOG.info("Found {} running as {}, but expected it to be {}", new Object[]{pid, line, user});
            }
            return false;
        }
        catch (IOException ex) {
            String err = String.format("Cannot read output of command \"ps -o user -p %d\"", pid);
            throw new IOException(err, ex);
        }
    }

    public static boolean isAnyProcessAlive(Collection<Long> pids, String user) throws IOException {
        if (pids == null || pids.isEmpty()) {
            return false;
        }
        if (IS_ON_WINDOWS) {
            return ServerUtils.isAnyWindowsProcessAlive(pids, user);
        }
        return ServerUtils.isAnyPosixProcessAlive(pids, user);
    }

    public static boolean isAnyProcessAlive(Collection<Long> pids, int uid) throws IOException {
        if (pids == null || pids.isEmpty()) {
            return false;
        }
        if (IS_ON_WINDOWS) {
            return ServerUtils.isAnyWindowsProcessAlive(pids, uid);
        }
        return ServerUtils.isAnyPosixProcessAlive(pids, uid);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isAnyWindowsProcessAlive(Collection<Long> pids, String user) throws IOException {
        ArrayList<String> unexpectedUsers = new ArrayList<String>();
        block8: for (Long pid : pids) {
            ArrayList<String> cmdArgs = new ArrayList<String>();
            cmdArgs.add("tasklist");
            cmdArgs.add("/fo");
            cmdArgs.add("list");
            cmdArgs.add("/fi");
            cmdArgs.add("pid eq " + pid);
            cmdArgs.add("/v");
            LOG.debug("CMD: {}", (Object)String.join((CharSequence)" ", cmdArgs));
            ProcessBuilder pb = new ProcessBuilder(cmdArgs);
            pb.redirectError(ProcessBuilder.Redirect.INHERIT);
            try (BufferedReader in = new BufferedReader(new InputStreamReader(pb.start().getInputStream(), StandardCharsets.UTF_8));){
                String line;
                int lineNo = 0;
                while ((line = in.readLine()) != null) {
                    LOG.debug("CMD-LINE#{}: {}", (Object)(++lineNo), (Object)line);
                    if (!line.contains("User Name:")) continue;
                    List<String> userNameLineSplitOnWhitespace = Arrays.asList(line.split(":"));
                    if (userNameLineSplitOnWhitespace.size() == 2) {
                        List<String> userAndMaybeDomain = Arrays.asList(userNameLineSplitOnWhitespace.get(1).trim().split("\\\\"));
                        String processUser = userAndMaybeDomain.size() == 2 ? userAndMaybeDomain.get(1) : userAndMaybeDomain.get(0);
                        if (user.equals(processUser = processUser.trim())) {
                            boolean bl = true;
                            return bl;
                        }
                        unexpectedUsers.add(processUser);
                        continue block8;
                    }
                    LOG.error("Received unexpected output from tasklist command. Expected one colon in user name line. Line was {}", (Object)line);
                    continue block8;
                }
            }
            catch (IOException ex) {
                String err = String.format("Cannot read output of command \"%s\"", String.join((CharSequence)" ", cmdArgs));
                throw new IOException(err, ex);
            }
        }
        String pidsAsStr = StringUtils.join(pids, (String)",");
        if (unexpectedUsers.isEmpty()) {
            LOG.info("None of the processes {} are alive", (Object)pidsAsStr);
            return false;
        }
        LOG.info("{} of the Processes {} are running as user(s) {}: but expected user is {}", new Object[]{unexpectedUsers.size(), pidsAsStr, String.join((CharSequence)",", new TreeSet(unexpectedUsers)), user});
        return false;
    }

    private static boolean isAnyWindowsProcessAlive(Collection<Long> pids, int uid) throws IOException {
        throw new IllegalArgumentException("UID is not supported on Windows");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isAnyPosixProcessAlive(Collection<Long> pids, String user) throws IOException {
        String pidParams = StringUtils.join(pids, (String)",");
        LOG.debug("CMD: ps -o user -p {}", (Object)pidParams);
        ProcessBuilder pb = new ProcessBuilder("ps", "-o", "user", "-p", pidParams);
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        ArrayList<String> unexpectedUsers = new ArrayList<String>();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(pb.start().getInputStream(), StandardCharsets.UTF_8));){
            int lineNo = 1;
            String line = in.readLine();
            LOG.debug("CMD-LINE#{}: {}", (Object)lineNo, (Object)line);
            if (!"USER".equals(line.trim())) {
                LOG.error("Expecting first line to contain USER, found \"{}\"", (Object)line);
                boolean bl = false;
                return bl;
            }
            while ((line = in.readLine()) != null) {
                LOG.debug("CMD-LINE#{}: {}", (Object)(++lineNo), (Object)line);
                line = line.trim();
                if (user.equals(line)) {
                    boolean bl = true;
                    return bl;
                }
                unexpectedUsers.add(line);
            }
        }
        catch (IOException ex) {
            String err = String.format("Cannot read output of command \"ps -o user -p %s\"", pidParams);
            throw new IOException(err, ex);
        }
        if (unexpectedUsers.isEmpty()) {
            LOG.info("None of the processes {} are alive", (Object)pidParams);
            return false;
        }
        LOG.info("{} of {} Processes {} are running as user(s) {}: but expected user is {}", new Object[]{unexpectedUsers.size(), pids.size(), pidParams, String.join((CharSequence)",", new TreeSet(unexpectedUsers)), user});
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isAnyPosixProcessAlive(Collection<Long> pids, int uid) throws IOException {
        String pidParams = StringUtils.join(pids, (String)",");
        LOG.debug("CMD: ps -o uid -p {}", (Object)pidParams);
        ProcessBuilder pb = new ProcessBuilder("ps", "-o", "uid", "-p", pidParams);
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        ArrayList<String> unexpectedUsers = new ArrayList<String>();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(pb.start().getInputStream(), StandardCharsets.UTF_8));){
            int lineNo = 1;
            String line = in.readLine();
            LOG.debug("CMD-LINE#{}: {}", (Object)lineNo, (Object)line);
            if (!"UID".equals(line.trim())) {
                LOG.error("Expecting first line to contain UID, found \"{}\"", (Object)line);
                boolean bl = false;
                return bl;
            }
            while ((line = in.readLine()) != null) {
                LOG.debug("CMD-LINE#{}: {}", (Object)(++lineNo), (Object)line);
                line = line.trim();
                try {
                    if (uid == Integer.parseInt(line)) {
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (Exception ex) {
                    LOG.warn("Expecting UID integer but got {} in output of ps command", (Object)line);
                }
                unexpectedUsers.add(line);
            }
        }
        catch (IOException ex) {
            String err = String.format("Cannot read output of command \"ps -o uid -p %s\"", pidParams);
            throw new IOException(err, ex);
        }
        if (unexpectedUsers.isEmpty()) {
            LOG.info("None of the processes {} are alive", (Object)pidParams);
            return false;
        }
        LOG.info("{} of {} Processes {} are running as UIDs {}: but expected userId is {}", new Object[]{unexpectedUsers.size(), pids.size(), pidParams, String.join((CharSequence)",", new TreeSet(unexpectedUsers)), uid});
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static int getUserId(String user) {
        if (IS_ON_WINDOWS) {
            throw new IllegalArgumentException("Not supported in Windows platform");
        }
        ArrayList<String> cmdArgs = new ArrayList<String>();
        cmdArgs.add("id");
        cmdArgs.add("-u");
        if (user != null && !user.isEmpty()) {
            cmdArgs.add(user);
            int exitCode = 0;
            try {
                exitCode = new ProcessBuilder(cmdArgs).start().waitFor();
            }
            catch (Exception exception) {
            }
            finally {
                if (exitCode != 0) {
                    LOG.debug("CMD: '{}' returned exit code of {}", (Object)String.join((CharSequence)" ", cmdArgs), (Object)exitCode);
                    cmdArgs.remove(user);
                }
            }
        }
        LOG.debug("CMD: {}", (Object)String.join((CharSequence)" ", cmdArgs));
        ProcessBuilder pb = new ProcessBuilder(cmdArgs);
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(pb.start().getInputStream(), StandardCharsets.UTF_8));){
            String line = in.readLine();
            LOG.debug("CMD-LINE#1: {}", (Object)line);
            try {
                int n = Integer.parseInt(line.trim());
                return n;
            }
            catch (NumberFormatException ex) {
                LOG.error("Expecting UID integer but got {} in output of \"id -u {}\" command", (Object)line, (Object)user);
                int n2 = -1;
                in.close();
                return n2;
            }
        }
        catch (IOException ex2) {
            LOG.error(String.format("Cannot read output of command \"%s\"", String.join((CharSequence)" ", cmdArgs)), (Throwable)ex2);
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getPathOwnerUid(String fpath) {
        if (IS_ON_WINDOWS) {
            throw new IllegalArgumentException("Not supported in Windows platform");
        }
        File f = new File(fpath);
        if (!f.exists()) {
            LOG.error("Cannot determine owner of non-existent file {}", (Object)fpath);
            return -1;
        }
        LOG.debug("CMD: ls -dn {}", (Object)fpath);
        ProcessBuilder pb = new ProcessBuilder("ls", "-dn", fpath);
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(pb.start().getInputStream(), StandardCharsets.UTF_8));){
            String line = in.readLine();
            LOG.debug("CMD-OUTLINE: {}", (Object)line);
            line = line.trim();
            String[] parts = line.split("\\s+");
            if (parts.length < 3) {
                LOG.error("Expecting at least 3 space separated fields in \"ls -dn {}\" output, got {}", (Object)fpath, (Object)line);
                int n2 = -1;
                return n2;
            }
            int n = Integer.parseInt(parts[2]);
            return n;
        }
        catch (IOException ex2) {
            LOG.error(String.format("Cannot read output of command \"ls -dn %s\"", fpath), (Throwable)ex2);
            return -1;
        }
    }

    private static int getWorkerPathOwnerUid(Map<String, Object> conf, String workerId) {
        return ServerUtils.getPathOwnerUid(ConfigUtils.workerRoot(conf, (String)workerId));
    }

    public static boolean areAllProcessesDead(Map<String, Object> conf, String user, String workerId, Set<Long> pids) throws IOException {
        if (pids == null || pids.isEmpty()) {
            return true;
        }
        if (IS_ON_WINDOWS) {
            return !ServerUtils.isAnyProcessAlive(pids, user);
        }
        try {
            return !ServerUtils.isAnyPosixProcessPidDirAlive(pids, user);
        }
        catch (IOException ex) {
            LOG.warn("Failed to determine if processes {} for user {} are dead using filesystem, will try \"ps\" command: {}", new Object[]{pids, user, ex});
            if (!cachedUserToUidMap.containsKey(user)) {
                int uid = ServerUtils.getWorkerPathOwnerUid(conf, workerId);
                if (uid < 0) {
                    uid = ServerUtils.getUserId(user);
                }
                if (uid >= 0) {
                    cachedUserToUidMap.put(user, uid);
                }
            }
            if (cachedUserToUidMap.containsKey(user)) {
                return !ServerUtils.isAnyProcessAlive(pids, cachedUserToUidMap.get(user));
            }
            return !ServerUtils.isAnyProcessAlive(pids, user);
        }
    }

    public static boolean isAnyPosixProcessPidDirAlive(Collection<Long> pids, String user) throws IOException {
        return ServerUtils.isAnyPosixProcessPidDirAlive(pids, user, false);
    }

    @VisibleForTesting
    public static boolean isAnyPosixProcessPidDirAlive(Collection<Long> pids, String expectedUser, boolean mockFileOwnerToUid) throws IOException {
        File procDir = new File("/proc");
        if (!procDir.exists()) {
            throw new IOException("Missing process directory " + procDir.getAbsolutePath() + ": method not supported on os.name=" + System.getProperty("os.name"));
        }
        for (long pid : pids) {
            String actualUser;
            File pidDir = new File(procDir, String.valueOf(pid));
            if (!pidDir.exists()) continue;
            try {
                actualUser = Files.getOwner(pidDir.toPath(), new LinkOption[0]).getName();
            }
            catch (NoSuchFileException ex) {
                continue;
            }
            if (mockFileOwnerToUid) {
                if (StringUtils.isNumeric((String)actualUser)) {
                    LOG.info("Skip mocking, since owner {} of pidDir {} is already numeric", (Object)actualUser, (Object)pidDir);
                } else {
                    Integer actualUid = cachedUserToUidMap.get(actualUser);
                    if (actualUid == null) {
                        actualUid = ServerUtils.getUserId(actualUser);
                        if (actualUid < 0) {
                            String err = String.format("Cannot get UID for %s, while mocking the owner of pidDir %s", actualUser, pidDir.getAbsolutePath());
                            throw new IOException(err);
                        }
                        cachedUserToUidMap.put(actualUser, actualUid);
                        LOG.info("Found UID {} for {}, while mocking the owner of pidDir {}", new Object[]{actualUid, actualUser, pidDir});
                    } else {
                        LOG.info("Found cached UID {} for {}, while mocking the owner of pidDir {}", new Object[]{actualUid, actualUser, pidDir});
                    }
                    actualUser = String.valueOf(actualUid);
                }
            }
            if (StringUtils.isNumeric((String)actualUser)) {
                LOG.debug("Process directory {} owner is uid={}", (Object)pidDir, (Object)actualUser);
                int actualUid = Integer.parseInt(actualUser);
                Integer expectedUid = cachedUserToUidMap.get(expectedUser);
                if (expectedUid == null) {
                    expectedUid = ServerUtils.getUserId(expectedUser);
                    if (expectedUid < 0) {
                        String err = String.format("Cannot get uid for %s to compare with owner id=%d of process directory %s", expectedUser, actualUid, pidDir.getAbsolutePath());
                        throw new IOException(err);
                    }
                    cachedUserToUidMap.put(expectedUser, expectedUid);
                }
                if (expectedUid == actualUid) {
                    LOG.debug("Process {} is alive and owned by expectedUser {}/{}", new Object[]{pid, expectedUser, expectedUid});
                    return true;
                }
                LOG.info("Prior process is dead, since directory {} owner {} is not same as expectedUser {}/{}, likely pid {} was reused for a new process for uid {}, {}", new Object[]{pidDir, actualUser, expectedUser, expectedUid, pid, actualUid, ServerUtils.getProcessDesc(pidDir)});
                continue;
            }
            LOG.debug("Process directory {} owner is {}", (Object)pidDir, (Object)actualUser);
            if (expectedUser.equals(actualUser)) {
                LOG.debug("Process {} is alive and owned by expectedUser {}", (Object)pid, (Object)expectedUser);
                return true;
            }
            LOG.info("Prior process is dead, since directory {} owner {} is not same as expectedUser {}, likely pid {} was reused for a new process for actualUser {}, {}}", new Object[]{pidDir, actualUser, expectedUser, pid, actualUser, ServerUtils.getProcessDesc(pidDir)});
        }
        LOG.info("None of the processes {} are alive AND owned by expectedUser {}", pids, (Object)expectedUser);
        return false;
    }

    @VisibleForTesting
    public static void validateTopologyWorkerMaxHeapSizeConfigs(Map<String, Object> stormConf, StormTopology topology, double defaultWorkerMaxHeapSizeMb) throws InvalidTopologyException {
        double largestMemReq = ServerUtils.getMaxExecutorMemoryUsageForTopo(topology, stormConf);
        double topologyWorkerMaxHeapSize = ObjectReader.getDouble((Object)stormConf.get("topology.worker.max.heap.size.mb"), (Double)defaultWorkerMaxHeapSizeMb);
        if (topologyWorkerMaxHeapSize < largestMemReq) {
            throw new InvalidTopologyException("Topology will not be able to be successfully scheduled: Config TOPOLOGY_WORKER_MAX_HEAP_SIZE_MB=" + topologyWorkerMaxHeapSize + " < " + largestMemReq + " (Largest memory requirement of a component in the topology). Perhaps set TOPOLOGY_WORKER_MAX_HEAP_SIZE_MB to a larger amount");
        }
    }

    public static void validateTopologyAckerBundleResource(Map<String, Object> topoConf, StormTopology topology, String topoName) throws InvalidTopologyException {
        boolean oneExecutorPerWorker = (Boolean)topoConf.getOrDefault("topology.ras.one.executor.per.worker", false);
        boolean oneComponentPerWorker = (Boolean)topoConf.getOrDefault("topology.ras.one.component.per.worker", false);
        double topologyWorkerMaxHeapSize = ObjectReader.getDouble((Object)topoConf.get("topology.worker.max.heap.size.mb"));
        int numOfAckerExecutorsPerWorker = ObjectReader.getInt((Object)topoConf.get("topology.ras.acker.executors.per.worker"));
        double maxTopoExecMem = ServerUtils.getMaxExecutorMemoryUsageForTopo(topology, topoConf);
        double ackerExecMem = ServerUtils.getAckerExecutorMemoryUsageForTopo(topology, topoConf);
        double minMemReqForWorker = maxTopoExecMem + ackerExecMem * (double)numOfAckerExecutorsPerWorker;
        if (!oneExecutorPerWorker && !oneComponentPerWorker && topologyWorkerMaxHeapSize < minMemReqForWorker) {
            String warnMsg = String.format("For topology %s. Worker max on-heap limit %s is %s. The biggest topo executor requires %s MB on-heap memory, there might not be enough space for %s ackers. Real acker-per-worker will be determined by scheduler.", topoName, "topology.worker.max.heap.size.mb", topologyWorkerMaxHeapSize, maxTopoExecMem, numOfAckerExecutorsPerWorker);
            LOG.warn(warnMsg);
        }
    }

    private static double getMaxExecutorMemoryUsageForTopo(StormTopology topology, Map<String, Object> topologyConf) {
        double memoryRequirement;
        double largestMemoryOperator = 0.0;
        for (NormalizedResourceRequest entry : ResourceUtils.getBoltsResources(topology, topologyConf).values()) {
            memoryRequirement = entry.getTotalMemoryMb();
            if (!(memoryRequirement > largestMemoryOperator)) continue;
            largestMemoryOperator = memoryRequirement;
        }
        for (NormalizedResourceRequest entry : ResourceUtils.getSpoutsResources(topology, topologyConf).values()) {
            memoryRequirement = entry.getTotalMemoryMb();
            if (!(memoryRequirement > largestMemoryOperator)) continue;
            largestMemoryOperator = memoryRequirement;
        }
        return largestMemoryOperator;
    }

    private static double getAckerExecutorMemoryUsageForTopo(StormTopology topology, Map<String, Object> topologyConf) throws InvalidTopologyException {
        Map<String, NormalizedResourceRequest> boltResources = ResourceUtils.getBoltsResources(topology = StormCommon.systemTopology(topologyConf, (StormTopology)topology), topologyConf);
        NormalizedResourceRequest entry = boltResources.get("__acker");
        if (entry == null) {
            return 0.0;
        }
        return entry.getTotalMemoryMb();
    }

    private static String getProcessDesc(File pidDir) {
        String comm = "";
        Path p = pidDir.toPath().resolve("comm");
        try {
            comm = String.join((CharSequence)", ", Files.readAllLines(p));
        }
        catch (IOException ex) {
            LOG.warn("Cannot get contents of " + p, (Throwable)ex);
        }
        String cmdline = "";
        p = pidDir.toPath().resolve("cmdline");
        try {
            cmdline = String.join((CharSequence)", ", Files.readAllLines(p)).replace('\u0000', ' ');
        }
        catch (IOException ex) {
            LOG.warn("Cannot get contents of " + p, (Throwable)ex);
        }
        return String.format("process(comm=\"%s\", cmdline=\"%s\")", comm, cmdline);
    }
}

