/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource.strategies.priority;

import java.util.Collections;
import java.util.Comparator;
import org.apache.storm.scheduler.ISchedulingState;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.resource.User;
import org.apache.storm.scheduler.resource.strategies.priority.DefaultSchedulingPriorityStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FIFOSchedulingPriorityStrategy
extends DefaultSchedulingPriorityStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(FIFOSchedulingPriorityStrategy.class);

    @Override
    protected DefaultSchedulingPriorityStrategy.SimulatedUser getSimulatedUserFor(User u, ISchedulingState cluster) {
        return new FIFOSimulatedUser(u, cluster);
    }

    private static class TopologyBySubmissionTimeComparator
    implements Comparator<TopologyDetails> {
        private TopologyBySubmissionTimeComparator() {
        }

        @Override
        public int compare(TopologyDetails topo1, TopologyDetails topo2) {
            if (topo1.getUpTime() > topo2.getUpTime()) {
                return 1;
            }
            if (topo1.getUpTime() < topo2.getUpTime()) {
                return -1;
            }
            return topo1.getId().compareTo(topo2.getId());
        }
    }

    protected static class FIFOSimulatedUser
    extends DefaultSchedulingPriorityStrategy.SimulatedUser {
        public FIFOSimulatedUser(User other, ISchedulingState cluster) {
            super(other, cluster);
        }

        @Override
        public double getScore(double availableCpu, double availableMemory) {
            TopologyDetails td = this.getNextHighest();
            double origScore = this.getScore(availableCpu, availableMemory, td);
            if (origScore < 0.0) {
                return origScore;
            }
            Collections.sort(this.tds, new TopologyBySubmissionTimeComparator());
            td = this.getNextHighest();
            if (td != null) {
                LOG.debug("SCORE FOR {} is {}", (Object)td.getId(), (Object)td.getUpTime());
                return td.getUpTime();
            }
            return Double.MAX_VALUE;
        }
    }
}

