/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metricstore.rocksdb;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.apache.storm.metricstore.AggLevel;
import org.apache.storm.metricstore.rocksdb.KeyType;
import org.apache.storm.shade.com.google.common.primitives.UnsignedBytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDbKey
implements Comparable<RocksDbKey> {
    static final int KEY_SIZE = 38;
    private static final Logger LOG = LoggerFactory.getLogger(RocksDbKey.class);
    private static Map<Byte, RocksDbKey> PREFIX_MAP = new HashMap<Byte, RocksDbKey>();
    private byte[] key;

    RocksDbKey(KeyType type, int metadataStringId) {
        byte[] key = new byte[38];
        ByteBuffer bb = ByteBuffer.wrap(key);
        bb.put(type.getValue());
        bb.put(AggLevel.AGG_LEVEL_NONE.getValue());
        bb.putInt(metadataStringId);
        this.key = key;
    }

    RocksDbKey(byte[] raw) {
        this.key = raw;
    }

    static RocksDbKey getPrefix(KeyType type) {
        return PREFIX_MAP.get(type.getValue());
    }

    static RocksDbKey getInitialKey(KeyType type) {
        return PREFIX_MAP.get(type.getValue());
    }

    static RocksDbKey getLastKey(KeyType type) {
        byte value = (byte)(type.getValue() + 1);
        return PREFIX_MAP.get(value);
    }

    static RocksDbKey createMetricKey(AggLevel aggLevel, int topologyId, long metricTimestamp, int metricId, int componentId, int executorId, int hostId, int port, int streamId) {
        byte[] raw = new byte[38];
        ByteBuffer bb = ByteBuffer.wrap(raw);
        bb.put(KeyType.METRIC_DATA.getValue());
        bb.put(aggLevel.getValue());
        bb.putInt(topologyId);
        bb.putLong(metricTimestamp);
        bb.putInt(metricId);
        bb.putInt(componentId);
        bb.putInt(executorId);
        bb.putInt(hostId);
        bb.putInt(port);
        bb.putInt(streamId);
        RocksDbKey key = new RocksDbKey(raw);
        return key;
    }

    int getMetadataStringId() {
        if (this.getType().getValue() < KeyType.METADATA_STRING_END.getValue()) {
            return ByteBuffer.wrap(this.key, 2, 4).getInt();
        }
        throw new RuntimeException("Cannot fetch metadata string for key of type " + this.getType());
    }

    byte[] getRaw() {
        return this.key;
    }

    KeyType getType() {
        return KeyType.getKeyType(this.key[0]);
    }

    @Override
    public int compareTo(RocksDbKey o) {
        return UnsignedBytes.lexicographicalComparator().compare(this.getRaw(), o.getRaw());
    }

    int getTopologyId() {
        int val = ByteBuffer.wrap(this.key, 2, 4).getInt();
        return val;
    }

    long getTimestamp() {
        return ByteBuffer.wrap(this.key, 6, 8).getLong();
    }

    int getMetricId() {
        return ByteBuffer.wrap(this.key, 14, 4).getInt();
    }

    int getComponentId() {
        return ByteBuffer.wrap(this.key, 18, 4).getInt();
    }

    int getExecutorId() {
        return ByteBuffer.wrap(this.key, 22, 4).getInt();
    }

    int getHostnameId() {
        return ByteBuffer.wrap(this.key, 26, 4).getInt();
    }

    int getPort() {
        return ByteBuffer.wrap(this.key, 30, 4).getInt();
    }

    int getStreamId() {
        return ByteBuffer.wrap(this.key, 34, 4).getInt();
    }

    public String toString() {
        return "[0x" + DatatypeConverter.printHexBinary((byte[])this.key) + "]";
    }

    static {
        for (KeyType type : EnumSet.allOf(KeyType.class)) {
            RocksDbKey key = new RocksDbKey(type, 0);
            PREFIX_MAP.put(type.getValue(), key);
        }
        PREFIX_MAP = Collections.unmodifiableMap(PREFIX_MAP);
    }
}

