/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.trident.state;

import java.util.Map;
import org.apache.storm.redis.common.mapper.RedisDataTypeDescription;
import org.apache.storm.redis.common.mapper.RedisStoreMapper;
import org.apache.storm.redis.trident.state.AbstractRedisStateUpdater;
import org.apache.storm.redis.trident.state.RedisState;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;

public class RedisStateUpdater
extends AbstractRedisStateUpdater<RedisState> {
    public RedisStateUpdater(RedisStoreMapper storeMapper) {
        super(storeMapper);
    }

    public RedisStateUpdater withExpire(int expireIntervalSec) {
        this.setExpireInterval(expireIntervalSec);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateStatesToRedis(RedisState redisState, Map<String, String> keyToValue) {
        Jedis jedis = null;
        try {
            jedis = redisState.getJedis();
            Pipeline pipeline = jedis.pipelined();
            block7: for (Map.Entry<String, String> kvEntry : keyToValue.entrySet()) {
                String key = kvEntry.getKey();
                String value = kvEntry.getValue();
                switch (this.dataType) {
                    case STRING: {
                        if (this.expireIntervalSec > 0) {
                            pipeline.setex(key, (long)this.expireIntervalSec, value);
                            continue block7;
                        }
                        pipeline.set(key, value);
                        continue block7;
                    }
                    case HASH: {
                        pipeline.hset(this.additionalKey, key, value);
                        continue block7;
                    }
                }
                throw new IllegalArgumentException("Cannot process such data type: " + String.valueOf((Object)this.dataType));
            }
            if (this.dataType == RedisDataTypeDescription.RedisDataType.HASH && this.expireIntervalSec > 0) {
                pipeline.expire(this.additionalKey, (long)this.expireIntervalSec);
            }
            pipeline.sync();
        }
        finally {
            if (jedis != null) {
                redisState.returnJedis(jedis);
            }
        }
    }
}

