/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.common.container;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.apache.storm.redis.common.container.JedisCommandsContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.commands.JedisCommands;

public class JedisContainer
implements JedisCommandsContainer {
    private static final Logger LOG = LoggerFactory.getLogger(JedisContainer.class);
    private JedisPool jedisPool;

    public JedisContainer(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T runCommand(Function<JedisCommands, T> command) {
        Jedis jedisCommands = this.jedisPool.getResource();
        try {
            T t = command.apply((JedisCommands)jedisCommands);
            return t;
        }
        finally {
            try {
                ((Closeable)jedisCommands).close();
            }
            catch (IOException e) {
                LOG.error("Failed to close (return) instance to pool");
            }
        }
    }

    @Override
    public void close() {
        this.jedisPool.close();
    }

    @Override
    public Boolean exists(String key) {
        return this.runCommand(jedisCommands -> jedisCommands.exists(key));
    }

    @Override
    public String get(String key) {
        return this.runCommand(jedisCommands -> jedisCommands.get(key));
    }

    @Override
    public String hget(String key, String field) {
        return this.runCommand(jedisCommands -> jedisCommands.hget(key, field));
    }

    @Override
    public Long geoadd(String key, double longitude, double latitude, String member) {
        return this.runCommand(jedisCommands -> jedisCommands.geoadd(key, longitude, latitude, member));
    }

    @Override
    public List<GeoCoordinate> geopos(String key, String ... members) {
        return this.runCommand(jedisCommands -> jedisCommands.geopos(key, members));
    }

    @Override
    public Boolean hexists(String key, String field) {
        return this.runCommand(jedisCommands -> jedisCommands.hexists(key, field));
    }

    @Override
    public Long hset(String key, String field, String value) {
        return this.runCommand(jedisCommands -> jedisCommands.hset(key, field, value));
    }

    @Override
    public String lpop(String key) {
        return this.runCommand(jedisCommands -> jedisCommands.lpop(key));
    }

    @Override
    public Long pfadd(String key, String ... elements) {
        return this.runCommand(jedisCommands -> jedisCommands.pfadd(key, elements));
    }

    @Override
    public long pfcount(String key) {
        return this.runCommand(jedisCommands -> jedisCommands.pfcount(key));
    }

    @Override
    public Long rpush(String key, String ... string) {
        return this.runCommand(jedisCommands -> jedisCommands.rpush(key, string));
    }

    @Override
    public Long sadd(String key, String ... member) {
        return this.runCommand(jedisCommands -> jedisCommands.sadd(key, member));
    }

    @Override
    public Long scard(String key) {
        return this.runCommand(jedisCommands -> jedisCommands.scard(key));
    }

    @Override
    public String set(String key, String value) {
        return this.runCommand(jedisCommands -> jedisCommands.set(key, value));
    }

    @Override
    public Boolean sismember(String key, String member) {
        return this.runCommand(jedisCommands -> jedisCommands.sismember(key, member));
    }

    @Override
    public Long zadd(String key, double score, String member) {
        return this.runCommand(jedisCommands -> jedisCommands.zadd(key, score, member));
    }

    @Override
    public Long zrank(String key, String member) {
        return this.runCommand(jedisCommands -> jedisCommands.zrank(key, member));
    }

    @Override
    public Double zscore(String key, String member) {
        return this.runCommand(jedisCommands -> jedisCommands.zscore(key, member));
    }
}

