/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.common.config;

import java.io.Serializable;

public class JedisPoolConfig
implements Serializable {
    private String host;
    private int port;
    private int timeout;
    private int database;
    private String password;

    public JedisPoolConfig() {
    }

    public JedisPoolConfig(String host, int port, int timeout, String password, int database) {
        this.host = host;
        this.port = port;
        this.timeout = timeout;
        this.database = database;
        this.password = password;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getDatabase() {
        return this.database;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        return "JedisPoolConfig{host='" + this.host + "', port=" + this.port + ", timeout=" + this.timeout + ", database=" + this.database + ", password='" + this.password + "'}";
    }

    public static class Builder {
        private String host = "127.0.0.1";
        private int port = 6379;
        private int timeout = 2000;
        private int database = 0;
        private String password;

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder setDatabase(int database) {
            this.database = database;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public JedisPoolConfig build() {
            return new JedisPoolConfig(this.host, this.port, this.timeout, this.password, this.database);
        }
    }
}

