/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.authentication.core.SimpleToken;
import redis.clients.authentication.core.Token;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.authentication.JedisAuthenticationException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.util.SafeEncoder;

class JedisSafeAuthenticator {
    private static final Token PLACEHOLDER_TOKEN = new SimpleToken(null, null, 0L, 0L, null);
    private static final Logger logger = LoggerFactory.getLogger(JedisSafeAuthenticator.class);
    protected volatile Connection client;
    protected final Consumer<Object> authResultHandler = this::processAuthReply;
    protected final Consumer<Token> authenticationHandler = this::safeReAuthenticate;
    protected final AtomicReference<Token> pendingTokenRef = new AtomicReference<Object>(null);
    protected final ReentrantLock commandSync = new ReentrantLock();
    protected final Queue<Consumer<Object>> resultHandler = new ConcurrentLinkedQueue<Consumer<Object>>();

    JedisSafeAuthenticator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendAndFlushCommand(Protocol.Command command, Object ... args) {
        if (this.client == null) {
            throw new JedisException(this.getClass() + " is not connected to a Connection.");
        }
        CommandArguments cargs = new CommandArguments(command).addObjects(args);
        Token newToken = this.pendingTokenRef.getAndSet(PLACEHOLDER_TOKEN);
        if (newToken != null) {
            this.commandSync.lock();
        }
        try {
            this.client.sendCommand(cargs);
            this.client.flush();
        }
        finally {
            Token newerToken = this.pendingTokenRef.getAndSet(null);
            if (newerToken != null && newerToken != PLACEHOLDER_TOKEN) {
                this.safeReAuthenticate(newerToken);
            }
            if (newToken != null) {
                this.commandSync.unlock();
            }
        }
    }

    protected void registerForAuthentication(Connection newClient) {
        Connection oldClient = this.client;
        if (oldClient == newClient) {
            return;
        }
        if (oldClient != null && oldClient.getAuthXManager() != null) {
            oldClient.getAuthXManager().removePostAuthenticationHook(this.authenticationHandler);
        }
        if (newClient != null && newClient.getAuthXManager() != null) {
            newClient.getAuthXManager().addPostAuthenticationHook(this.authenticationHandler);
        }
        this.client = newClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeReAuthenticate(Token token) {
        block5: {
            try {
                byte[] rawPass = this.client.encodeToBytes(token.getValue().toCharArray());
                byte[] rawUser = this.client.encodeToBytes(token.getUser().toCharArray());
                Token newToken = this.pendingTokenRef.getAndSet(token);
                if (newToken != null) break block5;
                this.commandSync.lock();
                try {
                    this.sendAndFlushCommand(Protocol.Command.AUTH, rawUser, rawPass);
                    this.resultHandler.add(this.authResultHandler);
                }
                finally {
                    this.pendingTokenRef.set(null);
                    this.commandSync.unlock();
                }
            }
            catch (Exception e) {
                logger.error("Error while re-authenticating connection", e);
                this.client.getAuthXManager().getListener().onConnectionAuthenticationError(e);
            }
        }
    }

    protected void processAuthReply(Object reply) {
        byte[] resp = (byte[])reply;
        String response = SafeEncoder.encode(resp);
        if (!"OK".equals(response)) {
            String msg = "Re-authentication failed with server response: " + response;
            JedisAuthenticationException failedAuth = new JedisAuthenticationException(msg);
            logger.error(failedAuth.getMessage(), failedAuth);
            this.client.getAuthXManager().getListener().onConnectionAuthenticationError(failedAuth);
        }
    }
}

