/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.trident.state;

import java.util.List;
import org.apache.storm.redis.common.mapper.RedisDataTypeDescription;
import org.apache.storm.redis.common.mapper.RedisLookupMapper;
import org.apache.storm.redis.trident.state.AbstractRedisStateQuerier;
import org.apache.storm.redis.trident.state.RedisState;
import redis.clients.jedis.Jedis;

public class RedisStateQuerier
extends AbstractRedisStateQuerier<RedisState> {
    public RedisStateQuerier(RedisLookupMapper lookupMapper) {
        super(lookupMapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<String> retrieveValuesFromRedis(RedisState state, List<String> keys) {
        Jedis jedis = null;
        try {
            jedis = state.getJedis();
            String[] keysForRedis = keys.toArray(new String[keys.size()]);
            List<String> list = switch (this.dataType) {
                case RedisDataTypeDescription.RedisDataType.STRING -> jedis.mget(keysForRedis);
                case RedisDataTypeDescription.RedisDataType.HASH -> jedis.hmget(this.additionalKey, keysForRedis);
                default -> throw new IllegalArgumentException("Cannot process such data type: " + String.valueOf((Object)this.dataType));
            };
            return list;
        }
        finally {
            if (jedis != null) {
                state.returnJedis(jedis);
            }
        }
    }
}

