/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.trident.state;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.storm.redis.common.mapper.RedisDataTypeDescription;
import org.apache.storm.redis.common.mapper.RedisLookupMapper;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.state.BaseQueryFunction;
import org.apache.storm.trident.state.State;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Values;

public abstract class AbstractRedisStateQuerier<T extends State>
extends BaseQueryFunction<T, List<Values>> {
    protected final RedisDataTypeDescription.RedisDataType dataType;
    protected final String additionalKey;
    private final RedisLookupMapper lookupMapper;

    public AbstractRedisStateQuerier(RedisLookupMapper lookupMapper) {
        this.lookupMapper = lookupMapper;
        RedisDataTypeDescription dataTypeDescription = lookupMapper.getDataTypeDescription();
        this.dataType = dataTypeDescription.getDataType();
        this.additionalKey = dataTypeDescription.getAdditionalKey();
    }

    public List<List<Values>> batchRetrieve(T state, List<TridentTuple> inputs) {
        ArrayList<List<Values>> values = Lists.newArrayList();
        ArrayList<String> keys = Lists.newArrayList();
        for (TridentTuple input : inputs) {
            keys.add(this.lookupMapper.getKeyFromTuple((ITuple)input));
        }
        List<String> redisVals = this.retrieveValuesFromRedis(state, keys);
        for (int i = 0; i < redisVals.size(); ++i) {
            values.add(this.lookupMapper.toTuple((ITuple)inputs.get(i), redisVals.get(i)));
        }
        return values;
    }

    public void execute(TridentTuple tuple, List<Values> values, TridentCollector collector) {
        for (Values value : values) {
            collector.emit((List)value);
        }
    }

    protected abstract List<String> retrieveValuesFromRedis(T var1, List<String> var2);
}

