/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.trident;

import java.util.List;
import java.util.Map;
import org.apache.storm.Config;
import org.apache.storm.StormSubmitter;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.redis.common.config.JedisPoolConfig;
import org.apache.storm.redis.common.mapper.RedisDataTypeDescription;
import org.apache.storm.redis.trident.PrintFunction;
import org.apache.storm.redis.trident.state.RedisMapState;
import org.apache.storm.trident.Stream;
import org.apache.storm.trident.TridentState;
import org.apache.storm.trident.TridentTopology;
import org.apache.storm.trident.operation.CombinerAggregator;
import org.apache.storm.trident.operation.Function;
import org.apache.storm.trident.operation.builtin.MapGet;
import org.apache.storm.trident.operation.builtin.Sum;
import org.apache.storm.trident.spout.IBatchSpout;
import org.apache.storm.trident.state.QueryFunction;
import org.apache.storm.trident.state.StateFactory;
import org.apache.storm.trident.testing.FixedBatchSpout;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;

public class WordCountTridentRedisMap {
    public static StormTopology buildTopology(String redisHost, Integer redisPort) {
        Fields fields = new Fields(new String[]{"word", "count"});
        FixedBatchSpout spout = new FixedBatchSpout(fields, 4, new List[]{new Values(new Object[]{"storm", 1}), new Values(new Object[]{"trident", 1}), new Values(new Object[]{"needs", 1}), new Values(new Object[]{"javadoc", 1})});
        spout.setCycle(true);
        JedisPoolConfig poolConfig = new JedisPoolConfig.Builder().setHost(redisHost).setPort(redisPort).build();
        RedisDataTypeDescription dataTypeDescription = new RedisDataTypeDescription(RedisDataTypeDescription.RedisDataType.HASH, "test");
        StateFactory factory = RedisMapState.transactional(poolConfig, dataTypeDescription);
        TridentTopology topology = new TridentTopology();
        Stream stream = topology.newStream("spout1", (IBatchSpout)spout);
        TridentState state = stream.groupBy(new Fields(new String[]{"word"})).persistentAggregate(factory, new Fields(new String[]{"count"}), (CombinerAggregator)new Sum(), new Fields(new String[]{"sum"}));
        stream.stateQuery(state, new Fields(new String[]{"word"}), (QueryFunction)new MapGet(), new Fields(new String[]{"sum"})).each(new Fields(new String[]{"word", "sum"}), (Function)new PrintFunction(), new Fields(new String[0]));
        return topology.build();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("Usage: WordCountTrident redis-host redis-port");
            System.exit(1);
        }
        String redisHost = args[0];
        Integer redisPort = Integer.valueOf(args[1]);
        Config conf = new Config();
        conf.setMaxSpoutPending(5);
        conf.setNumWorkers(3);
        StormSubmitter.submitTopology((String)"test_wordCounter_for_redis", (Map)conf, (StormTopology)WordCountTridentRedisMap.buildTopology(redisHost, redisPort));
    }
}

