/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.trident;

import java.util.ArrayList;
import java.util.List;
import org.apache.storm.redis.common.mapper.RedisDataTypeDescription;
import org.apache.storm.redis.common.mapper.RedisLookupMapper;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Values;

public class WordCountLookupMapper
implements RedisLookupMapper {
    @Override
    public List<Values> toTuple(ITuple input, Object value) {
        ArrayList<Values> values = new ArrayList<Values>();
        values.add(new Values(new Object[]{this.getKeyFromTuple(input), value}));
        return values;
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(new Fields(new String[]{"word", "value"}));
    }

    @Override
    public RedisDataTypeDescription getDataTypeDescription() {
        return new RedisDataTypeDescription(RedisDataTypeDescription.RedisDataType.HASH, "test");
    }

    @Override
    public String getKeyFromTuple(ITuple tuple) {
        return "test_" + tuple.getString(0);
    }

    @Override
    public String getValueFromTuple(ITuple tuple) {
        return tuple.getInteger(1).toString();
    }
}

