/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.topology;

import java.util.Map;
import java.util.Random;
import org.apache.storm.Config;
import org.apache.storm.StormSubmitter;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.redis.bolt.RedisFilterBolt;
import org.apache.storm.redis.common.config.JedisPoolConfig;
import org.apache.storm.redis.common.mapper.RedisDataTypeDescription;
import org.apache.storm.redis.common.mapper.RedisFilterMapper;
import org.apache.storm.redis.topology.WordCounter;
import org.apache.storm.redis.topology.WordSpout;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.IBasicBolt;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.TopologyBuilder;
import org.apache.storm.topology.base.BaseRichBolt;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhitelistWordCount {
    private static final String WORD_SPOUT = "WORD_SPOUT";
    private static final String WHITELIST_BOLT = "WHITELIST_BOLT";
    private static final String COUNT_BOLT = "COUNT_BOLT";
    private static final String PRINT_BOLT = "PRINT_BOLT";
    private static final String TEST_REDIS_HOST = "127.0.0.1";
    private static final int TEST_REDIS_PORT = 6379;

    public static void main(String[] args) throws Exception {
        String host = TEST_REDIS_HOST;
        int port = 6379;
        if (args.length >= 2) {
            host = args[0];
            port = Integer.parseInt(args[1]);
        }
        JedisPoolConfig poolConfig = new JedisPoolConfig.Builder().setHost(host).setPort(port).build();
        WordSpout spout = new WordSpout();
        RedisFilterMapper filterMapper = WhitelistWordCount.setupWhitelistMapper();
        RedisFilterBolt whitelistBolt = new RedisFilterBolt(poolConfig, filterMapper);
        WordCounter wordCounterBolt = new WordCounter();
        TopologyBuilder builder = new TopologyBuilder();
        builder.setSpout(WORD_SPOUT, (IRichSpout)spout, (Number)1);
        builder.setBolt(WHITELIST_BOLT, (IRichBolt)whitelistBolt, (Number)1).shuffleGrouping(WORD_SPOUT);
        builder.setBolt(COUNT_BOLT, (IBasicBolt)wordCounterBolt, (Number)1).fieldsGrouping(WHITELIST_BOLT, new Fields(new String[]{"word"}));
        PrintWordTotalCountBolt printBolt = new PrintWordTotalCountBolt();
        builder.setBolt(PRINT_BOLT, (IRichBolt)printBolt, (Number)1).shuffleGrouping(COUNT_BOLT);
        String topoName = "test";
        if (args.length == 3) {
            topoName = args[2];
        } else if (args.length > 3) {
            System.out.println("Usage: WhitelistWordCount <redis host> <redis port> [topology name]");
            return;
        }
        Config config = new Config();
        StormSubmitter.submitTopology((String)topoName, (Map)config, (StormTopology)builder.createTopology());
    }

    private static RedisFilterMapper setupWhitelistMapper() {
        return new WhitelistWordFilterMapper();
    }

    public static class PrintWordTotalCountBolt
    extends BaseRichBolt {
        private static final Logger LOG = LoggerFactory.getLogger(PrintWordTotalCountBolt.class);
        private static final Random RANDOM = new Random();
        private OutputCollector collector;

        public void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector) {
            this.collector = collector;
        }

        public void execute(Tuple input) {
            String wordName = input.getStringByField("word");
            String countStr = input.getStringByField("count");
            if (RANDOM.nextInt(1000) > 995) {
                int count = 0;
                if (countStr != null) {
                    count = Integer.parseInt(countStr);
                }
                LOG.info("Count result - word : " + wordName + " / count : " + count);
            }
            this.collector.ack(input);
        }

        public void declareOutputFields(OutputFieldsDeclarer declarer) {
        }
    }

    private static class WhitelistWordFilterMapper
    implements RedisFilterMapper {
        private RedisDataTypeDescription description = new RedisDataTypeDescription(RedisDataTypeDescription.RedisDataType.SET, "whitelist");
        private final String setKey = "whitelist";

        WhitelistWordFilterMapper() {
        }

        @Override
        public void declareOutputFields(OutputFieldsDeclarer declarer) {
            declarer.declare(new Fields(new String[]{"word"}));
        }

        @Override
        public RedisDataTypeDescription getDataTypeDescription() {
            return this.description;
        }

        @Override
        public String getKeyFromTuple(ITuple tuple) {
            return tuple.getStringByField("word");
        }

        @Override
        public String getValueFromTuple(ITuple tuple) {
            return null;
        }
    }
}

