/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.bolt;

import org.apache.storm.redis.bolt.AbstractRedisBolt;
import org.apache.storm.redis.common.config.JedisClusterConfig;
import org.apache.storm.redis.common.config.JedisPoolConfig;
import org.apache.storm.redis.common.container.JedisCommandsContainer;
import org.apache.storm.redis.common.mapper.RedisDataTypeDescription;
import org.apache.storm.redis.common.mapper.RedisStoreMapper;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Tuple;

public class RedisStoreBolt
extends AbstractRedisBolt {
    private final RedisStoreMapper storeMapper;
    private final RedisDataTypeDescription.RedisDataType dataType;
    private final String additionalKey;

    public RedisStoreBolt(JedisPoolConfig config, RedisStoreMapper storeMapper) {
        super(config);
        this.storeMapper = storeMapper;
        RedisDataTypeDescription dataTypeDescription = storeMapper.getDataTypeDescription();
        this.dataType = dataTypeDescription.getDataType();
        this.additionalKey = dataTypeDescription.getAdditionalKey();
    }

    public RedisStoreBolt(JedisClusterConfig config, RedisStoreMapper storeMapper) {
        super(config);
        this.storeMapper = storeMapper;
        RedisDataTypeDescription dataTypeDescription = storeMapper.getDataTypeDescription();
        this.dataType = dataTypeDescription.getDataType();
        this.additionalKey = dataTypeDescription.getAdditionalKey();
    }

    public void process(Tuple input) {
        String key = this.storeMapper.getKeyFromTuple((ITuple)input);
        String value = this.storeMapper.getValueFromTuple((ITuple)input);
        JedisCommandsContainer jedisCommand = null;
        try {
            jedisCommand = this.getInstance();
            switch (this.dataType) {
                case STRING: {
                    jedisCommand.set(key, value);
                    break;
                }
                case LIST: {
                    jedisCommand.rpush(key, value);
                    break;
                }
                case HASH: {
                    jedisCommand.hset(this.additionalKey, key, value);
                    break;
                }
                case SET: {
                    jedisCommand.sadd(key, value);
                    break;
                }
                case SORTED_SET: {
                    jedisCommand.zadd(this.additionalKey, Double.valueOf(value), key);
                    break;
                }
                case HYPER_LOG_LOG: {
                    jedisCommand.pfadd(key, value);
                    break;
                }
                case GEO: {
                    String[] array = value.split(":");
                    if (array.length != 2) {
                        throw new IllegalArgumentException("value structure should be longitude:latitude");
                    }
                    double longitude = Double.valueOf(array[0]);
                    double latitude = Double.valueOf(array[1]);
                    jedisCommand.geoadd(this.additionalKey, longitude, latitude, key);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot process such data type: " + String.valueOf((Object)this.dataType));
                }
            }
            this.collector.ack(input);
        }
        catch (Exception e) {
            this.collector.reportError((Throwable)e);
            this.collector.fail(input);
        }
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
    }
}

