/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.bolt;

import java.util.Map;
import org.apache.storm.redis.common.config.JedisClusterConfig;
import org.apache.storm.redis.common.config.JedisPoolConfig;
import org.apache.storm.redis.common.container.JedisCommandsContainer;
import org.apache.storm.redis.common.container.JedisCommandsContainerBuilder;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.base.BaseTickTupleAwareRichBolt;

public abstract class AbstractRedisBolt
extends BaseTickTupleAwareRichBolt {
    protected OutputCollector collector;
    private transient JedisCommandsContainer container;
    private JedisPoolConfig jedisPoolConfig;
    private JedisClusterConfig jedisClusterConfig;

    public AbstractRedisBolt(JedisPoolConfig config) {
        this.jedisPoolConfig = config;
    }

    public AbstractRedisBolt(JedisClusterConfig config) {
        this.jedisClusterConfig = config;
    }

    public void prepare(Map<String, Object> map, TopologyContext topologyContext, OutputCollector collector) {
        this.collector = collector;
        if (this.jedisPoolConfig != null) {
            this.container = JedisCommandsContainerBuilder.build(this.jedisPoolConfig);
        } else if (this.jedisClusterConfig != null) {
            this.container = JedisCommandsContainerBuilder.build(this.jedisClusterConfig);
        } else {
            throw new IllegalArgumentException("Jedis configuration not found");
        }
    }

    protected JedisCommandsContainer getInstance() {
        return this.container;
    }

    public void cleanup() {
        this.container.close();
    }
}

