/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.trident;

import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.storm.Config;
import org.apache.storm.StormSubmitter;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.redis.common.config.JedisClusterConfig;
import org.apache.storm.redis.trident.PrintFunction;
import org.apache.storm.redis.trident.WordCountLookupMapper;
import org.apache.storm.redis.trident.WordCountStoreMapper;
import org.apache.storm.redis.trident.state.RedisClusterState;
import org.apache.storm.redis.trident.state.RedisClusterStateQuerier;
import org.apache.storm.redis.trident.state.RedisClusterStateUpdater;
import org.apache.storm.trident.Stream;
import org.apache.storm.trident.TridentState;
import org.apache.storm.trident.TridentTopology;
import org.apache.storm.trident.operation.Function;
import org.apache.storm.trident.spout.IBatchSpout;
import org.apache.storm.trident.state.QueryFunction;
import org.apache.storm.trident.state.StateFactory;
import org.apache.storm.trident.state.StateUpdater;
import org.apache.storm.trident.testing.FixedBatchSpout;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;

public class WordCountTridentRedisCluster {
    public static StormTopology buildTopology(String redisHostPort) {
        Fields fields = new Fields(new String[]{"word", "count"});
        FixedBatchSpout spout = new FixedBatchSpout(fields, 4, new List[]{new Values(new Object[]{"storm", 1}), new Values(new Object[]{"trident", 1}), new Values(new Object[]{"needs", 1}), new Values(new Object[]{"javadoc", 1})});
        spout.setCycle(true);
        HashSet<InetSocketAddress> nodes = new HashSet<InetSocketAddress>();
        for (String hostPort : redisHostPort.split(",")) {
            String[] hostPortSplit = hostPort.split(":");
            nodes.add(new InetSocketAddress(hostPortSplit[0], (int)Integer.valueOf(hostPortSplit[1])));
        }
        JedisClusterConfig clusterConfig = new JedisClusterConfig.Builder().setNodes(nodes).build();
        WordCountStoreMapper storeMapper = new WordCountStoreMapper();
        WordCountLookupMapper lookupMapper = new WordCountLookupMapper();
        RedisClusterState.Factory factory = new RedisClusterState.Factory(clusterConfig);
        TridentTopology topology = new TridentTopology();
        Stream stream = topology.newStream("spout1", (IBatchSpout)spout);
        stream.partitionPersist((StateFactory)factory, fields, (StateUpdater)new RedisClusterStateUpdater(storeMapper).withExpire(86400000), new Fields(new String[0]));
        TridentState state = topology.newStaticState((StateFactory)factory);
        stream = stream.stateQuery(state, new Fields(new String[]{"word"}), (QueryFunction)new RedisClusterStateQuerier(lookupMapper), new Fields(new String[]{"columnName", "columnValue"}));
        stream.each(new Fields(new String[]{"word", "columnValue"}), (Function)new PrintFunction(), new Fields(new String[0]));
        return topology.build();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Usage: WordCountTrident 127.0.0.1:6379,127.0.0.1:6380");
            System.exit(1);
        }
        String redisHostPort = args[0];
        Config conf = new Config();
        conf.setMaxSpoutPending(5);
        conf.setNumWorkers(3);
        StormSubmitter.submitTopology((String)"test_wordCounter_for_redis", (Map)conf, (StormTopology)WordCountTridentRedisCluster.buildTopology(redisHostPort));
    }
}

