/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.trident;

import java.util.List;
import java.util.Map;
import org.apache.storm.Config;
import org.apache.storm.StormSubmitter;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.redis.common.config.JedisPoolConfig;
import org.apache.storm.redis.trident.PrintFunction;
import org.apache.storm.redis.trident.WordCountLookupMapper;
import org.apache.storm.redis.trident.WordCountStoreMapper;
import org.apache.storm.redis.trident.state.RedisState;
import org.apache.storm.redis.trident.state.RedisStateQuerier;
import org.apache.storm.redis.trident.state.RedisStateUpdater;
import org.apache.storm.trident.Stream;
import org.apache.storm.trident.TridentState;
import org.apache.storm.trident.TridentTopology;
import org.apache.storm.trident.operation.Function;
import org.apache.storm.trident.spout.IBatchSpout;
import org.apache.storm.trident.state.QueryFunction;
import org.apache.storm.trident.state.StateFactory;
import org.apache.storm.trident.state.StateUpdater;
import org.apache.storm.trident.testing.FixedBatchSpout;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;

public class WordCountTridentRedis {
    public static StormTopology buildTopology(String redisHost, Integer redisPort) {
        Fields fields = new Fields(new String[]{"word", "count"});
        FixedBatchSpout spout = new FixedBatchSpout(fields, 4, new List[]{new Values(new Object[]{"storm", 1}), new Values(new Object[]{"trident", 1}), new Values(new Object[]{"needs", 1}), new Values(new Object[]{"javadoc", 1})});
        spout.setCycle(true);
        JedisPoolConfig poolConfig = new JedisPoolConfig.Builder().setHost(redisHost).setPort(redisPort).build();
        WordCountStoreMapper storeMapper = new WordCountStoreMapper();
        WordCountLookupMapper lookupMapper = new WordCountLookupMapper();
        RedisState.Factory factory = new RedisState.Factory(poolConfig);
        TridentTopology topology = new TridentTopology();
        Stream stream = topology.newStream("spout1", (IBatchSpout)spout);
        stream.partitionPersist((StateFactory)factory, fields, (StateUpdater)new RedisStateUpdater(storeMapper).withExpire(86400000), new Fields(new String[0]));
        TridentState state = topology.newStaticState((StateFactory)factory);
        stream = stream.stateQuery(state, new Fields(new String[]{"word"}), (QueryFunction)new RedisStateQuerier(lookupMapper), new Fields(new String[]{"columnName", "columnValue"}));
        stream.each(new Fields(new String[]{"word", "columnValue"}), (Function)new PrintFunction(), new Fields(new String[0]));
        return topology.build();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("Usage: WordCountTrident redis-host redis-port");
            System.exit(1);
        }
        String redisHost = args[0];
        Integer redisPort = Integer.valueOf(args[1]);
        Config conf = new Config();
        conf.setMaxSpoutPending(5);
        conf.setNumWorkers(3);
        StormSubmitter.submitTopology((String)"test_wordCounter_for_redis", (Map)conf, (StormTopology)WordCountTridentRedis.buildTopology(redisHost, redisPort));
    }
}

