/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.topology;

import java.util.Map;
import org.apache.storm.Config;
import org.apache.storm.StormSubmitter;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.redis.bolt.RedisStoreBolt;
import org.apache.storm.redis.common.config.JedisPoolConfig;
import org.apache.storm.redis.common.mapper.RedisDataTypeDescription;
import org.apache.storm.redis.common.mapper.RedisStoreMapper;
import org.apache.storm.redis.topology.WordCounter;
import org.apache.storm.redis.topology.WordSpout;
import org.apache.storm.topology.IBasicBolt;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.TopologyBuilder;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.ITuple;

public class PersistentWordCount {
    private static final String WORD_SPOUT = "WORD_SPOUT";
    private static final String COUNT_BOLT = "COUNT_BOLT";
    private static final String STORE_BOLT = "STORE_BOLT";
    private static final String TEST_REDIS_HOST = "127.0.0.1";
    private static final int TEST_REDIS_PORT = 6379;

    public static void main(String[] args) throws Exception {
        String host = TEST_REDIS_HOST;
        int port = 6379;
        if (args.length >= 2) {
            host = args[0];
            port = Integer.parseInt(args[1]);
        }
        JedisPoolConfig poolConfig = new JedisPoolConfig.Builder().setHost(host).setPort(port).build();
        WordSpout spout = new WordSpout();
        WordCounter bolt = new WordCounter();
        RedisStoreMapper storeMapper = PersistentWordCount.setupStoreMapper();
        RedisStoreBolt storeBolt = new RedisStoreBolt(poolConfig, storeMapper);
        TopologyBuilder builder = new TopologyBuilder();
        builder.setSpout(WORD_SPOUT, (IRichSpout)spout, (Number)1);
        builder.setBolt(COUNT_BOLT, (IBasicBolt)bolt, (Number)1).fieldsGrouping(WORD_SPOUT, new Fields(new String[]{"word"}));
        builder.setBolt(STORE_BOLT, (IRichBolt)storeBolt, (Number)1).shuffleGrouping(COUNT_BOLT);
        String topoName = "test";
        if (args.length == 3) {
            topoName = args[2];
        } else if (args.length > 3) {
            System.out.println("Usage: PersistentWordCount <redis host> <redis port> (topology name)");
            return;
        }
        Config config = new Config();
        StormSubmitter.submitTopology((String)topoName, (Map)config, (StormTopology)builder.createTopology());
    }

    private static RedisStoreMapper setupStoreMapper() {
        return new WordCountStoreMapper();
    }

    private static class WordCountStoreMapper
    implements RedisStoreMapper {
        private RedisDataTypeDescription description = new RedisDataTypeDescription(RedisDataTypeDescription.RedisDataType.HASH, "wordCount");
        private final String hashKey = "wordCount";

        WordCountStoreMapper() {
        }

        @Override
        public RedisDataTypeDescription getDataTypeDescription() {
            return this.description;
        }

        @Override
        public String getKeyFromTuple(ITuple tuple) {
            return tuple.getStringByField("word");
        }

        @Override
        public String getValueFromTuple(ITuple tuple) {
            return tuple.getStringByField("count");
        }
    }
}

