/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.state;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.Map;
import org.apache.storm.redis.common.config.JedisClusterConfig;
import org.apache.storm.redis.common.config.JedisPoolConfig;
import org.apache.storm.redis.state.RedisKeyValueState;
import org.apache.storm.state.DefaultStateSerializer;
import org.apache.storm.state.Serializer;
import org.apache.storm.state.State;
import org.apache.storm.state.StateProvider;
import org.apache.storm.task.TopologyContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisKeyValueStateProvider
implements StateProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RedisKeyValueStateProvider.class);

    public State newState(String namespace, Map<String, Object> topoConf, TopologyContext context) {
        try {
            return this.getRedisKeyValueState(namespace, topoConf, context, this.getStateConfig(topoConf));
        }
        catch (Exception ex) {
            LOG.error("Error loading config from storm conf {}", (Object)topoConf);
            throw new RuntimeException(ex);
        }
    }

    StateConfig getStateConfig(Map<String, Object> topoConf) throws Exception {
        StateConfig stateConfig;
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        if (topoConf.containsKey("topology.state.provider.config")) {
            String providerConfig = (String)topoConf.get("topology.state.provider.config");
            stateConfig = mapper.readValue(providerConfig, StateConfig.class);
        } else {
            stateConfig = new StateConfig();
        }
        return stateConfig;
    }

    private RedisKeyValueState getRedisKeyValueState(String namespace, Map<String, Object> topoConf, TopologyContext context, StateConfig config) throws Exception {
        JedisPoolConfig jedisPoolConfig = this.getJedisPoolConfig(config);
        JedisClusterConfig jedisClusterConfig = this.getJedisClusterConfig(config);
        if (jedisPoolConfig == null && jedisClusterConfig == null) {
            jedisPoolConfig = this.buildDefaultJedisPoolConfig();
        }
        if (jedisPoolConfig != null) {
            return new RedisKeyValueState(namespace, jedisPoolConfig, this.getKeySerializer(topoConf, context, config), this.getValueSerializer(topoConf, context, config));
        }
        return new RedisKeyValueState(namespace, jedisClusterConfig, this.getKeySerializer(topoConf, context, config), this.getValueSerializer(topoConf, context, config));
    }

    private Serializer getKeySerializer(Map<String, Object> topoConf, TopologyContext context, StateConfig config) throws Exception {
        Serializer serializer;
        if (config.keySerializerClass != null) {
            Class<?> klass = Class.forName(config.keySerializerClass);
            serializer = (Serializer)klass.newInstance();
        } else {
            serializer = config.keyClass != null ? new DefaultStateSerializer(topoConf, context, Collections.singletonList(Class.forName(config.keyClass))) : new DefaultStateSerializer(topoConf, context);
        }
        return serializer;
    }

    private Serializer getValueSerializer(Map<String, Object> topoConf, TopologyContext context, StateConfig config) throws Exception {
        Serializer serializer;
        if (config.valueSerializerClass != null) {
            Class<?> klass = Class.forName(config.valueSerializerClass);
            serializer = (Serializer)klass.newInstance();
        } else {
            serializer = config.valueClass != null ? new DefaultStateSerializer(topoConf, context, Collections.singletonList(Class.forName(config.valueClass))) : new DefaultStateSerializer(topoConf, context);
        }
        return serializer;
    }

    private JedisPoolConfig getJedisPoolConfig(StateConfig config) {
        return config.jedisPoolConfig;
    }

    private JedisClusterConfig getJedisClusterConfig(StateConfig config) {
        return config.jedisClusterConfig;
    }

    private JedisPoolConfig buildDefaultJedisPoolConfig() {
        return new JedisPoolConfig.Builder().build();
    }

    public static class StateConfig {
        public String keyClass;
        public String valueClass;
        public String keySerializerClass;
        public String valueSerializerClass;
        public JedisPoolConfig jedisPoolConfig;
        public JedisClusterConfig jedisClusterConfig;

        public String toString() {
            return "StateConfig{keyClass='" + this.keyClass + "', valueClass='" + this.valueClass + "', keySerializerClass='" + this.keySerializerClass + "', valueSerializerClass='" + this.valueSerializerClass + "', jedisPoolConfig=" + String.valueOf(this.jedisPoolConfig) + ", jedisClusterConfig=" + String.valueOf(this.jedisClusterConfig) + "}";
        }
    }
}

