/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metrics.hdrhistogram;

import org.HdrHistogram.Histogram;
import org.apache.storm.metric.api.IMetric;

public class HistogramMetric
implements IMetric {
    private final Histogram histo;

    public HistogramMetric(int numberOfSignificantValueDigits) {
        this(null, numberOfSignificantValueDigits);
    }

    public HistogramMetric(Long highestTrackableValue, int numberOfSignificantValueDigits) {
        this(null, highestTrackableValue, numberOfSignificantValueDigits);
    }

    public HistogramMetric(Long lowestDiscernibleValue, Long highestTrackableValue, int numberOfSignificantValueDigits) {
        boolean autoResize = false;
        if (lowestDiscernibleValue == null) {
            lowestDiscernibleValue = 1L;
        }
        if (highestTrackableValue == null) {
            highestTrackableValue = 2L * lowestDiscernibleValue;
            autoResize = true;
        }
        this.histo = new Histogram(lowestDiscernibleValue.longValue(), highestTrackableValue.longValue(), numberOfSignificantValueDigits);
        if (autoResize) {
            this.histo.setAutoResize(true);
        }
    }

    public void recordValue(long val) {
        this.histo.recordValue(val);
    }

    public Object getValueAndReset() {
        Histogram copy = this.histo.copy();
        this.histo.reset();
        return copy;
    }
}

