/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metrics.sigar;

import java.util.HashMap;
import org.apache.storm.metric.api.IMetric;
import org.hyperic.sigar.ProcCpu;
import org.hyperic.sigar.Sigar;

public class CPUMetric
implements IMetric {
    private long prevUser = 0L;
    private long prevSys = 0L;
    private final Sigar sigar = new Sigar();
    private final long pid = this.sigar.getPid();

    public Object getValueAndReset() {
        try {
            ProcCpu cpu = this.sigar.getProcCpu(this.pid);
            long userTotal = cpu.getUser();
            long sysTotal = cpu.getSys();
            long user = userTotal - this.prevUser;
            long sys = sysTotal - this.prevSys;
            this.prevUser = userTotal;
            this.prevSys = sysTotal;
            HashMap<String, Long> ret = new HashMap<String, Long>();
            ret.put("user-ms", user);
            ret.put("sys-ms", sys);
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

