/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritePendingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.MultiPartFormData;
import org.eclipse.jetty.http.Trailers;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.Components;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.server.TunnelSupport;
import org.eclipse.jetty.server.internal.ResponseHttpFields;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.VirtualThreads;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.SerializedInvoker;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpChannelState
implements HttpChannel,
Components {
    private static final Logger LOG = LoggerFactory.getLogger(HttpChannelState.class);
    private static final Throwable NOTHING_TO_SEND = new Throwable("nothing_to_send");
    private static final HttpField SERVER_VERSION = new ResponseHttpFields.PersistentPreEncodedHttpField(HttpHeader.SERVER, HttpConfiguration.SERVER_VERSION);
    private static final HttpField POWERED_BY = new ResponseHttpFields.PersistentPreEncodedHttpField(HttpHeader.X_POWERED_BY, HttpConfiguration.SERVER_VERSION);
    private final AutoLock _lock = new AutoLock();
    private final HandlerInvoker _handlerInvoker = new HandlerInvoker();
    private final ConnectionMetaData _connectionMetaData;
    private final SerializedInvoker _readInvoker;
    private final SerializedInvoker _writeInvoker;
    private final ResponseHttpFields _responseHeaders = new ResponseHttpFields();
    private Thread _handling;
    private boolean _handled;
    private StreamSendState _streamSendState = StreamSendState.SENDING;
    private boolean _callbackCompleted = false;
    private ChannelRequest _request;
    private ChannelResponse _response;
    private long _oldIdleTimeout;
    private HttpStream _stream;
    private long _committedContentLength = -1L;
    private Runnable _onContentAvailable;
    private Predicate<TimeoutException> _onIdleTimeout;
    private Content.Chunk _readFailure;
    private Consumer<Throwable> _onFailure;
    private Throwable _callbackFailure;
    private Attributes _cache;
    private boolean _expects100Continue;
    private ComplianceViolation.Listener _complianceViolationListener;

    public HttpChannelState(ConnectionMetaData connectionMetaData) {
        this._connectionMetaData = connectionMetaData;
        this._readInvoker = new HttpChannelSerializedInvoker(HttpChannelState.class.getSimpleName() + "_readInvoker", connectionMetaData.getConnector().getExecutor());
        this._writeInvoker = new HttpChannelSerializedInvoker(HttpChannelState.class.getSimpleName() + "_writeInvoker", connectionMetaData.getConnector().getExecutor());
    }

    @Override
    public void initialize() {
        List<ComplianceViolation.Listener> listeners = this._connectionMetaData.getHttpConfiguration().getComplianceViolationListeners();
        this._complianceViolationListener = switch (listeners.size()) {
            case 0 -> ComplianceViolation.Listener.NOOP;
            case 1 -> listeners.get(0).initialize();
            default -> new InitializedCompositeComplianceViolationListener(listeners);
        };
    }

    @Override
    public ComplianceViolation.Listener getComplianceViolationListener() {
        return this._complianceViolationListener;
    }

    @Override
    public void recycle() {
        try (AutoLock ignored = this._lock.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("recycling {}", (Object)this);
            }
            this._request._httpChannelState = null;
            this._responseHeaders.recycle();
            this._handling = null;
            this._handled = false;
            this._streamSendState = StreamSendState.SENDING;
            this._callbackCompleted = false;
            this._request = null;
            this._response = null;
            this._oldIdleTimeout = 0L;
            this._stream = null;
            this._committedContentLength = -1L;
            this._onContentAvailable = null;
            this._onIdleTimeout = null;
            this._readFailure = null;
            this._onFailure = null;
            this._callbackFailure = null;
            this._expects100Continue = false;
            this._complianceViolationListener = null;
        }
    }

    public HttpConfiguration getHttpConfiguration() {
        return this._connectionMetaData.getHttpConfiguration();
    }

    public HttpStream getHttpStream() {
        try (AutoLock ignored = this._lock.lock();){
            HttpStream httpStream = this._stream;
            return httpStream;
        }
    }

    @Override
    public void setHttpStream(HttpStream stream) {
        try (AutoLock ignored = this._lock.lock();){
            this._stream = stream;
        }
    }

    public Server getServer() {
        return this._connectionMetaData.getConnector().getServer();
    }

    @Override
    public ConnectionMetaData getConnectionMetaData() {
        return this._connectionMetaData;
    }

    @Override
    public ByteBufferPool getByteBufferPool() {
        return this.getConnectionMetaData().getConnector().getByteBufferPool();
    }

    @Override
    public Scheduler getScheduler() {
        return this.getServer().getScheduler();
    }

    @Override
    public ThreadPool getThreadPool() {
        Executor executor = this.getExecutor();
        if (executor instanceof ThreadPool) {
            ThreadPool threadPool = (ThreadPool)executor;
            return threadPool;
        }
        return new ThreadPoolWrapper(executor);
    }

    @Override
    public Executor getExecutor() {
        ThreadPool executor = this.getServer().getThreadPool();
        Executor virtualExecutor = VirtualThreads.getVirtualThreadsExecutor(executor);
        return virtualExecutor != null ? virtualExecutor : executor;
    }

    @Override
    public Attributes getCache() {
        if (this._cache == null) {
            this._cache = this.getConnectionMetaData().isPersistent() ? new Attributes.Mapped() : Attributes.NULL;
        }
        return this._cache;
    }

    @Override
    public Runnable onRequest(MetaData.Request request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onRequest {} {}", (Object)request, (Object)this);
        }
        try (AutoLock ignored = this._lock.lock();){
            if (this._stream == null) {
                throw new IllegalStateException("No HttpStream");
            }
            if (this._request != null) {
                throw new IllegalStateException("duplicate request");
            }
            this._request = new ChannelRequest(this, request);
            this._response = new ChannelResponse(this._request);
            this._expects100Continue = request.is100ContinueExpected();
            HttpConfiguration httpConfiguration = this.getHttpConfiguration();
            HttpFields.Mutable responseHeaders = this._response.getHeaders();
            if (httpConfiguration.getSendServerVersion()) {
                responseHeaders.add(SERVER_VERSION);
            }
            if (httpConfiguration.getSendXPoweredBy()) {
                responseHeaders.add(POWERED_BY);
            }
            if (httpConfiguration.getSendDateHeader()) {
                responseHeaders.add(this.getConnectionMetaData().getConnector().getServer().getDateField());
            }
            long idleTO = httpConfiguration.getIdleTimeout();
            this._oldIdleTimeout = this._stream.getIdleTimeout();
            if (idleTO >= 0L && this._oldIdleTimeout != idleTO) {
                this._stream.setIdleTimeout(idleTO);
            }
            HandlerInvoker handlerInvoker = this._handlerInvoker;
            return handlerInvoker;
        }
    }

    @Override
    public Request getRequest() {
        try (AutoLock ignored = this._lock.lock();){
            ChannelRequest channelRequest = this._request;
            return channelRequest;
        }
    }

    public Response getResponse() {
        try (AutoLock ignored = this._lock.lock();){
            ChannelResponse channelResponse = this._response;
            return channelResponse;
        }
    }

    @Override
    public Runnable onContentAvailable() {
        Runnable onContent;
        try (AutoLock ignored = this._lock.lock();){
            if (this._request == null) {
                Runnable runnable = null;
                return runnable;
            }
            onContent = this._onContentAvailable;
            this._onContentAvailable = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("onContentAvailable {} {}", (Object)onContent, (Object)this);
        }
        return this._readInvoker.offer(onContent);
    }

    @Override
    public Invocable.InvocationType getInvocationType() {
        try (AutoLock ignored = this._lock.lock();){
            if (this._request == null) {
                Invocable.InvocationType invocationType = HttpChannel.super.getInvocationType();
                return invocationType;
            }
            Invocable.InvocationType invocationType = Invocable.getInvocationType(this._onContentAvailable);
            return invocationType;
        }
    }

    @Override
    public HttpChannel.IdleTimeoutTask onIdleTimeout(TimeoutException t) {
        boolean requestHandled;
        try (AutoLock ignored = this._lock.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("onIdleTimeout {}", (Object)this, (Object)t);
            }
            if (this._stream == null || this._request == null) {
                HttpChannel.IdleTimeoutTask idleTimeoutTask = new HttpChannel.IdleTimeoutTask(null, false);
                return idleTimeoutTask;
            }
            requestHandled = this._handling != null || this._handled;
            Runnable invokeOnContentAvailable = null;
            if (this._readFailure == null) {
                invokeOnContentAvailable = this._onContentAvailable;
                this._onContentAvailable = null;
                if (invokeOnContentAvailable != null) {
                    this._readFailure = Content.Chunk.from(t, false);
                }
            }
            Runnable invokeWriteFailure = this._response.lockedFailWrite(t);
            if (invokeOnContentAvailable != null || invokeWriteFailure != null) {
                HttpChannel.IdleTimeoutTask idleTimeoutTask = new HttpChannel.IdleTimeoutTask(Invocable.combine(this._readInvoker.offer(invokeOnContentAvailable), this._writeInvoker.offer(invokeWriteFailure)), requestHandled);
                return idleTimeoutTask;
            }
            Predicate<TimeoutException> onIdleTimeout = this._onIdleTimeout;
            if (onIdleTimeout != null) {
                HttpChannel.IdleTimeoutTask idleTimeoutTask = new HttpChannel.IdleTimeoutTask(() -> {
                    Runnable task;
                    boolean failure;
                    try {
                        failure = onIdleTimeout.test(t);
                    }
                    catch (Throwable x) {
                        ExceptionUtil.addSuppressedIfNotAssociated(t, x);
                        failure = true;
                    }
                    if (failure && (task = this.onFailure(t)) != null) {
                        task.run();
                    }
                }, requestHandled);
                return idleTimeoutTask;
            }
        }
        return new HttpChannel.IdleTimeoutTask(this.onFailure(t), requestHandled);
    }

    @Override
    public Runnable onFailure(Throwable x) {
        return this.onFailure(x, false);
    }

    @Override
    public Runnable onRemoteFailure(Throwable x) {
        return this.onFailure(x, true);
    }

    private Runnable onFailure(Throwable x, boolean remote) {
        Runnable task;
        HttpStream stream;
        try (AutoLock ignored = this._lock.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("onFailure {}", (Object)this, (Object)x);
            }
            if ((stream = this._stream) == null) {
                Runnable runnable = null;
                return runnable;
            }
            if (this._request == null) {
                MetaData.Request errorRequest = new MetaData.Request("GET", HttpURI.from("/badRequest"), HttpVersion.HTTP_1_0, HttpFields.EMPTY);
                this._request = new ChannelRequest(this, errorRequest);
                this._response = new ChannelResponse(this._request);
            }
            if (!this._handled && this._handling == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("failing request not yet handled {} {}", (Object)this._request, (Object)this);
                }
                ChannelCallback callback = this._request._callback;
                task = () -> callback.failed(x);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("failing request {} {}", (Object)this._request, (Object)this);
                }
                if (this._readFailure == null) {
                    this._readFailure = Content.Chunk.from(x, true);
                } else {
                    ExceptionUtil.addSuppressedIfNotAssociated(this._readFailure.getFailure(), x);
                }
                Runnable invokeOnContentAvailable = this._onContentAvailable;
                this._onContentAvailable = null;
                Runnable invokeWriteFailure = this._response.lockedFailWrite(x);
                Consumer<Throwable> onFailure = this._onFailure;
                this._onFailure = null;
                boolean noFailureListener = onFailure == null;
                boolean skipListeners = remote && !this.getHttpConfiguration().isNotifyRemoteAsyncErrors();
                boolean readerOrWriterWaiting = invokeOnContentAvailable != null || invokeWriteFailure != null;
                Runnable invokeOnFailureListeners = noFailureListener || readerOrWriterWaiting || skipListeners ? null : () -> {
                    try {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("invoking failure listeners {} {}", this, onFailure, x);
                        }
                        onFailure.accept(x);
                    }
                    catch (Throwable throwable) {
                        ExceptionUtil.addSuppressedIfNotAssociated(x, throwable);
                    }
                };
                task = Invocable.combine(this._readInvoker.offer(invokeOnContentAvailable), this._writeInvoker.offer(invokeWriteFailure), this._readInvoker.offer(invokeOnFailureListeners));
            }
        }
        Throwable unconsumed = stream.consumeAvailable();
        if (unconsumed != null && LOG.isDebugEnabled()) {
            LOG.debug("consuming content during error {}", (Object)unconsumed.toString());
        }
        return task;
    }

    @Override
    public Runnable onClose() {
        try (AutoLock ignored = this._lock.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("onClose {} stream={}", (Object)this, (Object)this._stream);
            }
            if (this._stream == null) {
                Runnable runnable = null;
                return runnable;
            }
        }
        return this.onFailure(new EofException());
    }

    public void addHttpStreamWrapper(Function<HttpStream, HttpStream> onStreamEvent) {
        while (true) {
            HttpStream stream;
            try (AutoLock ignored = this._lock.lock();){
                stream = this._stream;
            }
            if (stream == null) {
                throw new IllegalStateException("No active stream");
            }
            HttpStream combined = onStreamEvent.apply(stream);
            if (combined == null) {
                throw new IllegalArgumentException("Cannot remove stream");
            }
            if (combined == stream) {
                return;
            }
            AutoLock ignored = this._lock.lock();
            try {
                if (this._stream != stream) continue;
                this._stream = combined;
            }
            finally {
                if (ignored == null) continue;
                ignored.close();
                continue;
            }
            break;
        }
    }

    private void resetResponse() {
        try (AutoLock ignored = this._lock.lock();){
            if (this._responseHeaders.isCommitted()) {
                throw new IllegalStateException("response committed");
            }
            this._responseHeaders.clear();
        }
    }

    private Throwable lockedStreamSend(boolean last, long length) {
        assert (this._lock.isHeldByCurrentThread());
        return switch (this._streamSendState.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                this._streamSendState = last ? StreamSendState.LAST_SENDING : StreamSendState.SENDING;
                yield null;
            }
            case 1, 2 -> length > 0L ? new IllegalStateException("last already written") : NOTHING_TO_SEND;
        };
    }

    private void lockedStreamSendCompleted(boolean success) {
        assert (this._lock.isHeldByCurrentThread());
        if (this._streamSendState == StreamSendState.LAST_SENDING) {
            this._streamSendState = success ? StreamSendState.LAST_COMPLETE : StreamSendState.SENDING;
        }
    }

    private boolean lockedIsLastStreamSendCompleted() {
        assert (this._lock.isHeldByCurrentThread());
        return this._streamSendState == StreamSendState.LAST_COMPLETE;
    }

    private boolean lockedLastStreamSend() {
        assert (this._lock.isHeldByCurrentThread());
        if (this._streamSendState != StreamSendState.SENDING) {
            return false;
        }
        this._streamSendState = StreamSendState.LAST_SENDING;
        return true;
    }

    public String toString() {
        try (AutoLock lock = this._lock.tryLock();){
            String held = lock.isHeldByCurrentThread() ? "" : "?";
            String string = String.format("%s@%x[%s:handling=%s,handled=%s,send=%s,completed=%s,request=%s]", new Object[]{TypeUtil.toShortName(this.getClass()), this.hashCode(), held, this._handling, this._handled, this._streamSendState, this._callbackCompleted, this._request});
            return string;
        }
    }

    private static void failed(Callback callback, Throwable failure) {
        try {
            callback.failed(failure);
        }
        catch (Throwable t) {
            ExceptionUtil.addSuppressedIfNotAssociated(t, failure);
            throw t;
        }
    }

    private class HandlerInvoker
    implements Invocable.Task,
    Callback {
        private HandlerInvoker() {
        }

        @Override
        public void run() {
            boolean completeStream;
            boolean callbackCompleted;
            Throwable failure;
            HttpStream stream;
            ChannelResponse response;
            ChannelRequest request;
            try (AutoLock ignored = HttpChannelState.this._lock.lock();){
                assert (HttpChannelState.this._handling == null && !HttpChannelState.this._handled);
                HttpChannelState.this._handling = Thread.currentThread();
                request = HttpChannelState.this._request;
                response = HttpChannelState.this._response;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("invoking handler in {}", (Object)HttpChannelState.this);
            }
            Server server = HttpChannelState.this._connectionMetaData.getConnector().getServer();
            try {
                String badMessage;
                String method;
                String pathInContext = Request.getPathInContext(request);
                if (!(pathInContext == null || pathInContext.startsWith("/") || HttpMethod.PRI.is(method = request.getMethod()) || HttpMethod.CONNECT.is(method) || HttpMethod.OPTIONS.is(method))) {
                    throw new BadMessageException("Bad URI path");
                }
                HttpURI uri = request.getHttpURI();
                if (uri.hasViolations() && (badMessage = UriCompliance.checkUriCompliance(HttpChannelState.this.getConnectionMetaData().getHttpConfiguration().getUriCompliance(), uri, HttpChannel.from(request).getComplianceViolationListener())) != null) {
                    throw new BadMessageException(badMessage);
                }
                HttpConfiguration configuration = HttpChannelState.this.getHttpConfiguration();
                ChannelRequest customized = request;
                HttpFields.Mutable responseHeaders = response.getHeaders();
                for (HttpConfiguration.Customizer customizer : configuration.getCustomizers()) {
                    Request next = customizer.customize(customized, responseHeaders);
                    customized = next == null ? customized : next;
                }
                if (customized != request && server.getRequestLog() != null) {
                    request.setLoggedRequest(customized);
                }
                if (!server.handle(customized, response, request._callback)) {
                    Response.writeError((Request)customized, (Response)response, (Callback)request._callback, 404);
                }
            }
            catch (Throwable t) {
                request._callback.failed(t);
            }
            try (AutoLock ignored = HttpChannelState.this._lock.lock();){
                stream = HttpChannelState.this._stream;
                HttpChannelState.this._handling = null;
                HttpChannelState.this._handled = true;
                failure = HttpChannelState.this._callbackFailure;
                callbackCompleted = HttpChannelState.this._callbackCompleted;
                boolean lastStreamSendComplete = HttpChannelState.this.lockedIsLastStreamSendCompleted();
                boolean bl = completeStream = callbackCompleted && lastStreamSendComplete;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("handler invoked: completeStream={} failure={} callbackCompleted={} {}", completeStream, failure, callbackCompleted, HttpChannelState.this);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("stream={}, failure={}, callbackCompleted={}, completeStream={}", stream, failure, callbackCompleted, completeStream);
            }
            if (completeStream) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("completeStream({}, {})", (Object)stream, (Object)Objects.toString(failure));
                }
                this.completeStream(stream, failure);
            }
        }

        @Override
        public void succeeded() {
            this.complete(null);
        }

        @Override
        public void failed(Throwable failure) {
            this.complete(failure);
        }

        private void complete(Throwable failure) {
            HttpStream stream;
            boolean completeStream;
            try (AutoLock ignored = HttpChannelState.this._lock.lock();){
                assert (HttpChannelState.this._callbackCompleted);
                HttpChannelState.this._streamSendState = StreamSendState.LAST_COMPLETE;
                completeStream = HttpChannelState.this._handling == null;
                stream = HttpChannelState.this._stream;
                failure = HttpChannelState.this._callbackFailure = ExceptionUtil.combine(HttpChannelState.this._callbackFailure, failure);
            }
            if (completeStream) {
                this.completeStream(stream, failure);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void completeStream(HttpStream stream, Throwable failure) {
            try {
                long idleTO;
                MultiPartFormData.Parts parts;
                RequestLog requestLog = HttpChannelState.this.getServer().getRequestLog();
                if (requestLog != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("logging {}", (Object)HttpChannelState.this);
                    }
                    requestLog.log(HttpChannelState.this._request.getLoggedRequest(), HttpChannelState.this._response);
                }
                if ((parts = MultiPartFormData.getParts(HttpChannelState.this._request)) != null) {
                    parts.close();
                }
                if ((idleTO = HttpChannelState.this.getHttpConfiguration().getIdleTimeout()) > 0L && HttpChannelState.this._oldIdleTimeout != idleTO) {
                    stream.setIdleTimeout(HttpChannelState.this._oldIdleTimeout);
                }
            }
            finally {
                ComplianceViolation.Listener listener = HttpChannelState.this.getComplianceViolationListener();
                if (listener != null) {
                    listener.onRequestEnd(HttpChannelState.this._request);
                }
                if (failure == null) {
                    stream.succeeded();
                } else {
                    stream.failed(failure);
                }
            }
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return HttpChannelState.this.getConnectionMetaData().getConnector().getServer().getInvocationType();
        }
    }

    private static enum StreamSendState {
        SENDING,
        LAST_SENDING,
        LAST_COMPLETE;

    }

    private class HttpChannelSerializedInvoker
    extends SerializedInvoker {
        public HttpChannelSerializedInvoker(String name, Executor executor) {
            super(name, executor);
        }

        @Override
        protected void onError(Runnable task, Throwable failure) {
            ChannelRequest request;
            boolean callbackCompleted;
            try (AutoLock ignore = HttpChannelState.this._lock.lock();){
                callbackCompleted = HttpChannelState.this._callbackCompleted;
                request = HttpChannelState.this._request;
            }
            if (request == null || callbackCompleted) {
                super.onError(task, failure);
                return;
            }
            Runnable failureTask = HttpChannelState.this.onFailure(failure);
            if (failureTask != null) {
                failureTask.run();
            }
        }
    }

    private static class InitializedCompositeComplianceViolationListener
    implements ComplianceViolation.Listener {
        private static final Logger LOG = LoggerFactory.getLogger(InitializedCompositeComplianceViolationListener.class);
        private final List<ComplianceViolation.Listener> _listeners;

        public InitializedCompositeComplianceViolationListener(List<ComplianceViolation.Listener> unInitializedListeners) {
            ArrayList<ComplianceViolation.Listener> initialized = null;
            for (ComplianceViolation.Listener listener : unInitializedListeners) {
                ComplianceViolation.Listener listening = listener.initialize();
                if (listening != listener) {
                    initialized = new ArrayList<ComplianceViolation.Listener>(unInitializedListeners.size());
                    for (ComplianceViolation.Listener l : unInitializedListeners) {
                        if (l == listener) break;
                        initialized.add(l);
                    }
                }
                if (initialized == null) continue;
                initialized.add(listening);
            }
            this._listeners = initialized == null ? unInitializedListeners : initialized;
        }

        @Override
        public void onRequestEnd(Attributes request) {
            for (ComplianceViolation.Listener listener : this._listeners) {
                try {
                    listener.onRequestEnd(request);
                }
                catch (Exception e) {
                    LOG.warn("Unable to notify ComplianceViolation.Listener implementation at {} of onRequestEnd {}", listener, request, e);
                }
            }
        }

        @Override
        public void onRequestBegin(Attributes request) {
            for (ComplianceViolation.Listener listener : this._listeners) {
                try {
                    listener.onRequestBegin(request);
                }
                catch (Exception e) {
                    LOG.warn("Unable to notify ComplianceViolation.Listener implementation at {} of onRequestBegin {}", listener, request, e);
                }
            }
        }

        @Override
        public ComplianceViolation.Listener initialize() {
            throw new IllegalStateException("already initialized");
        }

        @Override
        public void onComplianceViolation(ComplianceViolation.Event event) {
            assert (event != null);
            for (ComplianceViolation.Listener listener : this._listeners) {
                try {
                    listener.onComplianceViolation(event);
                }
                catch (Exception e) {
                    LOG.warn("Unable to notify ComplianceViolation.Listener implementation at {} of event {}", listener, event, e);
                }
            }
        }
    }

    public static class ChannelRequest
    extends Attributes.Lazy
    implements Request {
        private final long _headersNanoTime = NanoTime.now();
        private final ChannelCallback _callback = new ChannelCallback(this);
        private final String _id;
        private final ConnectionMetaData _connectionMetaData;
        private final MetaData.Request _metaData;
        private final AutoLock _lock;
        private final LongAdder _contentBytesRead = new LongAdder();
        private HttpChannelState _httpChannelState;
        private Request _loggedRequest;
        private HttpFields _trailers;

        ChannelRequest(HttpChannelState httpChannelState, MetaData.Request metaData) {
            this._httpChannelState = Objects.requireNonNull(httpChannelState);
            this._id = httpChannelState.getHttpStream().getId();
            this._connectionMetaData = httpChannelState.getConnectionMetaData();
            this._metaData = Objects.requireNonNull(metaData);
            this._lock = httpChannelState._lock;
        }

        public void setLoggedRequest(Request request) {
            this._loggedRequest = request;
        }

        public Request getLoggedRequest() {
            return this._loggedRequest == null ? this : this._loggedRequest;
        }

        HttpStream getHttpStream() {
            return this.getHttpChannelState()._stream;
        }

        public long getContentBytesRead() {
            return this._contentBytesRead.longValue();
        }

        @Override
        public String getId() {
            return this._id;
        }

        @Override
        public Components getComponents() {
            return this.getHttpChannelState();
        }

        @Override
        public ConnectionMetaData getConnectionMetaData() {
            return this._connectionMetaData;
        }

        private HttpChannelState getHttpChannelState() {
            try (AutoLock ignore = this._lock.lock();){
                HttpChannelState httpChannelState = this.lockedGetHttpChannelState();
                return httpChannelState;
            }
        }

        private HttpChannelState lockedGetHttpChannelState() {
            assert (this._lock.isHeldByCurrentThread());
            if (this._httpChannelState == null) {
                throw new IllegalStateException("channel already completed");
            }
            return this._httpChannelState;
        }

        @Override
        public String getMethod() {
            return this._metaData.getMethod();
        }

        @Override
        public HttpURI getHttpURI() {
            return this._metaData.getHttpURI();
        }

        @Override
        public Context getContext() {
            return this.getConnectionMetaData().getConnector().getServer().getContext();
        }

        @Override
        public HttpFields getHeaders() {
            return this._metaData.getHttpFields();
        }

        @Override
        public HttpFields getTrailers() {
            return this._trailers;
        }

        @Override
        public long getBeginNanoTime() {
            return this._metaData.getBeginNanoTime();
        }

        @Override
        public long getHeadersNanoTime() {
            return this._headersNanoTime;
        }

        @Override
        public boolean isSecure() {
            return HttpScheme.HTTPS.is(this.getHttpURI().getScheme());
        }

        @Override
        public long getLength() {
            return this._metaData.getContentLength();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Content.Chunk read() {
            try {
                boolean expecting100;
                HttpStream stream;
                try (AutoLock ignored = this._lock.lock();){
                    HttpChannelState httpChannel = this.lockedGetHttpChannelState();
                    Content.Chunk error = httpChannel._readFailure;
                    httpChannel._readFailure = Content.Chunk.next(error);
                    if (error != null) {
                        Content.Chunk chunk = error;
                        return chunk;
                    }
                    stream = httpChannel._stream;
                    expecting100 = httpChannel._expects100Continue;
                }
                Content.Chunk chunk = stream.read();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("read {}", (Object)chunk);
                }
                if (chunk == null) {
                    return null;
                }
                if (expecting100) {
                    try (AutoLock ignored2 = this._lock.lock();){
                        httpChannel._expects100Continue = false;
                    }
                }
                if (chunk.hasRemaining()) {
                    this._contentBytesRead.add(chunk.remaining());
                }
                if (!(chunk instanceof Trailers)) return chunk;
                Trailers trailers = (Trailers)chunk;
                this._trailers = trailers.getTrailers();
                return chunk;
            }
            catch (Throwable t) {
                return Content.Chunk.from(t, true);
            }
        }

        @Override
        public boolean consumeAvailable() {
            HttpStream stream;
            try (AutoLock ignored = this._lock.lock();){
                HttpChannelState httpChannel = this.lockedGetHttpChannelState();
                stream = httpChannel._stream;
            }
            return stream.consumeAvailable() == null;
        }

        @Override
        public void demand(Runnable demandCallback) {
            boolean error;
            HttpStream stream;
            HttpChannelState httpChannelState;
            InterimCallback interimCallback = null;
            try (AutoLock ignored = this._lock.lock();){
                httpChannelState = this.lockedGetHttpChannelState();
                stream = httpChannelState._stream;
                boolean bl = error = httpChannelState._readFailure != null;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("demand {}", (Object)httpChannelState);
                }
                if (!error) {
                    if (httpChannelState._onContentAvailable != null) {
                        throw new IllegalArgumentException("demand pending");
                    }
                    httpChannelState._onContentAvailable = demandCallback;
                    if (httpChannelState._expects100Continue && httpChannelState._response._writeCallback == null) {
                        interimCallback = new InterimCallback(httpChannelState);
                        httpChannelState._response._writeCallback = interimCallback;
                        httpChannelState._expects100Continue = false;
                    }
                }
            }
            if (error) {
                httpChannelState._readInvoker.run(demandCallback);
            } else if (interimCallback == null) {
                stream.demand();
            } else {
                stream.send(this._metaData, new MetaData.Response(100, null, this.getConnectionMetaData().getHttpVersion(), HttpFields.EMPTY), false, null, interimCallback);
                interimCallback.whenComplete((v, t) -> stream.demand());
            }
        }

        @Override
        public void fail(Throwable failure) {
            ThreadPool.executeImmediately(this.getContext(), this._httpChannelState.onFailure(failure));
        }

        @Override
        public void push(MetaData.Request resource) {
            this.getHttpStream().push(resource);
        }

        @Override
        public void addIdleTimeoutListener(Predicate<TimeoutException> onIdleTimeout) {
            try (AutoLock ignored = this._lock.lock();){
                HttpChannelState httpChannel = this.lockedGetHttpChannelState();
                if (httpChannel._readFailure != null) {
                    return;
                }
                if (httpChannel._onIdleTimeout == null) {
                    httpChannel._onIdleTimeout = onIdleTimeout;
                } else {
                    Predicate<TimeoutException> previous = httpChannel._onIdleTimeout;
                    httpChannel._onIdleTimeout = throwable -> {
                        if (!previous.test((TimeoutException)throwable)) {
                            return onIdleTimeout.test((TimeoutException)throwable);
                        }
                        return true;
                    };
                }
            }
        }

        @Override
        public void addFailureListener(Consumer<Throwable> onFailure) {
            try (AutoLock ignored = this._lock.lock();){
                HttpChannelState httpChannel = this.lockedGetHttpChannelState();
                if (httpChannel._readFailure != null) {
                    return;
                }
                if (httpChannel._onFailure == null) {
                    httpChannel._onFailure = onFailure;
                } else {
                    Consumer<Throwable> previous = httpChannel._onFailure;
                    httpChannel._onFailure = throwable -> {
                        try {
                            previous.accept((Throwable)throwable);
                        }
                        catch (Throwable t) {
                            ExceptionUtil.addSuppressedIfNotAssociated(throwable, t);
                        }
                        finally {
                            onFailure.accept((Throwable)throwable);
                        }
                    };
                }
            }
        }

        @Override
        public TunnelSupport getTunnelSupport() {
            return this.getHttpStream().getTunnelSupport();
        }

        @Override
        public void addHttpStreamWrapper(Function<HttpStream, HttpStream> wrapper) {
            this.getHttpChannelState().addHttpStreamWrapper(wrapper);
        }

        @Override
        public Session getSession(boolean create) {
            return null;
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public String toString() {
            return String.format("%s@%x %s %s", new Object[]{this.getMethod(), this.hashCode(), this.getHttpURI(), this._metaData.getHttpVersion()});
        }
    }

    public static class ChannelResponse
    implements Response,
    Callback {
        private final ChannelRequest _request;
        private final ResponseHttpFields _httpFields;
        protected int _status;
        private long _contentBytesWritten;
        private Supplier<HttpFields> _trailers;
        private Callback _writeCallback;
        private Throwable _writeFailure;

        private ChannelResponse(ChannelRequest request) {
            this._request = request;
            this._httpFields = this.getResponseHttpFields(this._request.lockedGetHttpChannelState());
        }

        protected ResponseHttpFields getResponseHttpFields(HttpChannelState httpChannelState) {
            return httpChannelState._responseHeaders;
        }

        protected ResponseHttpFields getResponseHttpFields() {
            return this._httpFields;
        }

        private boolean lockedIsWriting() {
            assert (this._request._lock.isHeldByCurrentThread());
            return this._writeCallback != null;
        }

        private Runnable lockedFailWrite(Throwable x) {
            assert (this._request._lock.isHeldByCurrentThread());
            Callback writeCallback = this._writeCallback;
            if (writeCallback == null) {
                return null;
            }
            this._writeCallback = null;
            Runnable cancellation = this._request.getHttpStream().cancelSend(x, writeCallback);
            this._writeFailure = ExceptionUtil.combine(this._writeFailure, x);
            return cancellation;
        }

        public long getContentBytesWritten() {
            return this._contentBytesWritten;
        }

        @Override
        public Request getRequest() {
            return this._request;
        }

        @Override
        public int getStatus() {
            return this._status;
        }

        @Override
        public void setStatus(int code) {
            if (code < 100 || code > 999) {
                throw new IllegalArgumentException();
            }
            if (!this.isCommitted()) {
                this._status = code;
            }
        }

        @Override
        public HttpFields.Mutable getHeaders() {
            return this._httpFields;
        }

        @Override
        public Supplier<HttpFields> getTrailersSupplier() {
            try (AutoLock ignored = this._request._lock.lock();){
                Supplier<HttpFields> supplier = this._trailers;
                return supplier;
            }
        }

        @Override
        public void setTrailersSupplier(Supplier<HttpFields> trailers) {
            try (AutoLock ignored = this._request._lock.lock();){
                this._trailers = trailers;
            }
        }

        @Override
        public void write(boolean last, ByteBuffer content, Callback callback) {
            HttpStream stream;
            long length = BufferUtil.length(content);
            MetaData.Response responseMetaData = null;
            try (AutoLock ignored = this._request._lock.lock();){
                HttpChannelState httpChannelState = this._request.lockedGetHttpChannelState();
                long totalWritten = this._contentBytesWritten + length;
                Throwable writeFailure = this._writeFailure;
                if (writeFailure == null) {
                    if (this._writeCallback != null) {
                        Callback callback2 = this._writeCallback;
                        if (callback2 instanceof InterimCallback) {
                            InterimCallback interimCallback = (InterimCallback)callback2;
                            interimCallback.whenComplete((v, t) -> this.write(last, content, callback));
                            return;
                        }
                        writeFailure = new WritePendingException();
                    } else {
                        long contentLength;
                        long committedContentLength = httpChannelState._committedContentLength;
                        long l = contentLength = committedContentLength >= 0L ? committedContentLength : this.getHeaders().getLongField(HttpHeader.CONTENT_LENGTH);
                        if (contentLength >= 0L && totalWritten != contentLength && (totalWritten != 0L || !HttpMethod.HEAD.is(this._request.getMethod()) && this.getStatus() != 304)) {
                            String lengthError = null;
                            if (totalWritten > contentLength) {
                                lengthError = "written %d > %d content-length";
                            } else if (last && (totalWritten != 0L || !HttpMethod.HEAD.is(this._request.getMethod()))) {
                                lengthError = "written %d < %d content-length";
                            }
                            if (lengthError != null) {
                                String message = lengthError.formatted(totalWritten, contentLength);
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("fail {} {}", (Object)callback, (Object)message);
                                }
                                writeFailure = new IOException(message);
                            }
                        }
                    }
                }
                if (writeFailure == null) {
                    writeFailure = httpChannelState.lockedStreamSend(last, length);
                }
                if (writeFailure == NOTHING_TO_SEND) {
                    httpChannelState._writeInvoker.run(callback::succeeded);
                    return;
                }
                if (writeFailure != null) {
                    Throwable failure = writeFailure;
                    httpChannelState._writeInvoker.run(() -> HttpChannelState.failed(callback, failure));
                    return;
                }
                this._writeCallback = callback;
                this._contentBytesWritten = totalWritten;
                stream = httpChannelState._stream;
                if (this._httpFields.commit()) {
                    responseMetaData = this.lockedPrepareResponse(httpChannelState, last);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("writing last={} {} {}", last, BufferUtil.toDetailString(content), this);
            }
            stream.send(this._request._metaData, responseMetaData, last, content, this);
        }

        @Override
        public void succeeded() {
            HttpChannelState httpChannel;
            Callback callback;
            if (LOG.isDebugEnabled()) {
                LOG.debug("write succeeded {}", (Object)this);
            }
            try (AutoLock ignored = this._request._lock.lock();){
                callback = this._writeCallback;
                this._writeCallback = null;
                httpChannel = this._request.lockedGetHttpChannelState();
                httpChannel.lockedStreamSendCompleted(true);
            }
            if (callback != null) {
                httpChannel._writeInvoker.run(callback::succeeded);
            }
        }

        @Override
        public void failed(Throwable x) {
            HttpChannelState httpChannel;
            Callback callback;
            if (LOG.isDebugEnabled()) {
                LOG.debug("write failed {}", (Object)this, (Object)x);
            }
            try (AutoLock ignored = this._request._lock.lock();){
                this._writeFailure = x;
                callback = this._writeCallback;
                this._writeCallback = null;
                httpChannel = this._request.lockedGetHttpChannelState();
                httpChannel.lockedStreamSendCompleted(false);
            }
            if (callback != null) {
                httpChannel._writeInvoker.run(() -> HttpChannelState.failed(callback, x));
            }
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return Invocable.getInvocationType(this._writeCallback);
        }

        @Override
        public boolean isCommitted() {
            return this._httpFields.isCommitted();
        }

        @Override
        public boolean hasLastWrite() {
            try (AutoLock ignored = this._request._lock.lock();){
                if (this._request._httpChannelState == null) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = this._request._httpChannelState._streamSendState != StreamSendState.SENDING;
                return bl;
            }
        }

        @Override
        public boolean isCompletedSuccessfully() {
            try (AutoLock ignored = this._request._lock.lock();){
                if (this._request._httpChannelState == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = this._request._httpChannelState._callbackCompleted && this._request._httpChannelState._callbackFailure == null;
                return bl;
            }
        }

        @Override
        public void reset() {
            this._status = 0;
            this._trailers = null;
            this._contentBytesWritten = 0L;
            this._request.getHttpChannelState().resetResponse();
        }

        @Override
        public CompletableFuture<Void> writeInterim(int status, HttpFields headers) {
            MetaData.Response response;
            InterimCallback interimCallback;
            HttpStream stream;
            if (!HttpStatus.isInterim(status)) {
                return CompletableFuture.failedFuture(new IllegalArgumentException("Invalid interim status code: " + status));
            }
            try (AutoLock ignored = this._request._lock.lock();){
                HttpChannelState httpChannelState = this._request.lockedGetHttpChannelState();
                stream = httpChannelState._stream;
                if (status == 100) {
                    if (!httpChannelState._expects100Continue) {
                        CompletableFuture<Void> completableFuture = CompletableFuture.failedFuture(new IllegalStateException("100 not expected"));
                        return completableFuture;
                    }
                    if (this._request.getLength() == 0L) {
                        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                        return completableFuture;
                    }
                    httpChannelState._expects100Continue = false;
                }
                if (this._httpFields.isCommitted()) {
                    CompletableFuture<Void> completableFuture = CompletableFuture.failedFuture(new IllegalStateException("Committed"));
                    return completableFuture;
                }
                if (this._writeCallback != null) {
                    CompletableFuture<Void> completableFuture = CompletableFuture.failedFuture(new WritePendingException());
                    return completableFuture;
                }
                interimCallback = new InterimCallback(httpChannelState);
                this._writeCallback = interimCallback;
                HttpVersion version = httpChannelState.getConnectionMetaData().getHttpVersion();
                response = new MetaData.Response(status, null, version, headers);
            }
            stream.send(this._request._metaData, response, false, null, interimCallback);
            return interimCallback;
        }

        MetaData.Response lockedPrepareResponse(HttpChannelState httpChannel, boolean last) {
            assert (this._request._lock.isHeldByCurrentThread());
            if (this._status == 0) {
                this._status = 200;
            }
            HttpFields.Mutable mutableHeaders = this._httpFields.getMutableHttpFields();
            httpChannel._committedContentLength = mutableHeaders.getLongField(HttpHeader.CONTENT_LENGTH);
            if (last && httpChannel._committedContentLength < 0L) {
                httpChannel._committedContentLength = this._contentBytesWritten;
                mutableHeaders.put(HttpHeader.CONTENT_LENGTH, httpChannel._committedContentLength);
            }
            httpChannel._stream.prepareResponse(mutableHeaders);
            return new MetaData.Response(this._status, null, httpChannel.getConnectionMetaData().getHttpVersion(), this._httpFields, httpChannel._committedContentLength, this.getTrailersSupplier());
        }

        public String toString() {
            return "%s@%x{%s,%s}".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode(), this.getStatus(), this.getRequest());
        }
    }

    private static class ThreadPoolWrapper
    implements ThreadPool {
        private final Executor _executor;

        private ThreadPoolWrapper(Executor executor) {
            this._executor = executor;
        }

        @Override
        public void execute(Runnable command) {
            this._executor.execute(command);
        }

        @Override
        public void join() {
        }

        @Override
        public int getThreads() {
            return 0;
        }

        @Override
        public int getIdleThreads() {
            return 0;
        }

        @Override
        public boolean isLowOnThreads() {
            return false;
        }
    }

    private static class ChannelCallback
    implements Callback {
        private final ChannelRequest _request;
        private Throwable _completedBy;

        private ChannelCallback(ChannelRequest request) {
            this._request = request;
        }

        @Override
        public void succeeded() {
            boolean completeStream;
            boolean needLastStreamSend;
            HttpStream stream;
            ChannelResponse response;
            HttpChannelState httpChannelState;
            ChannelRequest request;
            Throwable failure = null;
            MetaData.Response responseMetaData = null;
            ErrorResponse errorResponse = null;
            try (AutoLock ignored = this._request._lock.lock();){
                if (this.lockedCompleteCallback()) {
                    return;
                }
                request = this._request;
                httpChannelState = this._request._httpChannelState;
                response = httpChannelState._response;
                stream = httpChannelState._stream;
                if (httpChannelState._onContentAvailable != null) {
                    failure = ExceptionUtil.combine(failure, new IllegalStateException("demand pending"));
                }
                if (response.lockedIsWriting()) {
                    failure = ExceptionUtil.combine(failure, new IllegalStateException("write pending"));
                }
                assert (httpChannelState._callbackFailure == null);
                needLastStreamSend = httpChannelState.lockedLastStreamSend();
                boolean bl = completeStream = !needLastStreamSend && httpChannelState._handling == null && httpChannelState.lockedIsLastStreamSendCompleted();
                if (needLastStreamSend) {
                    response._writeCallback = httpChannelState._handlerInvoker;
                }
                if (httpChannelState._responseHeaders.commit()) {
                    responseMetaData = response.lockedPrepareResponse(httpChannelState, true);
                }
                long totalWritten = response._contentBytesWritten;
                long committedContentLength = httpChannelState._committedContentLength;
                if (committedContentLength >= 0L && committedContentLength != totalWritten && (totalWritten != 0L || !HttpMethod.HEAD.is(this._request.getMethod()) && response.getStatus() != 304)) {
                    failure = ExceptionUtil.combine(failure, new IOException("content-length %d != %d written".formatted(committedContentLength, totalWritten)));
                }
                Throwable unconsumed = stream.consumeAvailable();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("consumeAvailable: {} {} ", (Object)(unconsumed == null ? 1 : 0), (Object)httpChannelState);
                }
                if (unconsumed != null && httpChannelState.getConnectionMetaData().isPersistent()) {
                    failure = ExceptionUtil.combine(failure, unconsumed);
                }
                if (failure != null) {
                    httpChannelState._callbackFailure = failure;
                    if (!stream.isCommitted()) {
                        errorResponse = new ErrorResponse(request);
                    } else {
                        completeStream = true;
                    }
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("succeeded: failure={} needLastStreamSend={} {}", failure, needLastStreamSend, this);
            }
            if (errorResponse != null) {
                Response.writeError((Request)request, (Response)errorResponse, (Callback)new ErrorCallback(request, errorResponse, stream, failure), failure);
            } else if (needLastStreamSend) {
                stream.send(this._request._metaData, responseMetaData, true, null, response);
            } else if (completeStream) {
                httpChannelState._handlerInvoker.completeStream(stream, failure);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("No action on succeeded {}", (Object)this);
            }
        }

        @Override
        public void failed(Throwable failure) {
            try {
                ChannelRequest request;
                HttpStream stream;
                ErrorResponse errorResponse = null;
                try (AutoLock ignored = this._request._lock.lock();){
                    if (this.lockedCompleteCallback()) {
                        return;
                    }
                    HttpChannelState httpChannelState = this._request._httpChannelState;
                    stream = httpChannelState._stream;
                    request = this._request;
                    assert (httpChannelState._callbackFailure == null);
                    httpChannelState._callbackFailure = failure;
                    if (!stream.isCommitted() && !(failure instanceof Request.Handler.AbortException)) {
                        Throwable unconsumed = stream.consumeAvailable();
                        ExceptionUtil.addSuppressedIfNotAssociated(failure, unconsumed);
                        ChannelResponse response = httpChannelState._response;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("failed stream.isCommitted={}, response.isCommitted={} {}", stream.isCommitted(), response.isCommitted(), this);
                        }
                        errorResponse = new ErrorResponse(request);
                    }
                }
                if (errorResponse != null) {
                    Response.writeError((Request)request, errorResponse, (Callback)new ErrorCallback(request, errorResponse, stream, failure), failure);
                } else {
                    this._request.getHttpChannelState()._handlerInvoker.failed(failure);
                }
            }
            catch (Throwable t) {
                ExceptionUtil.addSuppressedIfNotAssociated(t, failure);
                throw t;
            }
        }

        private boolean lockedCompleteCallback() {
            assert (this._request._lock.isHeldByCurrentThread());
            HttpChannelState httpChannelState = this._request._httpChannelState;
            if (httpChannelState == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("already recycled after completion {} by", (Object)this._request, (Object)this._completedBy);
                }
                return true;
            }
            if (httpChannelState._callbackCompleted) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("already completed {} by", (Object)this._request, (Object)this._completedBy);
                    LOG.debug("Second complete", new Throwable("second complete"));
                }
                return true;
            }
            if (LOG.isDebugEnabled()) {
                this._completedBy = new Throwable(Thread.currentThread().getName());
            }
            httpChannelState._callbackCompleted = true;
            return false;
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return this._request.getHttpStream().getInvocationType();
        }
    }

    private static class InterimCallback
    extends Callback.Completable {
        private final HttpChannelState _httpChannelState;

        private InterimCallback(HttpChannelState httpChannelState) {
            this._httpChannelState = httpChannelState;
        }

        @Override
        public void succeeded() {
            this.completing();
            super.succeeded();
        }

        @Override
        public void failed(Throwable x) {
            try {
                this.completing();
                super.failed(x);
            }
            catch (Throwable t) {
                ExceptionUtil.addSuppressedIfNotAssociated(t, x);
                throw t;
            }
        }

        private void completing() {
            try (AutoLock ignore = this._httpChannelState._lock.lock();){
                if (this._httpChannelState._response._writeCallback == this) {
                    this._httpChannelState._response._writeCallback = null;
                }
            }
        }
    }

    private static class ErrorCallback
    implements Callback {
        private final ChannelRequest _request;
        private final ErrorResponse _errorResponse;
        private final HttpStream _stream;
        private final Throwable _failure;

        public ErrorCallback(ChannelRequest request, ErrorResponse response, HttpStream stream, Throwable failure) {
            this._request = request;
            this._errorResponse = response;
            this._stream = stream;
            this._failure = failure;
        }

        @Override
        public void succeeded() {
            boolean needLastWrite;
            Throwable failure;
            HttpChannelState httpChannelState;
            if (LOG.isDebugEnabled()) {
                LOG.debug("ErrorWrite succeeded: {}", (Object)this);
            }
            MetaData.Response responseMetaData = null;
            try (AutoLock ignored = this._request._lock.lock();){
                httpChannelState = this._request.getHttpChannelState();
                failure = this._failure;
                needLastWrite = httpChannelState.lockedLastStreamSend();
                if (needLastWrite && this._errorResponse.getResponseHttpFields().commit()) {
                    responseMetaData = this._errorResponse.lockedPrepareResponse(httpChannelState, true);
                }
            }
            if (needLastWrite) {
                this._stream.send(this._request._metaData, responseMetaData, true, null, Callback.from(() -> httpChannelState._handlerInvoker.failed(failure), (Throwable x) -> {
                    ExceptionUtil.addSuppressedIfNotAssociated(failure, x);
                    httpChannelState._handlerInvoker.failed(failure);
                }));
            } else {
                HttpChannelState.failed(httpChannelState._handlerInvoker, failure);
            }
        }

        @Override
        public void failed(Throwable x) {
            HttpChannelState httpChannelState;
            Throwable failure;
            if (LOG.isDebugEnabled()) {
                LOG.debug("ErrorWrite failed: {}", (Object)this, (Object)x);
            }
            try (AutoLock ignored = this._request._lock.lock();){
                failure = this._failure;
                httpChannelState = this._request.lockedGetHttpChannelState();
                httpChannelState._response._status = this._errorResponse._status;
            }
            ExceptionUtil.addSuppressedIfNotAssociated(failure, x);
            HttpChannelState.failed(httpChannelState._handlerInvoker, failure);
        }

        public String toString() {
            return "%s@%x".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode());
        }
    }

    private static class ErrorResponse
    extends ChannelResponse {
        public ErrorResponse(ChannelRequest request) {
            super(request);
            this._status = 500;
        }

        @Override
        protected ResponseHttpFields getResponseHttpFields(HttpChannelState httpChannelState) {
            httpChannelState._committedContentLength = -1L;
            ResponseHttpFields original = super.getResponseHttpFields(httpChannelState);
            ResponseHttpFields httpFields = new ResponseHttpFields();
            for (HttpField field : original) {
                HttpHeader header = field.getHeader();
                if (header != HttpHeader.SERVER && header != HttpHeader.DATE) continue;
                httpFields.add(field);
            }
            return httpFields;
        }

        @Override
        MetaData.Response lockedPrepareResponse(HttpChannelState httpChannelState, boolean last) {
            assert (httpChannelState._request._lock.isHeldByCurrentThread());
            MetaData.Response httpFields = super.lockedPrepareResponse(httpChannelState, last);
            httpChannelState._response._status = this._status;
            HttpFields.Mutable originalResponseFields = httpChannelState._responseHeaders.getMutableHttpFields();
            originalResponseFields.clear();
            originalResponseFields.add(this.getResponseHttpFields());
            return httpFields;
        }
    }
}

