/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.loadgen;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.loadgen.NormalDistStats;

public class OutputStream
implements Serializable {
    public final String id;
    public final NormalDistStats rate;
    public final boolean areKeysSkewed;

    public static OutputStream fromConf(Map<String, Object> conf) {
        String streamId = (String)conf.getOrDefault("streamId", "default");
        NormalDistStats rate = NormalDistStats.fromConf((Map)conf.get("rate"));
        boolean areKeysSkewed = (Boolean)conf.getOrDefault("areKeysSkewed", false);
        return new OutputStream(streamId, rate, areKeysSkewed);
    }

    public Map<String, Object> toConf() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("streamId", this.id);
        ret.put("rate", this.rate.toConf());
        ret.put("areKeysSkewed", this.areKeysSkewed);
        return ret;
    }

    public OutputStream remap(String origId, Map<GlobalStreamId, GlobalStreamId> remappedStreams) {
        GlobalStreamId remapped = remappedStreams.get(new GlobalStreamId(origId, this.id));
        return new OutputStream(remapped.get_streamId(), this.rate, this.areKeysSkewed);
    }

    public OutputStream scaleThroughput(double v) {
        return new OutputStream(this.id, this.rate.scaleBy(v), this.areKeysSkewed);
    }

    public OutputStream(String id, NormalDistStats rate, boolean areKeysSkewed) {
        this.id = id;
        this.rate = rate;
        this.areKeysSkewed = areKeysSkewed;
    }

    public static class Builder {
        private String id;
        private NormalDistStats rate;
        private boolean areKeysSkewed;

        public String getId() {
            return this.id;
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public NormalDistStats getRate() {
            return this.rate;
        }

        public Builder withRate(NormalDistStats rate) {
            this.rate = rate;
            return this;
        }

        public boolean isAreKeysSkewed() {
            return this.areKeysSkewed;
        }

        public Builder withAreKeysSkewed(boolean areKeysSkewed) {
            this.areKeysSkewed = areKeysSkewed;
            return this;
        }

        public OutputStream build() {
            return new OutputStream(this.id, this.rate, this.areKeysSkewed);
        }
    }
}

