/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.loadgen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.loadgen.OutputStream;
import org.apache.storm.loadgen.SlowExecutorPattern;
import org.apache.storm.utils.ObjectReader;

public class LoadCompConf {
    public final String id;
    public final int parallelism;
    public final List<OutputStream> streams;
    public final double cpuLoad;
    public final double memoryLoad;
    public final SlowExecutorPattern slp;

    public static LoadCompConf fromConf(Map<String, Object> conf) {
        String id = (String)conf.get("id");
        int parallelism = ObjectReader.getInt((Object)conf.get("parallelism"), (Integer)1);
        ArrayList<OutputStream> streams = new ArrayList<OutputStream>();
        List streamData = (List)conf.get("streams");
        if (streamData != null) {
            for (Map streamInfo : streamData) {
                streams.add(OutputStream.fromConf(streamInfo));
            }
        }
        double memoryMb = ObjectReader.getDouble((Object)conf.get("memoryLoad"), (Double)0.0);
        double cpuPercent = ObjectReader.getDouble((Object)conf.get("cpuLoad"), (Double)0.0);
        SlowExecutorPattern slp = null;
        if (conf.containsKey("slowExecutorPattern")) {
            slp = SlowExecutorPattern.fromConf((Map)conf.get("slowExecutorPattern"));
        }
        return new LoadCompConf(id, parallelism, streams, memoryMb, cpuPercent, slp);
    }

    public Map<String, Object> toConf() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("id", this.id);
        ret.put("parallelism", this.parallelism);
        if (this.memoryLoad > 0.0) {
            ret.put("memoryLoad", this.memoryLoad);
        }
        if (this.cpuLoad > 0.0) {
            ret.put("cpuLoad", this.cpuLoad);
        }
        if (this.streams != null) {
            ArrayList<Map<String, Object>> streamData = new ArrayList<Map<String, Object>>();
            for (OutputStream out : this.streams) {
                streamData.add(out.toConf());
            }
            ret.put("streams", streamData);
        }
        if (this.slp != null) {
            ret.put("slowExecutorPattern", this.slp.toConf());
        }
        return ret;
    }

    public LoadCompConf remap(Map<String, String> remappedComponents, Map<GlobalStreamId, GlobalStreamId> remappedStreams) {
        String remappedId = remappedComponents.get(this.id);
        List<OutputStream> remappedOutStreams = this.streams == null ? null : this.streams.stream().map(orig -> orig.remap(this.id, remappedStreams)).collect(Collectors.toList());
        return new LoadCompConf(remappedId, this.parallelism, remappedOutStreams, this.cpuLoad, this.memoryLoad, this.slp);
    }

    public LoadCompConf scaleParallel(double v) {
        return this.setParallel(Math.max(1, (int)Math.ceil((double)this.parallelism * v)));
    }

    public LoadCompConf setParallel(int newParallelism) {
        double throughputAdjustment = (double)this.parallelism / (double)newParallelism;
        return new LoadCompConf(this.id, newParallelism, this.streams, this.cpuLoad, this.memoryLoad, this.slp).scaleThroughput(throughputAdjustment);
    }

    public LoadCompConf scaleThroughput(double v) {
        if (this.streams != null) {
            List<OutputStream> newStreams = this.streams.stream().map(s -> s.scaleThroughput(v)).collect(Collectors.toList());
            return new LoadCompConf(this.id, this.parallelism, newStreams, this.cpuLoad, this.memoryLoad, this.slp);
        }
        return this;
    }

    public LoadCompConf overrideSlowExecutorPattern(SlowExecutorPattern slp) {
        if (slp != null) {
            return new LoadCompConf(this.id, this.parallelism, this.streams, this.cpuLoad, this.memoryLoad, slp);
        }
        return this;
    }

    public double getAllEmittedAggregate() {
        double ret = 0.0;
        if (this.streams != null) {
            for (OutputStream out : this.streams) {
                if (out.rate == null) continue;
                ret += out.rate.mean * (double)this.parallelism;
            }
        }
        return ret;
    }

    public LoadCompConf(String id, int parallelism, List<OutputStream> streams, double cpuLoad, double memoryLoad, SlowExecutorPattern slp) {
        this.id = id;
        if (id == null) {
            throw new IllegalArgumentException("A spout ID cannot be null");
        }
        this.parallelism = parallelism;
        this.streams = streams;
        this.cpuLoad = cpuLoad;
        this.memoryLoad = memoryLoad;
        this.slp = slp;
    }

    public static class Builder {
        private String id;
        private int parallelism = 1;
        private List<OutputStream> streams;
        private double cpuLoad = 0.0;
        private double memoryLoad = 0.0;
        private SlowExecutorPattern slp = null;

        public String getId() {
            return this.id;
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public int getParallelism() {
            return this.parallelism;
        }

        public Builder withParallelism(int parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        public List<OutputStream> getStreams() {
            return this.streams;
        }

        public Builder withStream(OutputStream stream) {
            if (this.streams == null) {
                this.streams = new ArrayList<OutputStream>();
            }
            this.streams.add(stream);
            return this;
        }

        public Builder withStreams(List<OutputStream> streams) {
            this.streams = streams;
            return this;
        }

        public Builder withCpuLoad(double cpuLoad) {
            this.cpuLoad = cpuLoad;
            return this;
        }

        public Builder withMemoryLoad(double memoryLoad) {
            this.memoryLoad = memoryLoad;
            return this;
        }

        public Builder withSlowExecutorPattern(SlowExecutorPattern slp) {
            this.slp = slp;
            return this;
        }

        public LoadCompConf build() {
            return new LoadCompConf(this.id, this.parallelism, this.streams, this.cpuLoad, this.memoryLoad, this.slp);
        }
    }
}

