/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.loadgen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.storm.Config;
import org.apache.storm.generated.Nimbus;
import org.apache.storm.generated.TopologySummary;
import org.apache.storm.loadgen.CaptureLoad;
import org.apache.storm.loadgen.TopologyLoadConf;
import org.apache.storm.utils.NimbusClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EstimateThroughput {
    private static final Logger LOG = LoggerFactory.getLogger(EstimateThroughput.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Options options = new Options();
        options.addOption(Option.builder("h").longOpt("help").desc("Print a help message").build());
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = null;
        boolean printHelp = false;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println("ERROR " + e.getMessage());
            printHelp = true;
        }
        if (printHelp || cmd.hasOption('h')) {
            new HelpFormatter().printHelp("EstimateThroughput [options] [topologyName]*", options);
            return;
        }
        Config conf = new Config();
        int exitStatus = -1;
        ArrayList<TopologyLoadConf> regular = new ArrayList<TopologyLoadConf>();
        ArrayList<TopologyLoadConf> trident = new ArrayList<TopologyLoadConf>();
        try (NimbusClient nc = NimbusClient.Builder.withConf((Map)conf).build();){
            Nimbus.Iface client = nc.getClient();
            List<String> topologyNames = cmd.getArgList();
            for (TopologySummary topologySummary : client.getTopologySummaries()) {
                if (!topologyNames.isEmpty() && !topologyNames.contains(topologySummary.get_name())) continue;
                TopologyLoadConf capturedConf = CaptureLoad.captureTopology(client, topologySummary);
                if (capturedConf.looksLikeTrident()) {
                    trident.add(capturedConf);
                    continue;
                }
                regular.add(capturedConf);
            }
            System.out.println("TOPOLOGY\tTOTAL MESSAGES/sec\tESTIMATED INPUT MESSAGES/sec");
            for (TopologyLoadConf tl : regular) {
                System.out.println(tl.name + "\t" + tl.getAllEmittedAggregate() + "\t" + tl.getSpoutEmittedAggregate());
            }
            for (TopologyLoadConf tl : trident) {
                System.out.println(tl.name + "\t" + tl.getAllEmittedAggregate() + "\t" + tl.getTridentEstimatedEmittedAggregate());
            }
            exitStatus = 0;
        }
        catch (Exception e) {
            LOG.error("Error trying to capture topologies...", e);
        }
        finally {
            System.exit(exitStatus);
        }
    }
}

