/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.trident;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.storm.kafka.trident.mapper.TridentTupleToKafkaMapper;
import org.apache.storm.kafka.trident.selector.KafkaTopicSelector;
import org.apache.storm.topology.FailedException;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.state.State;
import org.apache.storm.trident.tuple.TridentTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TridentKafkaState<K, V>
implements State {
    private static final Logger LOG = LoggerFactory.getLogger(TridentKafkaState.class);
    private KafkaProducer<K, V> producer;
    private TridentTupleToKafkaMapper<K, V> mapper;
    private KafkaTopicSelector topicSelector;

    public TridentKafkaState<K, V> withTridentTupleToKafkaMapper(TridentTupleToKafkaMapper<K, V> mapper) {
        this.mapper = mapper;
        return this;
    }

    public TridentKafkaState<K, V> withKafkaTopicSelector(KafkaTopicSelector selector) {
        this.topicSelector = selector;
        return this;
    }

    public void beginCommit(Long txid) {
        LOG.debug("beginCommit is Noop.");
    }

    public void commit(Long txid) {
        LOG.debug("commit is Noop.");
    }

    public void prepare(Properties options) {
        Objects.requireNonNull(this.mapper, "mapper can not be null");
        Objects.requireNonNull(this.topicSelector, "topicSelector can not be null");
        this.producer = new KafkaProducer(options);
    }

    public void updateState(List<TridentTuple> tuples, TridentCollector collector) {
        String topic = null;
        try {
            long startTime = System.currentTimeMillis();
            int numberOfRecords = tuples.size();
            ArrayList<Future> futures = new ArrayList<Future>(numberOfRecords);
            for (TridentTuple tuple : tuples) {
                topic = this.topicSelector.getTopic(tuple);
                Iterator<Object> messageFromTuple = this.mapper.getMessageFromTuple(tuple);
                K k = this.mapper.getKeyFromTuple(tuple);
                if (topic != null) {
                    if (messageFromTuple != null) {
                        Future result = this.producer.send(new ProducerRecord(topic, k, messageFromTuple));
                        futures.add(result);
                        continue;
                    }
                    LOG.warn("skipping Message with Key {} as message was null", k);
                    continue;
                }
                LOG.warn("skipping key = {}, topic selector returned null.", k);
            }
            int emittedRecords = futures.size();
            ArrayList<ExecutionException> exceptions = new ArrayList<ExecutionException>(emittedRecords);
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    exceptions.add(e);
                }
            }
            if (exceptions.size() > 0) {
                StringBuilder errorMsg = new StringBuilder("Could not retrieve result for messages ");
                errorMsg.append(tuples).append(" from topic = ").append(topic).append(" because of the following exceptions:").append(System.lineSeparator());
                for (ExecutionException exception : exceptions) {
                    errorMsg = errorMsg.append(exception.getMessage()).append(System.lineSeparator());
                }
                String string = errorMsg.toString();
                LOG.error(string);
                throw new FailedException(string);
            }
            long latestTime = System.currentTimeMillis();
            LOG.info("Emitted record {} sucessfully in {} ms to topic {} ", new Object[]{emittedRecords, latestTime - startTime, topic});
        }
        catch (Exception ex) {
            String errorMsg = "Could not send messages " + String.valueOf(tuples) + " to topic = " + topic;
            LOG.warn(errorMsg, (Throwable)ex);
            throw new FailedException(errorMsg, (Throwable)ex);
        }
    }
}

