/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout.subscription;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.spout.subscription.ManualPartitioner;
import org.apache.storm.task.TopologyContext;

public class RoundRobinManualPartitioner
implements ManualPartitioner {
    @Override
    public Set<TopicPartition> getPartitionsForThisTask(List<TopicPartition> allPartitionsSorted, TopologyContext context) {
        int thisTaskIndex = context.getThisTaskIndex();
        int totalTaskCount = context.getComponentTasks(context.getThisComponentId()).size();
        HashSet<TopicPartition> myPartitions = new HashSet<TopicPartition>(allPartitionsSorted.size() / totalTaskCount + 1);
        for (int i = thisTaskIndex; i < allPartitionsSorted.size(); i += totalTaskCount) {
            myPartitions.add(allPartitionsSorted.get(i));
        }
        return myPartitions;
    }
}

