/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.storm.annotation.InterfaceStability;
import org.apache.storm.kafka.spout.EmptyKafkaTupleListener;
import org.apache.storm.kafka.spout.KafkaSpoutRetryExponentialBackoff;
import org.apache.storm.kafka.spout.KafkaSpoutRetryService;
import org.apache.storm.kafka.spout.KafkaTupleListener;
import org.apache.storm.kafka.spout.internal.CommonKafkaSpoutConfig;
import org.apache.storm.kafka.spout.subscription.ManualPartitioner;
import org.apache.storm.kafka.spout.subscription.TopicFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSpoutConfig<K, V>
extends CommonKafkaSpoutConfig<K, V> {
    private static final long serialVersionUID = 141902646130682494L;
    public static final long DEFAULT_OFFSET_COMMIT_PERIOD_MS = 30000L;
    public static final int DEFAULT_MAX_RETRIES = Integer.MAX_VALUE;
    public static final int DEFAULT_MAX_UNCOMMITTED_OFFSETS = 10000000;
    public static final KafkaSpoutRetryService DEFAULT_RETRY_SERVICE = new KafkaSpoutRetryExponentialBackoff(KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds(0L), KafkaSpoutRetryExponentialBackoff.TimeInterval.milliSeconds(2L), Integer.MAX_VALUE, KafkaSpoutRetryExponentialBackoff.TimeInterval.seconds(10L));
    public static final ProcessingGuarantee DEFAULT_PROCESSING_GUARANTEE = ProcessingGuarantee.AT_LEAST_ONCE;
    public static final KafkaTupleListener DEFAULT_TUPLE_LISTENER = new EmptyKafkaTupleListener();
    public static final Logger LOG = LoggerFactory.getLogger(KafkaSpoutConfig.class);
    public static final int DEFAULT_METRICS_TIME_BUCKET_SIZE_SECONDS = 60;
    private final long offsetCommitPeriodMs;
    private final int maxUncommittedOffsets;
    private final KafkaSpoutRetryService retryService;
    private final KafkaTupleListener tupleListener;
    private final boolean emitNullTuples;
    private final ProcessingGuarantee processingGuarantee;
    private final boolean tupleTrackingEnforced;
    private final int metricsTimeBucketSizeInSecs;

    public KafkaSpoutConfig(Builder<K, V> builder) {
        super(builder.setKafkaPropsForProcessingGuarantee());
        this.offsetCommitPeriodMs = builder.offsetCommitPeriodMs;
        this.maxUncommittedOffsets = builder.maxUncommittedOffsets;
        this.retryService = builder.retryService;
        this.tupleListener = builder.tupleListener;
        this.emitNullTuples = builder.emitNullTuples;
        this.processingGuarantee = builder.processingGuarantee;
        this.tupleTrackingEnforced = builder.tupleTrackingEnforced;
        this.metricsTimeBucketSizeInSecs = builder.metricsTimeBucketSizeInSecs;
        this.setConsumerGroupId(builder.groupId);
    }

    public static Builder<String, String> builder(String bootstrapServers, String ... topics) {
        return new Builder(bootstrapServers, topics).withStringDeserializers();
    }

    public static Builder<String, String> builder(String bootstrapServers, Set<String> topics) {
        return new Builder(bootstrapServers, topics).withStringDeserializers();
    }

    public static Builder<String, String> builder(String bootstrapServers, Pattern topics) {
        return new Builder(bootstrapServers, topics).withStringDeserializers();
    }

    public long getOffsetsCommitPeriodMs() {
        return this.offsetCommitPeriodMs;
    }

    public ProcessingGuarantee getProcessingGuarantee() {
        return this.processingGuarantee;
    }

    public boolean isTupleTrackingEnforced() {
        return this.tupleTrackingEnforced;
    }

    public String getConsumerGroupId() {
        return (String)this.getKafkaProps().get("group.id");
    }

    public void setConsumerGroupId(String groupId) {
        if (groupId != null) {
            this.getKafkaProps().put("group.id", groupId);
        }
    }

    public int getMaxUncommittedOffsets() {
        return this.maxUncommittedOffsets;
    }

    public KafkaSpoutRetryService getRetryService() {
        return this.retryService;
    }

    public KafkaTupleListener getTupleListener() {
        return this.tupleListener;
    }

    public boolean isEmitNullTuples() {
        return this.emitNullTuples;
    }

    public int getMetricsTimeBucketSizeInSecs() {
        return this.metricsTimeBucketSizeInSecs;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("offsetCommitPeriodMs", this.offsetCommitPeriodMs).append("maxUncommittedOffsets", this.maxUncommittedOffsets).append("retryService", (Object)this.retryService).append("tupleListener", (Object)this.tupleListener).append("processingGuarantee", (Object)this.processingGuarantee).append("emitNullTuples", this.emitNullTuples).append("tupleTrackingEnforced", this.tupleTrackingEnforced).append("metricsTimeBucketSizeInSecs", this.metricsTimeBucketSizeInSecs).toString();
    }

    public static class Builder<K, V>
    extends CommonKafkaSpoutConfig.Builder<K, V, Builder<K, V>> {
        private long offsetCommitPeriodMs = 30000L;
        private int maxUncommittedOffsets = 10000000;
        private KafkaSpoutRetryService retryService = DEFAULT_RETRY_SERVICE;
        private KafkaTupleListener tupleListener = DEFAULT_TUPLE_LISTENER;
        private boolean emitNullTuples = false;
        private ProcessingGuarantee processingGuarantee = DEFAULT_PROCESSING_GUARANTEE;
        private boolean tupleTrackingEnforced = false;
        private int metricsTimeBucketSizeInSecs = 60;
        private String groupId;

        public Builder(String bootstrapServers, String ... topics) {
            super(bootstrapServers, topics);
        }

        public Builder(String bootstrapServers, Set<String> topics) {
            super(bootstrapServers, topics);
        }

        public Builder(String bootstrapServers, Pattern topics) {
            super(bootstrapServers, topics);
        }

        public Builder(String bootstrapServers, TopicFilter topicFilter, ManualPartitioner topicPartitioner) {
            super(bootstrapServers, topicFilter, topicPartitioner);
        }

        public Builder<K, V> setOffsetCommitPeriodMs(long offsetCommitPeriodMs) {
            this.offsetCommitPeriodMs = offsetCommitPeriodMs;
            return this;
        }

        public Builder<K, V> setGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder<K, V> setMaxUncommittedOffsets(int maxUncommittedOffsets) {
            this.maxUncommittedOffsets = maxUncommittedOffsets;
            return this;
        }

        public Builder<K, V> setRetry(KafkaSpoutRetryService retryService) {
            if (retryService == null) {
                throw new NullPointerException("retryService cannot be null");
            }
            this.retryService = retryService;
            return this;
        }

        public Builder<K, V> setTupleListener(KafkaTupleListener tupleListener) {
            if (tupleListener == null) {
                throw new NullPointerException("KafkaTupleListener cannot be null");
            }
            this.tupleListener = tupleListener;
            return this;
        }

        public Builder<K, V> setEmitNullTuples(boolean emitNullTuples) {
            this.emitNullTuples = emitNullTuples;
            return this;
        }

        public Builder<K, V> setProcessingGuarantee(ProcessingGuarantee processingGuarantee) {
            this.processingGuarantee = processingGuarantee;
            return this;
        }

        public Builder<K, V> setTupleTrackingEnforced(boolean tupleTrackingEnforced) {
            this.tupleTrackingEnforced = tupleTrackingEnforced;
            return this;
        }

        public Builder<K, V> setMetricsTimeBucketSizeInSecs(int metricsTimeBucketSizeInSecs) {
            this.metricsTimeBucketSizeInSecs = metricsTimeBucketSizeInSecs;
            return this;
        }

        private Builder<K, V> withStringDeserializers() {
            this.setProp("key.deserializer", StringDeserializer.class);
            this.setProp("value.deserializer", StringDeserializer.class);
            return this;
        }

        private Builder<K, V> setKafkaPropsForProcessingGuarantee() {
            if (this.getKafkaProps().containsKey("enable.auto.commit")) {
                throw new IllegalStateException("The KafkaConsumer enable.auto.commit setting is not supported. You can configure similar behavior through KafkaSpoutConfig.Builder.setProcessingGuarantee");
            }
            String autoOffsetResetPolicy = (String)this.getKafkaProps().get("auto.offset.reset");
            if (this.processingGuarantee == ProcessingGuarantee.AT_LEAST_ONCE) {
                if (autoOffsetResetPolicy == null) {
                    LOG.info("Setting Kafka consumer property '{}' to 'earliest' to ensure at-least-once processing", (Object)"auto.offset.reset");
                    this.setProp("auto.offset.reset", "earliest");
                } else if (!autoOffsetResetPolicy.equals("earliest") && !autoOffsetResetPolicy.equals("none")) {
                    LOG.warn("Cannot guarantee at-least-once processing with auto.offset.reset.policy other than 'earliest' or 'none'. Some messages may be skipped.");
                }
            } else if (this.processingGuarantee == ProcessingGuarantee.AT_MOST_ONCE && autoOffsetResetPolicy != null && !autoOffsetResetPolicy.equals("latest") && !autoOffsetResetPolicy.equals("none")) {
                LOG.warn("Cannot guarantee at-most-once processing with auto.offset.reset.policy other than 'latest' or 'none'. Some messages may be processed more than once.");
            }
            LOG.info("Setting Kafka consumer property '{}' to 'false', because the spout does not support auto-commit", (Object)"enable.auto.commit");
            this.setProp("enable.auto.commit", false);
            return this;
        }

        @Override
        public KafkaSpoutConfig<K, V> build() {
            return new KafkaSpoutConfig(this);
        }
    }

    @InterfaceStability.Unstable
    public static enum ProcessingGuarantee {
        AT_LEAST_ONCE,
        AT_MOST_ONCE,
        NO_GUARANTEE;

    }
}

