/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout.internal;

import java.util.concurrent.TimeUnit;
import org.apache.storm.utils.Time;

public class Timer {
    private final long delay;
    private final long period;
    private final TimeUnit timeUnit;
    private final long periodNanos;
    private long start;

    public Timer(long delay, long period, TimeUnit timeUnit) {
        this.delay = delay;
        this.period = period;
        this.timeUnit = timeUnit;
        this.periodNanos = timeUnit.toNanos(period);
        this.start = Time.nanoTime() + timeUnit.toNanos(delay);
    }

    public long period() {
        return this.period;
    }

    public long delay() {
        return this.delay;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public boolean isExpiredResetOnTrue() {
        boolean expired;
        boolean bl = expired = Time.nanoTime() - this.start >= this.periodNanos;
        if (expired) {
            this.start = Time.nanoTime();
        }
        return expired;
    }
}

