/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

public class LogContext {
    private final String logPrefix;

    public LogContext(String logPrefix) {
        this.logPrefix = logPrefix == null ? "" : logPrefix;
    }

    public LogContext() {
        this("");
    }

    public Logger logger(Class<?> clazz) {
        return this.logger(LoggerFactory.getLogger(clazz));
    }

    public Logger logger(String clazz) {
        return this.logger(LoggerFactory.getLogger(clazz));
    }

    private Logger logger(Logger logger) {
        if (logger instanceof LocationAwareLogger) {
            return new LocationAwareKafkaLogger(this.logPrefix, (LocationAwareLogger)logger);
        }
        return new LocationIgnorantKafkaLogger(this.logPrefix, logger);
    }

    public String logPrefix() {
        return this.logPrefix;
    }

    private static class LocationAwareKafkaLogger
    extends AbstractKafkaLogger {
        private final LocationAwareLogger logger;
        private final String fqcn;

        LocationAwareKafkaLogger(String logPrefix, LocationAwareLogger logger) {
            super(logPrefix);
            this.logger = logger;
            this.fqcn = LocationAwareKafkaLogger.class.getName();
        }

        @Override
        public String getName() {
            return this.logger.getName();
        }

        @Override
        public boolean isTraceEnabled() {
            return this.logger.isTraceEnabled();
        }

        @Override
        public boolean isTraceEnabled(Marker marker) {
            return this.logger.isTraceEnabled(marker);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        @Override
        public boolean isDebugEnabled(Marker marker) {
            return this.logger.isDebugEnabled(marker);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        @Override
        public boolean isInfoEnabled(Marker marker) {
            return this.logger.isInfoEnabled(marker);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        @Override
        public boolean isWarnEnabled(Marker marker) {
            return this.logger.isWarnEnabled(marker);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled();
        }

        @Override
        public boolean isErrorEnabled(Marker marker) {
            return this.logger.isErrorEnabled(marker);
        }

        @Override
        public void trace(String message) {
            if (this.logger.isTraceEnabled()) {
                this.writeLog(null, 0, message, null, null);
            }
        }

        @Override
        public void trace(String format, Object arg) {
            if (this.logger.isTraceEnabled()) {
                this.writeLog(null, 0, format, new Object[]{arg}, null);
            }
        }

        @Override
        public void trace(String format, Object arg1, Object arg2) {
            if (this.logger.isTraceEnabled()) {
                this.writeLog(null, 0, format, new Object[]{arg1, arg2}, null);
            }
        }

        @Override
        public void trace(String format, Object ... args) {
            if (this.logger.isTraceEnabled()) {
                this.writeLog(null, 0, format, args, null);
            }
        }

        @Override
        public void trace(String msg, Throwable t) {
            if (this.logger.isTraceEnabled()) {
                this.writeLog(null, 0, msg, null, t);
            }
        }

        @Override
        public void trace(Marker marker, String msg) {
            if (this.logger.isTraceEnabled()) {
                this.writeLog(marker, 0, msg, null, null);
            }
        }

        @Override
        public void trace(Marker marker, String format, Object arg) {
            if (this.logger.isTraceEnabled()) {
                this.writeLog(marker, 0, format, new Object[]{arg}, null);
            }
        }

        @Override
        public void trace(Marker marker, String format, Object arg1, Object arg2) {
            if (this.logger.isTraceEnabled()) {
                this.writeLog(marker, 0, format, new Object[]{arg1, arg2}, null);
            }
        }

        @Override
        public void trace(Marker marker, String format, Object ... argArray) {
            if (this.logger.isTraceEnabled()) {
                this.writeLog(marker, 0, format, argArray, null);
            }
        }

        @Override
        public void trace(Marker marker, String msg, Throwable t) {
            if (this.logger.isTraceEnabled()) {
                this.writeLog(marker, 0, msg, null, t);
            }
        }

        @Override
        public void debug(String message) {
            if (this.logger.isDebugEnabled()) {
                this.writeLog(null, 10, message, null, null);
            }
        }

        @Override
        public void debug(String format, Object arg) {
            if (this.logger.isDebugEnabled()) {
                this.writeLog(null, 10, format, new Object[]{arg}, null);
            }
        }

        @Override
        public void debug(String format, Object arg1, Object arg2) {
            if (this.logger.isDebugEnabled()) {
                this.writeLog(null, 10, format, new Object[]{arg1, arg2}, null);
            }
        }

        @Override
        public void debug(String format, Object ... args) {
            if (this.logger.isDebugEnabled()) {
                this.writeLog(null, 10, format, args, null);
            }
        }

        @Override
        public void debug(String msg, Throwable t) {
            if (this.logger.isDebugEnabled()) {
                this.writeLog(null, 10, msg, null, t);
            }
        }

        @Override
        public void debug(Marker marker, String msg) {
            if (this.logger.isDebugEnabled()) {
                this.writeLog(marker, 10, msg, null, null);
            }
        }

        @Override
        public void debug(Marker marker, String format, Object arg) {
            if (this.logger.isDebugEnabled()) {
                this.writeLog(marker, 10, format, new Object[]{arg}, null);
            }
        }

        @Override
        public void debug(Marker marker, String format, Object arg1, Object arg2) {
            if (this.logger.isDebugEnabled()) {
                this.writeLog(marker, 10, format, new Object[]{arg1, arg2}, null);
            }
        }

        @Override
        public void debug(Marker marker, String format, Object ... arguments) {
            if (this.logger.isDebugEnabled()) {
                this.writeLog(marker, 10, format, arguments, null);
            }
        }

        @Override
        public void debug(Marker marker, String msg, Throwable t) {
            if (this.logger.isDebugEnabled()) {
                this.writeLog(marker, 10, msg, null, t);
            }
        }

        @Override
        public void warn(String message) {
            this.writeLog(null, 30, message, null, null);
        }

        @Override
        public void warn(String format, Object arg) {
            this.writeLog(null, 30, format, new Object[]{arg}, null);
        }

        @Override
        public void warn(String message, Object arg1, Object arg2) {
            this.writeLog(null, 30, message, new Object[]{arg1, arg2}, null);
        }

        @Override
        public void warn(String format, Object ... args) {
            this.writeLog(null, 30, format, args, null);
        }

        @Override
        public void warn(String msg, Throwable t) {
            this.writeLog(null, 30, msg, null, t);
        }

        @Override
        public void warn(Marker marker, String msg) {
            this.writeLog(marker, 30, msg, null, null);
        }

        @Override
        public void warn(Marker marker, String format, Object arg) {
            this.writeLog(marker, 30, format, new Object[]{arg}, null);
        }

        @Override
        public void warn(Marker marker, String format, Object arg1, Object arg2) {
            this.writeLog(marker, 30, format, new Object[]{arg1, arg2}, null);
        }

        @Override
        public void warn(Marker marker, String format, Object ... arguments) {
            this.writeLog(marker, 30, format, arguments, null);
        }

        @Override
        public void warn(Marker marker, String msg, Throwable t) {
            this.writeLog(marker, 30, msg, null, t);
        }

        @Override
        public void error(String message) {
            this.writeLog(null, 40, message, null, null);
        }

        @Override
        public void error(String format, Object arg) {
            this.writeLog(null, 40, format, new Object[]{arg}, null);
        }

        @Override
        public void error(String format, Object arg1, Object arg2) {
            this.writeLog(null, 40, format, new Object[]{arg1, arg2}, null);
        }

        @Override
        public void error(String format, Object ... args) {
            this.writeLog(null, 40, format, args, null);
        }

        @Override
        public void error(String msg, Throwable t) {
            this.writeLog(null, 40, msg, null, t);
        }

        @Override
        public void error(Marker marker, String msg) {
            this.writeLog(marker, 40, msg, null, null);
        }

        @Override
        public void error(Marker marker, String format, Object arg) {
            this.writeLog(marker, 40, format, new Object[]{arg}, null);
        }

        @Override
        public void error(Marker marker, String format, Object arg1, Object arg2) {
            this.writeLog(marker, 40, format, new Object[]{arg1, arg2}, null);
        }

        @Override
        public void error(Marker marker, String format, Object ... arguments) {
            this.writeLog(marker, 40, format, arguments, null);
        }

        @Override
        public void error(Marker marker, String msg, Throwable t) {
            this.writeLog(marker, 40, msg, null, t);
        }

        @Override
        public void info(String msg) {
            this.writeLog(null, 20, msg, null, null);
        }

        @Override
        public void info(String format, Object arg) {
            this.writeLog(null, 20, format, new Object[]{arg}, null);
        }

        @Override
        public void info(String format, Object arg1, Object arg2) {
            this.writeLog(null, 20, format, new Object[]{arg1, arg2}, null);
        }

        @Override
        public void info(String format, Object ... args) {
            this.writeLog(null, 20, format, args, null);
        }

        @Override
        public void info(String msg, Throwable t) {
            this.writeLog(null, 20, msg, null, t);
        }

        @Override
        public void info(Marker marker, String msg) {
            this.writeLog(marker, 20, msg, null, null);
        }

        @Override
        public void info(Marker marker, String format, Object arg) {
            this.writeLog(marker, 20, format, new Object[]{arg}, null);
        }

        @Override
        public void info(Marker marker, String format, Object arg1, Object arg2) {
            this.writeLog(marker, 20, format, new Object[]{arg1, arg2}, null);
        }

        @Override
        public void info(Marker marker, String format, Object ... arguments) {
            this.writeLog(marker, 20, format, arguments, null);
        }

        @Override
        public void info(Marker marker, String msg, Throwable t) {
            this.writeLog(marker, 20, msg, null, t);
        }

        private void writeLog(Marker marker, int level, String format, Object[] args, Throwable exception) {
            String message = format;
            if (args != null && args.length > 0) {
                FormattingTuple formatted = MessageFormatter.arrayFormat(format, args);
                if (exception == null && formatted.getThrowable() != null) {
                    exception = formatted.getThrowable();
                }
                message = formatted.getMessage();
            }
            this.logger.log(marker, this.fqcn, level, this.addPrefix(message), null, exception);
        }
    }

    private static class LocationIgnorantKafkaLogger
    extends AbstractKafkaLogger {
        private final Logger logger;

        LocationIgnorantKafkaLogger(String logPrefix, Logger logger) {
            super(logPrefix);
            this.logger = logger;
        }

        @Override
        public String getName() {
            return this.logger.getName();
        }

        @Override
        public boolean isTraceEnabled() {
            return this.logger.isTraceEnabled();
        }

        @Override
        public boolean isTraceEnabled(Marker marker) {
            return this.logger.isTraceEnabled(marker);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        @Override
        public boolean isDebugEnabled(Marker marker) {
            return this.logger.isDebugEnabled(marker);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        @Override
        public boolean isInfoEnabled(Marker marker) {
            return this.logger.isInfoEnabled(marker);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        @Override
        public boolean isWarnEnabled(Marker marker) {
            return this.logger.isWarnEnabled(marker);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled();
        }

        @Override
        public boolean isErrorEnabled(Marker marker) {
            return this.logger.isErrorEnabled(marker);
        }

        @Override
        public void trace(String message) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(this.addPrefix(message));
            }
        }

        @Override
        public void trace(String message, Object arg) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(this.addPrefix(message), arg);
            }
        }

        @Override
        public void trace(String message, Object arg1, Object arg2) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(this.addPrefix(message), arg1, arg2);
            }
        }

        @Override
        public void trace(String message, Object ... args) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(this.addPrefix(message), args);
            }
        }

        @Override
        public void trace(String msg, Throwable t) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(this.addPrefix(msg), t);
            }
        }

        @Override
        public void trace(Marker marker, String msg) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(marker, this.addPrefix(msg));
            }
        }

        @Override
        public void trace(Marker marker, String format, Object arg) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(marker, this.addPrefix(format), arg);
            }
        }

        @Override
        public void trace(Marker marker, String format, Object arg1, Object arg2) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(marker, this.addPrefix(format), arg1, arg2);
            }
        }

        @Override
        public void trace(Marker marker, String format, Object ... argArray) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(marker, this.addPrefix(format), argArray);
            }
        }

        @Override
        public void trace(Marker marker, String msg, Throwable t) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(marker, this.addPrefix(msg), t);
            }
        }

        @Override
        public void debug(String message) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.addPrefix(message));
            }
        }

        @Override
        public void debug(String message, Object arg) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.addPrefix(message), arg);
            }
        }

        @Override
        public void debug(String message, Object arg1, Object arg2) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.addPrefix(message), arg1, arg2);
            }
        }

        @Override
        public void debug(String message, Object ... args) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.addPrefix(message), args);
            }
        }

        @Override
        public void debug(String msg, Throwable t) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.addPrefix(msg), t);
            }
        }

        @Override
        public void debug(Marker marker, String msg) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(marker, this.addPrefix(msg));
            }
        }

        @Override
        public void debug(Marker marker, String format, Object arg) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(marker, this.addPrefix(format), arg);
            }
        }

        @Override
        public void debug(Marker marker, String format, Object arg1, Object arg2) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(marker, this.addPrefix(format), arg1, arg2);
            }
        }

        @Override
        public void debug(Marker marker, String format, Object ... arguments) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(marker, this.addPrefix(format), arguments);
            }
        }

        @Override
        public void debug(Marker marker, String msg, Throwable t) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(marker, this.addPrefix(msg), t);
            }
        }

        @Override
        public void warn(String message) {
            this.logger.warn(this.addPrefix(message));
        }

        @Override
        public void warn(String message, Object arg) {
            this.logger.warn(this.addPrefix(message), arg);
        }

        @Override
        public void warn(String message, Object arg1, Object arg2) {
            this.logger.warn(this.addPrefix(message), arg1, arg2);
        }

        @Override
        public void warn(String message, Object ... args) {
            this.logger.warn(this.addPrefix(message), args);
        }

        @Override
        public void warn(String msg, Throwable t) {
            this.logger.warn(this.addPrefix(msg), t);
        }

        @Override
        public void warn(Marker marker, String msg) {
            this.logger.warn(marker, this.addPrefix(msg));
        }

        @Override
        public void warn(Marker marker, String format, Object arg) {
            this.logger.warn(marker, this.addPrefix(format), arg);
        }

        @Override
        public void warn(Marker marker, String format, Object arg1, Object arg2) {
            this.logger.warn(marker, this.addPrefix(format), arg1, arg2);
        }

        @Override
        public void warn(Marker marker, String format, Object ... arguments) {
            this.logger.warn(marker, this.addPrefix(format), arguments);
        }

        @Override
        public void warn(Marker marker, String msg, Throwable t) {
            this.logger.warn(marker, this.addPrefix(msg), t);
        }

        @Override
        public void error(String message) {
            this.logger.error(this.addPrefix(message));
        }

        @Override
        public void error(String message, Object arg) {
            this.logger.error(this.addPrefix(message), arg);
        }

        @Override
        public void error(String message, Object arg1, Object arg2) {
            this.logger.error(this.addPrefix(message), arg1, arg2);
        }

        @Override
        public void error(String message, Object ... args) {
            this.logger.error(this.addPrefix(message), args);
        }

        @Override
        public void error(String msg, Throwable t) {
            this.logger.error(this.addPrefix(msg), t);
        }

        @Override
        public void error(Marker marker, String msg) {
            this.logger.error(marker, this.addPrefix(msg));
        }

        @Override
        public void error(Marker marker, String format, Object arg) {
            this.logger.error(marker, this.addPrefix(format), arg);
        }

        @Override
        public void error(Marker marker, String format, Object arg1, Object arg2) {
            this.logger.error(marker, this.addPrefix(format), arg1, arg2);
        }

        @Override
        public void error(Marker marker, String format, Object ... arguments) {
            this.logger.error(marker, this.addPrefix(format), arguments);
        }

        @Override
        public void error(Marker marker, String msg, Throwable t) {
            this.logger.error(marker, this.addPrefix(msg), t);
        }

        @Override
        public void info(String message) {
            this.logger.info(this.addPrefix(message));
        }

        @Override
        public void info(String message, Object arg) {
            this.logger.info(this.addPrefix(message), arg);
        }

        @Override
        public void info(String message, Object arg1, Object arg2) {
            this.logger.info(this.addPrefix(message), arg1, arg2);
        }

        @Override
        public void info(String message, Object ... args) {
            this.logger.info(this.addPrefix(message), args);
        }

        @Override
        public void info(String msg, Throwable t) {
            this.logger.info(this.addPrefix(msg), t);
        }

        @Override
        public void info(Marker marker, String msg) {
            this.logger.info(marker, this.addPrefix(msg));
        }

        @Override
        public void info(Marker marker, String format, Object arg) {
            this.logger.info(marker, this.addPrefix(format), arg);
        }

        @Override
        public void info(Marker marker, String format, Object arg1, Object arg2) {
            this.logger.info(marker, this.addPrefix(format), arg1, arg2);
        }

        @Override
        public void info(Marker marker, String format, Object ... arguments) {
            this.logger.info(marker, this.addPrefix(format), arguments);
        }

        @Override
        public void info(Marker marker, String msg, Throwable t) {
            this.logger.info(marker, this.addPrefix(msg), t);
        }
    }

    private static abstract class AbstractKafkaLogger
    implements Logger {
        private final String prefix;

        protected AbstractKafkaLogger(String prefix) {
            this.prefix = prefix;
        }

        protected String addPrefix(String message) {
            return this.prefix + message;
        }
    }
}

