/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.compress;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.apache.kafka.common.utils.ChunkedBytesStream;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

public class SnappyCompression
implements Compression {
    private SnappyCompression() {
    }

    @Override
    public CompressionType type() {
        return CompressionType.SNAPPY;
    }

    @Override
    public OutputStream wrapForOutput(ByteBufferOutputStream bufferStream, byte messageVersion) {
        try {
            return new SnappyOutputStream(bufferStream);
        }
        catch (Throwable e) {
            throw new KafkaException(e);
        }
    }

    @Override
    public InputStream wrapForInput(ByteBuffer buffer, byte messageVersion, BufferSupplier decompressionBufferSupplier) {
        try {
            return new ChunkedBytesStream(new SnappyInputStream(new ByteBufferInputStream(buffer)), decompressionBufferSupplier, this.decompressionOutputSize(), false);
        }
        catch (Throwable e) {
            throw new KafkaException(e);
        }
    }

    @Override
    public int decompressionOutputSize() {
        return 2048;
    }

    public boolean equals(Object o) {
        return o instanceof SnappyCompression;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static class Builder
    implements Compression.Builder<SnappyCompression> {
        @Override
        public SnappyCompression build() {
            return new SnappyCompression();
        }
    }
}

