/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.clients.consumer.internals.events.CompletableEvent;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class CompletableEventReaper {
    private final Logger log;
    private final List<CompletableEvent<?>> tracked;

    public CompletableEventReaper(LogContext logContext) {
        this.log = logContext.logger(CompletableEventReaper.class);
        this.tracked = new ArrayList();
    }

    public void add(CompletableEvent<?> event) {
        this.tracked.add(Objects.requireNonNull(event, "Event to track must be non-null"));
    }

    public long reap(long currentTimeMs) {
        int count = 0;
        Iterator<CompletableEvent<?>> iterator = this.tracked.iterator();
        while (iterator.hasNext()) {
            CompletableEvent<?> event = iterator.next();
            if (event.future().isDone()) {
                iterator.remove();
                continue;
            }
            long deadlineMs = event.deadlineMs();
            long pastDueMs = currentTimeMs - deadlineMs;
            if (pastDueMs < 0L) continue;
            TimeoutException error = new TimeoutException(String.format("%s was %s ms past its expiration of %s", event.getClass().getSimpleName(), pastDueMs, deadlineMs));
            if (event.future().completeExceptionally(error)) {
                this.log.debug("Event {} completed exceptionally since its expiration of {} passed {} ms ago", event, deadlineMs, pastDueMs);
            } else {
                this.log.trace("Event {} not completed exceptionally since it was previously completed", (Object)event);
            }
            ++count;
            iterator.remove();
        }
        return count;
    }

    public long reap(Collection<?> events) {
        Objects.requireNonNull(events, "Event queue to reap must be non-null");
        long trackedExpiredCount = this.completeEventsExceptionallyOnClose(this.tracked);
        this.tracked.clear();
        long eventExpiredCount = this.completeEventsExceptionallyOnClose(events);
        events.clear();
        return trackedExpiredCount + eventExpiredCount;
    }

    public int size() {
        return this.tracked.size();
    }

    public boolean contains(CompletableEvent<?> event) {
        return event != null && this.tracked.contains(event);
    }

    public List<CompletableEvent<?>> uncompletedEvents() {
        ArrayList events = new ArrayList();
        for (CompletableEvent<?> event : this.tracked) {
            if (event.future().isDone()) continue;
            events.add(event);
        }
        return events;
    }

    private long completeEventsExceptionallyOnClose(Collection<?> events) {
        long count = 0L;
        for (Object o : events) {
            CompletableEvent event;
            if (!(o instanceof CompletableEvent) || (event = (CompletableEvent)o).future().isDone()) continue;
            ++count;
            TimeoutException error = new TimeoutException(String.format("%s could not be completed before the consumer closed", event.getClass().getSimpleName()));
            if (event.future().completeExceptionally(error)) {
                this.log.debug("Event {} completed exceptionally since the consumer is closing", (Object)event);
                continue;
            }
            this.log.trace("Event {} not completed exceptionally since it was completed prior to the consumer closing", (Object)event);
        }
        return count;
    }
}

