/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout.trident;

import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.storm.kafka.spout.internal.CommonKafkaSpoutConfig;
import org.apache.storm.kafka.spout.subscription.ManualPartitioner;
import org.apache.storm.kafka.spout.subscription.TopicFilter;

public class KafkaTridentSpoutConfig<K, V>
extends CommonKafkaSpoutConfig<K, V> {
    private static final long serialVersionUID = 1L;

    public KafkaTridentSpoutConfig(Builder<K, V> builder) {
        super(builder);
    }

    public static Builder<String, String> builder(String bootstrapServers, String ... topics) {
        return new Builder(bootstrapServers, topics).withStringDeserializers();
    }

    public static Builder<String, String> builder(String bootstrapServers, Set<String> topics) {
        return new Builder(bootstrapServers, topics).withStringDeserializers();
    }

    public static Builder<String, String> builder(String bootstrapServers, Pattern topics) {
        return new Builder(bootstrapServers, topics).withStringDeserializers();
    }

    public static class Builder<K, V>
    extends CommonKafkaSpoutConfig.Builder<K, V, Builder<K, V>> {
        public Builder(String bootstrapServers, String ... topics) {
            super(bootstrapServers, topics);
        }

        public Builder(String bootstrapServers, Set<String> topics) {
            super(bootstrapServers, topics);
        }

        public Builder(String bootstrapServers, Pattern topics) {
            super(bootstrapServers, topics);
        }

        public Builder(String bootstrapServers, TopicFilter topicFilter, ManualPartitioner topicPartitioner) {
            super(bootstrapServers, topicFilter, topicPartitioner);
        }

        private Builder<K, V> withStringDeserializers() {
            this.setProp("key.deserializer", StringDeserializer.class);
            this.setProp("value.deserializer", StringDeserializer.class);
            return this;
        }

        @Override
        public KafkaTridentSpoutConfig<K, V> build() {
            return new KafkaTridentSpoutConfig(this);
        }
    }
}

