/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout.metrics2;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.spout.internal.OffsetManager;
import org.apache.storm.kafka.spout.metrics2.KafkaOffsetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaOffsetPartitionMetrics<K, V>
implements MetricSet {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaOffsetPartitionMetrics.class);
    private final Supplier<Map<TopicPartition, OffsetManager>> offsetManagerSupplier;
    private final Supplier<Admin> adminSupplier;
    private TopicPartition topicPartition;

    public KafkaOffsetPartitionMetrics(Supplier<Map<TopicPartition, OffsetManager>> offsetManagerSupplier, Supplier<Admin> adminSupplier, TopicPartition topicPartition) {
        this.offsetManagerSupplier = offsetManagerSupplier;
        this.adminSupplier = adminSupplier;
        this.topicPartition = topicPartition;
        LOG.info("Running KafkaOffsetMetricSet");
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Metric> metrics = new HashMap<String, Metric>();
        String metricPath = this.topicPartition.topic() + "/partition_" + this.topicPartition.partition();
        Gauge spoutLagGauge = () -> {
            Map<TopicPartition, Long> endOffsets = KafkaOffsetUtil.getEndOffsets(Collections.singleton(this.topicPartition), this.adminSupplier);
            if (endOffsets == null || endOffsets.isEmpty()) {
                LOG.error("Failed to get endOffsets from Kafka for topic partitions: {}.", (Object)this.topicPartition);
                return 0L;
            }
            OffsetManager offsetManager = this.offsetManagerSupplier.get().get(this.topicPartition);
            return endOffsets.get(this.topicPartition) - offsetManager.getCommittedOffset();
        };
        Gauge earliestTimeOffsetGauge = () -> {
            Map<TopicPartition, Long> beginningOffsets = KafkaOffsetUtil.getBeginningOffsets(Collections.singleton(this.topicPartition), this.adminSupplier);
            if (beginningOffsets == null || beginningOffsets.isEmpty()) {
                LOG.error("Failed to get beginningOffsets from Kafka for topic partitions: {}.", (Object)this.topicPartition);
                return 0L;
            }
            return beginningOffsets.get(this.topicPartition);
        };
        Gauge latestTimeOffsetGauge = () -> {
            Map<TopicPartition, Long> endOffsets = KafkaOffsetUtil.getEndOffsets(Collections.singleton(this.topicPartition), this.adminSupplier);
            if (endOffsets == null || endOffsets.isEmpty()) {
                LOG.error("Failed to get endOffsets from Kafka for topic partitions: {}.", (Object)this.topicPartition);
                return 0L;
            }
            return endOffsets.get(this.topicPartition);
        };
        Gauge latestEmittedOffsetGauge = () -> {
            OffsetManager offsetManager = this.offsetManagerSupplier.get().get(this.topicPartition);
            return offsetManager.getLatestEmittedOffset();
        };
        Gauge latestCompletedOffsetGauge = () -> {
            OffsetManager offsetManager = this.offsetManagerSupplier.get().get(this.topicPartition);
            return offsetManager.getCommittedOffset();
        };
        Gauge recordsInPartitionGauge = () -> {
            Map<TopicPartition, Long> endOffsets = KafkaOffsetUtil.getEndOffsets(Collections.singleton(this.topicPartition), this.adminSupplier);
            if (endOffsets == null || endOffsets.isEmpty()) {
                LOG.error("Failed to get endOffsets from Kafka for topic partitions: {}.", (Object)this.topicPartition);
                return 0L;
            }
            Map<TopicPartition, Long> beginningOffsets = KafkaOffsetUtil.getBeginningOffsets(Collections.singleton(this.topicPartition), this.adminSupplier);
            if (beginningOffsets == null || beginningOffsets.isEmpty()) {
                LOG.error("Failed to get beginningOffsets from Kafka for topic partitions: {}.", (Object)this.topicPartition);
                return 0L;
            }
            return endOffsets.get(this.topicPartition) - beginningOffsets.get(this.topicPartition);
        };
        metrics.put(metricPath + "/spoutLag", (Metric)spoutLagGauge);
        metrics.put(metricPath + "/earliestTimeOffset", (Metric)earliestTimeOffsetGauge);
        metrics.put(metricPath + "/latestTimeOffset", (Metric)latestTimeOffsetGauge);
        metrics.put(metricPath + "/latestEmittedOffset", (Metric)latestEmittedOffsetGauge);
        metrics.put(metricPath + "/latestCompletedOffset", (Metric)latestCompletedOffsetGauge);
        metrics.put(metricPath + "/recordsInPartition", (Metric)recordsInPartitionGauge);
        return metrics;
    }
}

