/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout.metrics2;

import com.codahale.metrics.MetricSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.spout.internal.OffsetManager;
import org.apache.storm.kafka.spout.metrics2.KafkaOffsetPartitionMetrics;
import org.apache.storm.kafka.spout.metrics2.KafkaOffsetTopicMetrics;
import org.apache.storm.task.TopologyContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaOffsetMetricManager<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaOffsetMetricManager.class);
    private final Supplier<Map<TopicPartition, OffsetManager>> offsetManagerSupplier;
    private final Supplier<Admin> adminSupplier;
    private TopologyContext topologyContext;
    private Map<String, KafkaOffsetTopicMetrics> topicMetricsMap;
    private Map<TopicPartition, KafkaOffsetPartitionMetrics> topicPartitionMetricsMap;

    public KafkaOffsetMetricManager(Supplier<Map<TopicPartition, OffsetManager>> offsetManagerSupplier, Supplier<Admin> adminSupplier, TopologyContext topologyContext) {
        this.offsetManagerSupplier = offsetManagerSupplier;
        this.adminSupplier = adminSupplier;
        this.topologyContext = topologyContext;
        this.topicMetricsMap = new HashMap<String, KafkaOffsetTopicMetrics>();
        this.topicPartitionMetricsMap = new HashMap<TopicPartition, KafkaOffsetPartitionMetrics>();
        LOG.info("Running KafkaOffsetMetricManager");
    }

    public void registerMetricsForNewTopicPartitions(Set<TopicPartition> newAssignment) {
        for (TopicPartition topicPartition : newAssignment) {
            if (this.topicPartitionMetricsMap.containsKey(topicPartition)) continue;
            LOG.info("Registering metric for topicPartition: {}", (Object)topicPartition);
            String topic = topicPartition.topic();
            KafkaOffsetTopicMetrics topicMetrics = this.topicMetricsMap.get(topic);
            if (topicMetrics == null) {
                LOG.info("Registering metric for topic: {}", (Object)topic);
                topicMetrics = new KafkaOffsetTopicMetrics(topic, this.offsetManagerSupplier, this.adminSupplier, newAssignment);
                this.topicMetricsMap.put(topic, topicMetrics);
                this.topologyContext.registerMetricSet("kafkaOffset", (MetricSet)topicMetrics);
            }
            KafkaOffsetPartitionMetrics topicPartitionMetricSet = new KafkaOffsetPartitionMetrics(this.offsetManagerSupplier, this.adminSupplier, topicPartition);
            this.topicPartitionMetricsMap.put(topicPartition, topicPartitionMetricSet);
            this.topologyContext.registerMetricSet("kafkaOffset", topicPartitionMetricSet);
        }
    }

    public Map<TopicPartition, KafkaOffsetPartitionMetrics> getTopicPartitionMetricsMap() {
        return this.topicPartitionMetricsMap;
    }

    public Map<String, KafkaOffsetTopicMetrics> getTopicMetricsMap() {
        return this.topicMetricsMap;
    }
}

