/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.util.regex.Pattern;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.kafka.spout.FirstPollOffsetStrategy;
import org.apache.storm.kafka.spout.KafkaSpout;
import org.apache.storm.kafka.spout.KafkaSpoutConfig;
import org.apache.storm.kafka.spout.KafkaSpoutTestBolt;
import org.apache.storm.kafka.spout.KafkaSpoutTopologyMainNamedTopics;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.TopologyBuilder;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;

public class KafkaSpoutTopologyMainWildcardTopics
extends KafkaSpoutTopologyMainNamedTopics {
    private static final String STREAM = "test_wildcard_stream";
    private static final Pattern TOPIC_WILDCARD_PATTERN = Pattern.compile("kafka-spout-test-[1|2]");

    public static void main(String[] args) throws Exception {
        new KafkaSpoutTopologyMainWildcardTopics().runMain(args);
    }

    @Override
    protected StormTopology getTopologyKafkaSpout(KafkaSpoutConfig<String, String> spoutConfig) {
        TopologyBuilder tp = new TopologyBuilder();
        tp.setSpout("kafka_spout", new KafkaSpout<String, String>(spoutConfig), (Number)1);
        tp.setBolt("kafka_bolt", (IRichBolt)new KafkaSpoutTestBolt()).shuffleGrouping("kafka_spout", STREAM);
        return tp.createTopology();
    }

    @Override
    protected KafkaSpoutConfig<String, String> getKafkaSpoutConfig(String bootstrapServers) {
        return ((KafkaSpoutConfig.Builder)((KafkaSpoutConfig.Builder)((KafkaSpoutConfig.Builder)KafkaSpoutConfig.builder(bootstrapServers, TOPIC_WILDCARD_PATTERN).setProp("group.id", "kafkaSpoutTestGroup")).setRetry(this.getRetryService()).setRecordTranslator(r -> new Values(new Object[]{r.topic(), r.partition(), r.offset(), r.key(), r.value()}), new Fields(new String[]{"topic", "partition", "offset", "key", "value"}), STREAM)).setOffsetCommitPeriodMs(10000L).setFirstPollOffsetStrategy(FirstPollOffsetStrategy.EARLIEST)).setMaxUncommittedOffsets(250).build();
    }
}

