/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.storm.kafka.spout.Func;
import org.apache.storm.kafka.spout.RecordTranslator;
import org.apache.storm.kafka.spout.SimpleRecordTranslator;
import org.apache.storm.tuple.Fields;

public class ByTopicRecordTranslator<K, V>
implements RecordTranslator<K, V> {
    private static final long serialVersionUID = -121699733778988688L;
    private final RecordTranslator<K, V> defaultTranslator;
    private final Map<String, RecordTranslator<K, V>> topicToTranslator = new HashMap<String, RecordTranslator<K, V>>();
    private final Map<String, Fields> streamToFields = new HashMap<String, Fields>();

    public ByTopicRecordTranslator(Func<ConsumerRecord<K, V>, List<Object>> func, Fields fields, String stream) {
        this(new SimpleRecordTranslator<K, V>(func, fields, stream));
    }

    public ByTopicRecordTranslator(Func<ConsumerRecord<K, V>, List<Object>> func, Fields fields) {
        this(new SimpleRecordTranslator<K, V>(func, fields));
    }

    public ByTopicRecordTranslator(RecordTranslator<K, V> defaultTranslator) {
        this.defaultTranslator = defaultTranslator;
        this.cacheNCheckFields(defaultTranslator);
    }

    public ByTopicRecordTranslator<K, V> forTopic(String topic, Func<ConsumerRecord<K, V>, List<Object>> func, Fields fields) {
        return this.forTopic(topic, new SimpleRecordTranslator<K, V>(func, fields));
    }

    public ByTopicRecordTranslator<K, V> forTopic(String topic, Func<ConsumerRecord<K, V>, List<Object>> func, Fields fields, String stream) {
        return this.forTopic(topic, new SimpleRecordTranslator<K, V>(func, fields, stream));
    }

    public ByTopicRecordTranslator<K, V> forTopic(String topic, RecordTranslator<K, V> translator) {
        if (this.topicToTranslator.containsKey(topic)) {
            throw new IllegalStateException("Topic " + topic + " is already registered");
        }
        this.cacheNCheckFields(translator);
        this.topicToTranslator.put(topic, translator);
        return this;
    }

    private void cacheNCheckFields(RecordTranslator<K, V> translator) {
        for (String stream : translator.streams()) {
            Fields fromTrans = translator.getFieldsFor(stream);
            Fields cached = this.streamToFields.get(stream);
            if (cached != null && !fromTrans.equals((Object)cached)) {
                throw new IllegalArgumentException("Stream " + stream + " currently has Fields of " + String.valueOf(cached) + " which is not the same as those being added in " + String.valueOf(fromTrans));
            }
            if (cached != null) continue;
            this.streamToFields.put(stream, fromTrans);
        }
    }

    @Override
    public List<Object> apply(ConsumerRecord<K, V> record) {
        RecordTranslator<K, V> trans = this.topicToTranslator.getOrDefault(record.topic(), this.defaultTranslator);
        return trans.apply(record);
    }

    @Override
    public Fields getFieldsFor(String stream) {
        return this.streamToFields.get(stream);
    }

    @Override
    public List<String> streams() {
        return new ArrayList<String>(this.streamToFields.keySet());
    }
}

