/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.bolt;

import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.kafka.bolt.KafkaBolt;
import org.apache.storm.kafka.bolt.mapper.FieldNameBasedTupleToKafkaMapper;
import org.apache.storm.kafka.bolt.selector.DefaultTopicSelector;
import org.apache.storm.lambda.SerializableSupplier;
import org.apache.storm.topology.TopologyBuilder;
import org.apache.storm.utils.Utils;

public class KafkaProducerTopology {
    public static StormTopology newTopology(String brokerUrl, String topicName) {
        TopologyBuilder builder = new TopologyBuilder();
        builder.setSpout("spout", (SerializableSupplier & Serializable)() -> {
            Utils.sleep((long)1000L);
            return UUID.randomUUID().toString();
        });
        KafkaBolt bolt = new KafkaBolt().withProducerProperties(KafkaProducerTopology.newProps(brokerUrl, topicName)).withTopicSelector(new DefaultTopicSelector(topicName)).withTupleToKafkaMapper(new FieldNameBasedTupleToKafkaMapper("key", "lambda"));
        builder.setBolt("forwardToKafka", bolt, (Number)1).shuffleGrouping("spout");
        return builder.createTopology();
    }

    private static Properties newProps(final String brokerUrl, final String topicName) {
        return new Properties(){
            {
                this.put("bootstrap.servers", brokerUrl);
                this.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
                this.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
                this.put("client.id", topicName);
            }
        };
    }
}

