/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kafka.spout.trident;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.storm.kafka.spout.internal.ClientFactory;
import org.apache.storm.kafka.spout.internal.ClientFactoryDefault;
import org.apache.storm.kafka.spout.internal.Timer;
import org.apache.storm.kafka.spout.trident.KafkaTridentSpoutConfig;
import org.apache.storm.kafka.spout.trident.TopicPartitionSerializer;
import org.apache.storm.trident.spout.IOpaquePartitionedTridentSpout;
import org.apache.storm.trident.spout.IPartitionedTridentSpout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaTridentSpoutCoordinator<K, V>
implements IOpaquePartitionedTridentSpout.Coordinator<List<Map<String, Object>>>,
IPartitionedTridentSpout.Coordinator<List<Map<String, Object>>>,
Serializable {
    public static final long TIMER_DELAY_MS = 500L;
    private static final Logger LOG = LoggerFactory.getLogger(KafkaTridentSpoutCoordinator.class);
    private final TopicPartitionSerializer tpSerializer = new TopicPartitionSerializer();
    private final KafkaTridentSpoutConfig<K, V> kafkaSpoutConfig;
    private final Timer refreshAssignmentTimer;
    private final Consumer<K, V> consumer;
    private Set<TopicPartition> partitionsForBatch;

    public KafkaTridentSpoutCoordinator(KafkaTridentSpoutConfig<K, V> kafkaSpoutConfig) {
        this(kafkaSpoutConfig, new ClientFactoryDefault());
    }

    KafkaTridentSpoutCoordinator(KafkaTridentSpoutConfig<K, V> kafkaSpoutConfig, ClientFactory<K, V> clientFactory) {
        this.kafkaSpoutConfig = kafkaSpoutConfig;
        this.refreshAssignmentTimer = new Timer(500L, kafkaSpoutConfig.getPartitionRefreshPeriodMs(), TimeUnit.MILLISECONDS);
        this.consumer = clientFactory.createConsumer(kafkaSpoutConfig.getKafkaProps());
        LOG.debug("Created {}", (Object)this.toString());
    }

    public boolean isReady(long txid) {
        LOG.debug("isReady = true");
        return true;
    }

    public List<Map<String, Object>> getPartitionsForBatch() {
        if (this.refreshAssignmentTimer.isExpiredResetOnTrue() || this.partitionsForBatch == null) {
            this.partitionsForBatch = this.kafkaSpoutConfig.getTopicFilter().getAllSubscribedPartitions(this.consumer);
        }
        LOG.debug("TopicPartitions for batch {}", (Object)this.partitionsForBatch);
        return this.partitionsForBatch.stream().map(tp -> this.tpSerializer.toMap((TopicPartition)tp)).collect(Collectors.toList());
    }

    public void close() {
        this.consumer.close();
        LOG.debug("Closed");
    }

    public final String toString() {
        return super.toString() + "{kafkaSpoutConfig=" + String.valueOf(this.kafkaSpoutConfig) + "}";
    }
}

