/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.jms.trident;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.Session;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.storm.generated.StreamInfo;
import org.apache.storm.jms.JmsProvider;
import org.apache.storm.jms.JmsTupleProducer;
import org.apache.storm.jms.trident.JmsBatch;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.OutputFieldsGetter;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.spout.ITridentSpout;
import org.apache.storm.trident.topology.TransactionAttempt;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.RotatingMap;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TridentJmsSpout
implements ITridentSpout<JmsBatch> {
    public static final String MAX_BATCH_SIZE_CONF = "topology.spout.max.batch.size";
    public static final int DEFAULT_BATCH_SIZE = 1000;
    private static final long serialVersionUID = -3469351154693356655L;
    private static int nameIndex = 1;
    private JmsTupleProducer tupleProducer;
    private JmsProvider jmsProvider;
    private int jmsAcknowledgeMode = 1;
    private String name = "JmsSpout_" + nameIndex++;

    private static String toDeliveryModeString(int acknowledgeMode) {
        switch (acknowledgeMode) {
            case 1: {
                return "AUTO_ACKNOWLEDGE";
            }
            case 2: {
                return "CLIENT_ACKNOWLEDGE";
            }
            case 3: {
                return "DUPS_OK_ACKNOWLEDGE";
            }
        }
        throw new IllegalArgumentException("Unknown JMS Acknowledge mode " + acknowledgeMode + " (See jakarta.jms.Session for valid values)");
    }

    public TridentJmsSpout named(String name) {
        this.name = name;
        return this;
    }

    public TridentJmsSpout withJmsProvider(JmsProvider provider) {
        this.jmsProvider = provider;
        return this;
    }

    public TridentJmsSpout withTupleProducer(JmsTupleProducer tupleProducer) {
        this.tupleProducer = tupleProducer;
        return this;
    }

    public TridentJmsSpout withJmsAcknowledgeMode(int jmsAcknowledgeMode) {
        TridentJmsSpout.toDeliveryModeString(jmsAcknowledgeMode);
        this.jmsAcknowledgeMode = jmsAcknowledgeMode;
        return this;
    }

    public ITridentSpout.BatchCoordinator<JmsBatch> getCoordinator(String txStateId, Map<String, Object> conf, TopologyContext context) {
        return new JmsBatchCoordinator(this.name);
    }

    public ITridentSpout.Emitter<JmsBatch> getEmitter(String txStateId, Map<String, Object> conf, TopologyContext context) {
        return new JmsEmitter(this.name, this.jmsProvider, this.tupleProducer, this.jmsAcknowledgeMode, conf);
    }

    public Map<String, Object> getComponentConfiguration() {
        return null;
    }

    public Fields getOutputFields() {
        OutputFieldsGetter fieldGetter = new OutputFieldsGetter();
        this.tupleProducer.declareOutputFields((OutputFieldsDeclarer)fieldGetter);
        StreamInfo streamInfo = (StreamInfo)fieldGetter.getFieldsDeclaration().get("default");
        if (streamInfo == null) {
            throw new IllegalArgumentException("Jms Tuple producer has not declared output fields for the default stream");
        }
        return new Fields(streamInfo.get_output_fields());
    }

    private class JmsBatchCoordinator
    implements ITridentSpout.BatchCoordinator<JmsBatch> {
        private final String name;
        private final Logger log = LoggerFactory.getLogger(JmsBatchCoordinator.class);

        JmsBatchCoordinator(String name) {
            this.name = name;
            this.log.info("Created batch coordinator for " + name);
        }

        public JmsBatch initializeTransaction(long txid, JmsBatch prevMetadata, JmsBatch curMetadata) {
            this.log.debug("Initialise transaction " + txid + " for " + this.name);
            return null;
        }

        public void success(long txid) {
        }

        public boolean isReady(long txid) {
            return true;
        }

        public void close() {
        }
    }

    private class JmsEmitter
    implements ITridentSpout.Emitter<JmsBatch>,
    MessageListener {
        private final LinkedBlockingQueue<Message> queue;
        private final Connection connection;
        private final Session session;
        private final RotatingMap<Long, List<Message>> batchMessageMap;
        private final long rotateTimeMillis;
        private final int maxBatchSize;
        private final String name;
        private final Logger log = LoggerFactory.getLogger(JmsEmitter.class);
        private long lastRotate;

        JmsEmitter(String name, JmsProvider jmsProvider, JmsTupleProducer tupleProducer, int jmsAcknowledgeMode, Map<String, Object> conf) {
            if (jmsProvider == null) {
                throw new IllegalStateException("JMS provider has not been set.");
            }
            if (tupleProducer == null) {
                throw new IllegalStateException("JMS Tuple Producer has not been set.");
            }
            this.queue = new LinkedBlockingQueue();
            this.name = name;
            this.batchMessageMap = new RotatingMap(3);
            this.rotateTimeMillis = 1000L * (long)((Number)conf.get("topology.message.timeout.secs")).intValue();
            this.lastRotate = System.currentTimeMillis();
            Number batchSize = (Number)conf.get(TridentJmsSpout.MAX_BATCH_SIZE_CONF);
            this.maxBatchSize = batchSize != null ? batchSize.intValue() : 1000;
            try {
                ConnectionFactory cf = jmsProvider.connectionFactory();
                Destination dest = jmsProvider.destination();
                this.connection = cf.createConnection();
                this.session = this.connection.createSession(false, jmsAcknowledgeMode);
                MessageConsumer consumer = this.session.createConsumer(dest);
                consumer.setMessageListener((MessageListener)this);
                this.connection.start();
                this.log.info("Created JmsEmitter with max batch size " + this.maxBatchSize + " rotate time " + this.rotateTimeMillis + "ms and destination " + String.valueOf(dest) + " for " + name);
            }
            catch (Exception e) {
                this.log.warn("Error creating JMS connection.", (Throwable)e);
                throw new IllegalStateException("Could not create JMS connection for spout ", e);
            }
        }

        public void success(TransactionAttempt tx) {
            List messages = (List)this.batchMessageMap.remove((Object)tx.getTransactionId());
            if (messages != null) {
                if (!messages.isEmpty()) {
                    this.log.debug("Success for batch with transaction id " + tx.getTransactionId() + "/" + tx.getAttemptId() + " for " + this.name);
                }
                for (Message msg : messages) {
                    String messageId = "UnknownId";
                    try {
                        messageId = msg.getJMSMessageID();
                        msg.acknowledge();
                        this.log.trace("Acknowledged message " + messageId);
                    }
                    catch (JMSException e) {
                        this.log.warn("Failed to acknowledge message " + messageId, (Throwable)e);
                    }
                }
            } else {
                this.log.warn("No messages found in batch with transaction id " + tx.getTransactionId() + "/" + tx.getAttemptId());
            }
        }

        private void fail(Long transactionId, List<Message> messages) {
            this.log.debug("Failure for batch with transaction id " + transactionId + " for " + this.name);
            if (messages != null) {
                for (Message msg : messages) {
                    try {
                        this.log.trace("Failed message " + msg.getJMSMessageID());
                    }
                    catch (JMSException e) {
                        this.log.warn("Could not identify failed message ", (Throwable)e);
                    }
                }
            } else {
                this.log.warn("Failed batch has no messages with transaction id " + transactionId);
            }
        }

        public void close() {
            try {
                this.log.info("Closing JMS connection.");
                this.session.close();
                this.connection.close();
            }
            catch (JMSException e) {
                this.log.warn("Error closing JMS connection.", (Throwable)e);
            }
        }

        public void emitBatch(TransactionAttempt tx, JmsBatch coordinatorMeta, TridentCollector collector) {
            long now = System.currentTimeMillis();
            if (now - this.lastRotate > this.rotateTimeMillis) {
                Map failed = this.batchMessageMap.rotate();
                for (Long id : failed.keySet()) {
                    this.log.warn("TIMED OUT batch with transaction id " + id + " for " + this.name);
                    this.fail(id, (List)failed.get(id));
                }
                this.lastRotate = now;
            }
            if (this.batchMessageMap.containsKey((Object)tx.getTransactionId())) {
                this.log.warn("FAILED duplicate batch with transaction id " + tx.getTransactionId() + "/" + tx.getAttemptId() + " for " + this.name);
                this.fail(tx.getTransactionId(), (List)this.batchMessageMap.get((Object)tx.getTransactionId()));
            }
            ArrayList<Message> batchMessages = new ArrayList<Message>();
            for (int index = 0; index < this.maxBatchSize; ++index) {
                Message msg = this.queue.poll();
                if (msg == null) {
                    Utils.sleep((long)50L);
                    break;
                }
                try {
                    if (TridentJmsSpout.this.jmsAcknowledgeMode != 1) {
                        batchMessages.add(msg);
                    }
                    Values tuple = TridentJmsSpout.this.tupleProducer.toTuple(msg);
                    collector.emit((List)tuple);
                    continue;
                }
                catch (JMSException e) {
                    this.log.warn("Failed to emit message, could not retrieve data for " + this.name + ": " + String.valueOf((Object)e));
                }
            }
            if (!batchMessages.isEmpty()) {
                this.log.debug("Emitting batch with transaction id " + tx.getTransactionId() + "/" + tx.getAttemptId() + " and size " + batchMessages.size() + " for " + this.name);
            } else {
                this.log.trace("No items to acknowledge for batch with transaction id " + tx.getTransactionId() + "/" + tx.getAttemptId() + " for " + this.name);
            }
            this.batchMessageMap.put((Object)tx.getTransactionId(), batchMessages);
        }

        public void onMessage(Message msg) {
            try {
                this.log.trace("Queuing msg [" + msg.getJMSMessageID() + "]");
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            this.queue.offer(msg);
        }
    }
}

