/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.jms.example;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Map;
import org.apache.storm.Config;
import org.apache.storm.StormSubmitter;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.jms.JmsMessageProducer;
import org.apache.storm.jms.JmsProvider;
import org.apache.storm.jms.JmsTupleProducer;
import org.apache.storm.jms.bolt.JmsBolt;
import org.apache.storm.jms.example.GenericBolt;
import org.apache.storm.jms.example.JsonTupleProducer;
import org.apache.storm.jms.example.SpringJmsProvider;
import org.apache.storm.jms.spout.JmsSpout;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.TopologyBuilder;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.ITuple;

public class ExampleJmsTopology {
    public static final String JMS_QUEUE_SPOUT = "JMS_QUEUE_SPOUT";
    public static final String INTERMEDIATE_BOLT = "INTERMEDIATE_BOLT";
    public static final String FINAL_BOLT = "FINAL_BOLT";
    public static final String JMS_TOPIC_BOLT = "JMS_TOPIC_BOLT";
    public static final String JMS_TOPIC_SPOUT = "JMS_TOPIC_SPOUT";
    public static final String ANOTHER_BOLT = "ANOTHER_BOLT";

    public static void main(String[] args) throws Exception {
        SpringJmsProvider jmsQueueProvider = new SpringJmsProvider("jms-activemq.xml", "jmsConnectionFactory", "notificationQueue");
        JsonTupleProducer producer = new JsonTupleProducer();
        JmsSpout queueSpout = new JmsSpout();
        queueSpout.setJmsProvider((JmsProvider)jmsQueueProvider);
        queueSpout.setJmsTupleProducer((JmsTupleProducer)producer);
        queueSpout.setJmsAcknowledgeMode(2);
        TopologyBuilder builder = new TopologyBuilder();
        builder.setSpout(JMS_QUEUE_SPOUT, (IRichSpout)queueSpout, (Number)5);
        builder.setBolt(INTERMEDIATE_BOLT, (IRichBolt)new GenericBolt(INTERMEDIATE_BOLT, true, true, new Fields(new String[]{"json"})), (Number)3).shuffleGrouping(JMS_QUEUE_SPOUT);
        builder.setBolt(FINAL_BOLT, (IRichBolt)new GenericBolt(FINAL_BOLT, true, true), (Number)3).shuffleGrouping(INTERMEDIATE_BOLT);
        SpringJmsProvider jmsTopicProvider = new SpringJmsProvider("jms-activemq.xml", "jmsConnectionFactory", "notificationTopic");
        JmsBolt jmsBolt = new JmsBolt();
        jmsBolt.setJmsProvider((JmsProvider)jmsTopicProvider);
        jmsBolt.setJmsMessageProducer(new JmsMessageProducer(){

            public Message toMessage(Session session, ITuple input) throws JMSException {
                System.out.println("Sending JMS Message:" + input.toString());
                TextMessage tm = session.createTextMessage(input.toString());
                return tm;
            }
        });
        builder.setBolt(JMS_TOPIC_BOLT, (IRichBolt)jmsBolt).shuffleGrouping(INTERMEDIATE_BOLT);
        JmsSpout topicSpout = new JmsSpout();
        topicSpout.setJmsProvider((JmsProvider)jmsTopicProvider);
        topicSpout.setJmsTupleProducer((JmsTupleProducer)producer);
        topicSpout.setJmsAcknowledgeMode(2);
        topicSpout.setDistributed(false);
        builder.setSpout(JMS_TOPIC_SPOUT, (IRichSpout)topicSpout);
        builder.setBolt(ANOTHER_BOLT, (IRichBolt)new GenericBolt(ANOTHER_BOLT, true, true), (Number)1).shuffleGrouping(JMS_TOPIC_SPOUT);
        Config conf = new Config();
        String topoName = "storm-jms-example";
        if (args.length > 0) {
            topoName = args[0];
        }
        conf.setNumWorkers(3);
        StormSubmitter.submitTopology((String)topoName, (Map)conf, (StormTopology)builder.createTopology());
    }
}

